/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.ButtonComposite;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class SpinnerWrapper
extends ButtonComposite
implements IFieldWidget {
    protected Spinner spinner;
    private ModifyListener modifyListener;

    public SpinnerWrapper(Composite parent, int style) {
        super(parent, 0);
        this.setLayout(new BorderLayout());
        this.spinner = new Spinner((Composite)this, style);
        this.spinner.setLayoutData((Object)"Center");
        this.mainControl = this.spinner;
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValueEvent evt = new ValueEvent(SpinnerWrapper.this.spinner, SpinnerWrapper.this.getFieldName());
                evt.setValue(SpinnerWrapper.this.getValue());
                SpinnerWrapper.this.eventDelegate.notifyValueListeners(evt);
            }
        };
        this.spinner.addModifyListener(this.modifyListener);
    }

    @Override
    public void dispose() {
        if (this.spinner != null && !this.spinner.isDisposed()) {
            this.spinner.removeModifyListener(this.modifyListener);
        }
        super.dispose();
    }

    @Override
    public Object getValue() {
        return this.spinner.getSelection();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.spinner.setSelection(this.spinner.getMinimum());
            return;
        }
        if (value instanceof String) {
            double dblValue = Double.valueOf((String)value);
            long rounded = Math.round(dblValue);
            value = Integer.parseInt(new Long(rounded).toString());
        }
        this.spinner.setSelection(((Number)value).intValue());
        if (this.notifyType != null && (this.notifyType == FieldComposite.NOTIFY_TYPE.ALWAYS || this.notifyType == FieldComposite.NOTIFY_TYPE.VALUE_CHANGED)) {
            ValueEvent evt = new ValueEvent(this.spinner, this.getFieldName());
            evt.setValue(this.getValue());
            this.eventDelegate.notifyValueListeners(evt);
        }
    }

    public void setToolTipText(String text) {
        this.spinner.setToolTipText(text);
    }

    protected void checkSubclass() {
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.spinner.setVisible(active);
    }

    public void setMaximum(int i) {
        this.spinner.setMaximum(i);
    }

    public void setMinimum(int i) {
        this.spinner.setMinimum(i);
    }

    public void setDigits(int i) {
        this.spinner.setDigits(i);
    }

    public void setIncrement(int i) {
        this.spinner.setIncrement(i);
    }

    public int getMaximum() {
        return this.spinner.getMaximum();
    }

    public int getMinimum() {
        return this.spinner.getMinimum();
    }
}

