/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import com.swtdesigner.SWTResourceManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import uk.ac.gda.richbeans.components.wrappers.TextWrapper;

public class RegularExpressionTextWrapper
extends TextWrapper {
    protected CLabel messageLabel;
    protected Image errorImage;
    protected Image nameImage;
    protected Pattern pattern;
    private ModifyListener modifyListener;
    private boolean toolTipTextOverridden = false;

    public RegularExpressionTextWrapper(Composite parent, int style, Pattern pattern) {
        super(parent, style);
        this.pattern = pattern;
        this.messageLabel = new CLabel((Composite)this, 0);
        this.messageLabel.setLayoutData((Object)"East");
        this.errorImage = SWTResourceManager.getImage(RegularExpressionTextWrapper.class, "/icons/error.png");
        this.nameImage = SWTResourceManager.getImage(RegularExpressionTextWrapper.class, "/icons/tick.png");
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegularExpressionTextWrapper.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RegularExpressionTextWrapper.this.checkValue();
                    }
                });
            }
        };
        this.text.addModifyListener(this.modifyListener);
    }

    @Override
    public void dispose() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
            this.text.dispose();
        }
        super.dispose();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.checkValue();
    }

    protected void checkValue() {
        if (!this.isActivated() || !this.isOn()) {
            return;
        }
        Object newValue = this.getValue();
        if (newValue == null || "".equals(newValue)) {
            this.setWrongValue(newValue);
            return;
        }
        try {
            Matcher matcher = this.pattern.matcher((String)newValue);
            if (matcher.matches()) {
                this.setRightValue(newValue);
            } else {
                this.setWrongValue(newValue);
            }
        }
        catch (Exception exception) {
            this.setWrongValue(null);
        }
        this.layout();
        this.redraw();
    }

    protected void setRightValue(Object value) {
        this.messageLabel.setImage(this.getNameImage());
        this.text.setForeground(BLACK);
        if (!this.toolTipTextOverridden) {
            this.setToolTipText("The value '" + value + "' is valid.");
        }
    }

    protected void setWrongValue(Object value) {
        this.messageLabel.setImage(this.getErrorImage());
        this.text.setForeground(RED);
        if (!this.toolTipTextOverridden) {
            this.setToolTipText("The value '" + value + "' is not valid.");
        }
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.messageLabel.setToolTipText(text);
        this.text.setToolTipText(text);
        this.toolTipTextOverridden = true;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public void setErrorImage(Image errorImage) {
        this.errorImage = errorImage;
    }

    public Image getNameImage() {
        return this.nameImage;
    }

    public void setNameImage(Image nameImage) {
        this.nameImage = nameImage;
    }
}

