/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class RadioWrapper
extends Group
implements IFieldWidget {
    protected final EventManagerDelegate eventDelegate;
    protected final Map<String, Button> buttonMap;
    protected final Map<String, SelectionListener> listenerMap;
    private boolean isOn = false;
    private boolean active = true;
    protected String fieldName;

    public RadioWrapper(Composite parent, int style, String[] items) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout());
        this.eventDelegate = new EventManagerDelegate(this);
        this.buttonMap = new HashMap<String, Button>(7);
        this.listenerMap = new HashMap<String, SelectionListener>(7);
        int i = 0;
        while (i < items.length) {
            final Button button = new Button((Composite)this, 0x10 | style);
            button.setText(items[i]);
            this.buttonMap.put(items[i], button);
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValueEvent evt = new ValueEvent(button, RadioWrapper.this.getFieldName());
                    evt.setValue(RadioWrapper.this.getValue());
                    RadioWrapper.this.eventDelegate.notifyValueListeners(evt);
                }
            };
            this.listenerMap.put(items[i], (SelectionListener)selectionListener);
            button.addSelectionListener((SelectionListener)selectionListener);
            ++i;
        }
    }

    @Override
    public void dispose() {
        for (String key : this.buttonMap.keySet()) {
            this.buttonMap.get(key).removeSelectionListener(this.listenerMap.get(key));
        }
        super.dispose();
    }

    @Override
    public Object getValue() {
        for (String label : this.buttonMap.keySet()) {
            if (!this.buttonMap.get(label).getSelection()) continue;
            return label;
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        for (String label : this.buttonMap.keySet()) {
            if (label.equals(value)) {
                this.buttonMap.get(label).setSelection(true);
                continue;
            }
            this.buttonMap.get(label).setSelection(false);
        }
    }

    public void clear() {
        for (String label : this.buttonMap.keySet()) {
            this.buttonMap.get(label).setSelection(false);
        }
    }

    protected void checkSubclass() {
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void off() {
        this.isOn = false;
    }

    @Override
    public void on() {
        this.isOn = true;
    }

    @Override
    public boolean isActivated() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.setVisible(active);
    }

    @Override
    public void addValueListener(ValueListener l) {
        this.eventDelegate.addValueListener(l);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void fireValueListeners() {
        ValueEvent evt = new ValueEvent(this, this.getFieldName());
        evt.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(evt);
    }

    @Override
    public void fireBoundsUpdaters() {
        ValueEvent evt = new ValueEvent(this, this.getFieldName());
        evt.setValue(this.getValue());
        this.eventDelegate.notifyBoundsProviderListeners(evt);
    }

    @Override
    public void removeValueListener(ValueListener listener) {
        this.eventDelegate.removeValueListener(listener);
    }
}

