/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class PrintfWrapper
extends FieldComposite
implements IFieldWidget {
    private static final String[] DEFAULT_FORMATS = new String[]{"10.7f", "5.2f", "6.4f", "10.7g", "5.2g", "6.4g"};
    protected final Combo combo;
    protected final Label formatLabel;
    protected AutoCompleteField autoComplete;
    private SelectionAdapter selectionListener;
    private ModifyListener modifyListener;
    private SelectionAdapter oneListener;
    private SelectionAdapter hundredListener;
    private SelectionAdapter ninesListener;
    private MenuItem oneItem;
    private MenuItem hundredItem;
    private MenuItem ninesItem;
    private Double templateFormatNumber = 1.0;

    public PrintfWrapper(Composite parent, int style) {
        super(parent, 0);
        this.setLayout(new BorderLayout());
        this.combo = new Combo((Composite)this, style);
        this.combo.setLayoutData((Object)"Center");
        this.mainControl = this.combo;
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEvent evt = new ValueEvent(PrintfWrapper.this.combo, PrintfWrapper.this.getFieldName());
                evt.setDoubleValue(PrintfWrapper.this.combo.getSelectionIndex());
                evt.setValue(PrintfWrapper.this.getValue());
                PrintfWrapper.this.eventDelegate.notifyValueListeners(evt);
            }
        };
        this.combo.addSelectionListener((SelectionListener)this.selectionListener);
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String txt = PrintfWrapper.this.combo.getText();
                PrintfWrapper.this.addDrop(txt);
                ValueEvent evt = new ValueEvent(PrintfWrapper.this.combo, PrintfWrapper.this.getFieldName());
                evt.setDoubleValue(PrintfWrapper.this.combo.getSelectionIndex());
                evt.setValue(PrintfWrapper.this.getValue());
                PrintfWrapper.this.eventDelegate.notifyValueListeners(evt);
            }
        };
        this.combo.addModifyListener(this.modifyListener);
        this.formatLabel = new Label((Composite)this, 0);
        this.formatLabel.setAlignment(0x1000000);
        this.formatLabel.setLayoutData((Object)"East");
        this.formatLabel.setText("        ");
        this.formatLabel.setToolTipText("This is " + this.templateFormatNumber + " formatted with the current format. Right click to change the test number.");
        Menu menu = new Menu((Control)this.formatLabel);
        this.formatLabel.setMenu(menu);
        this.oneItem = new MenuItem(menu, 0);
        this.oneItem.setText("Format '1.0'");
        this.oneListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintfWrapper.this.templateFormatNumber = 1.0;
                PrintfWrapper.this.updateFormat(String.valueOf(PrintfWrapper.this.getValue()));
            }
        };
        this.oneItem.addSelectionListener((SelectionListener)this.oneListener);
        this.hundredItem = new MenuItem(menu, 0);
        this.hundredItem.setText("Format '100.0001'");
        this.hundredListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintfWrapper.this.templateFormatNumber = 100.0001;
                PrintfWrapper.this.updateFormat(String.valueOf(PrintfWrapper.this.getValue()));
            }
        };
        this.hundredItem.addSelectionListener((SelectionListener)this.hundredListener);
        this.ninesItem = new MenuItem(menu, 0);
        this.ninesItem.setText("Format '99999'");
        this.ninesListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintfWrapper.this.templateFormatNumber = 99999.0;
                PrintfWrapper.this.updateFormat(String.valueOf(PrintfWrapper.this.getValue()));
            }
        };
        this.ninesItem.addSelectionListener((SelectionListener)this.ninesListener);
        this.setItems(DEFAULT_FORMATS);
    }

    @Override
    public void dispose() {
        this.combo.removeSelectionListener((SelectionListener)this.selectionListener);
        this.combo.removeModifyListener(this.modifyListener);
        this.oneItem.removeSelectionListener((SelectionListener)this.oneListener);
        this.hundredItem.removeSelectionListener((SelectionListener)this.hundredListener);
        this.ninesItem.removeSelectionListener((SelectionListener)this.ninesListener);
        super.dispose();
    }

    private void addDrop(String txt) {
        if (!this.updateFormat(txt)) {
            return;
        }
        ArrayList<String> itemList = new ArrayList<String>(11);
        itemList.addAll(Arrays.asList(this.combo.getItems()));
        if (!itemList.contains(txt)) {
            itemList.add(0, txt);
            this.setItems(itemList.toArray(new String[itemList.size()]));
            this.combo.setText(txt);
        }
    }

    private boolean updateFormat(String txt) {
        try {
            String form = txt.startsWith("%") ? txt : "%" + txt;
            String format = String.format(form, this.templateFormatNumber);
            this.formatLabel.setText("   " + format + "   ");
            this.layout();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setItems(String[] items) {
        this.combo.setItems(items);
        if (this.autoComplete == null) {
            this.autoComplete = new AutoCompleteField((Control)this.combo, (IControlContentAdapter)new ComboContentAdapter(), items);
        }
        this.autoComplete.setProposals(items);
    }

    @Override
    public String getValue() {
        String text = this.combo.getText();
        int index = this.combo.getSelectionIndex();
        if (index < 0 && text != null) {
            return text;
        }
        if (index > -1) {
            return this.combo.getItem(index);
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.combo.clearSelection();
            if (this.combo.getSelectionIndex() != -1) {
                throw new IllegalArgumentException("Attempted to clearSelection of Read Only PrintfWrapper " + this.getFieldName());
            }
            return;
        }
        String textValue = value.toString();
        int index = this.combo.indexOf(textValue);
        if (index < 0) {
            this.combo.setText(textValue);
            this.addDrop(textValue);
        } else {
            this.combo.select(index);
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.combo.setVisible(active);
    }

    public void setTextLimit(int i) {
        this.combo.setTextLimit(i);
    }

    public void select(int indexOf) {
        this.combo.select(indexOf);
    }

    public void setForeground(Color systemColor) {
        if (systemColor.isDisposed()) {
            return;
        }
        this.combo.setForeground(systemColor);
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public String getItem(int index) {
        return this.combo.getItem(index);
    }

    public String[] getItems() {
        return this.combo.getItems();
    }
}

