/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.ui.utils.StringUtils;

public class LabelWrapper
extends FieldComposite {
    private int decimalPlaces = 2;
    private Label label;
    private NumberFormat numberFormat;
    private String text;
    private TEXT_TYPE textType;
    private String unit;

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        this.numberFormat.setMaximumFractionDigits(decimalPlaces);
    }

    public LabelWrapper(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.label = new Label((Composite)this, style);
        this.mainControl = this.label;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(this.decimalPlaces);
        this.numberFormat.setGroupingUsed(false);
    }

    @Override
    public String getValue() {
        return this.text;
    }

    public void setTextType(TEXT_TYPE type) {
        this.textType = type;
    }

    @Override
    public void setValue(Object value) {
        if (this.textType == null || this.textType == TEXT_TYPE.NUMBER_WITH_UNIT) {
            this.text = value != null ? this.numberFormat.format(value) : "";
            String boxValue = "";
            if (!"".equals(this.text)) {
                boxValue = StringUtils.keepDigits(this.text, this.decimalPlaces).toString();
                if (this.unit != null) {
                    boxValue = String.valueOf(boxValue) + " " + this.unit;
                }
            }
            this.label.setText(boxValue);
        } else {
            this.text = value != null ? "" + value : "";
            this.label.setText(this.text);
        }
        if (this.notifyType != null && this.notifyType == FieldComposite.NOTIFY_TYPE.VALUE_CHANGED) {
            ValueEvent evt = new ValueEvent(this.label, this.getFieldName());
            evt.setValue(value);
            this.eventDelegate.notifyValueListeners(evt);
        }
    }

    public double getNumericValue() throws ParseException {
        String val = this.getValue();
        if (val == null) {
            return Double.NaN;
        }
        if (val instanceof Number) {
            return ((Number)((Object)val)).doubleValue();
        }
        return this.numberFormat.parse(val.toString()).doubleValue();
    }

    protected void checkSubclass() {
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setText(String text) {
        if (this.textType == TEXT_TYPE.NUMBER_WITH_UNIT && this.getUnit() != null) {
            this.label.setText(String.valueOf(text) + " " + this.unit);
        } else {
            this.label.setText(text);
        }
    }

    public void setAlignment(int alignment) {
        this.label.setAlignment(alignment);
    }

    public static enum TEXT_TYPE {
        PLAIN_TEXT,
        NUMBER_WITH_UNIT;

    }
}

