/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.components.wrappers.SpinnerWrapper;
import uk.ac.gda.richbeans.event.ValueEvent;

public class FloatSpinnerWrapper
extends SpinnerWrapper {
    private int width;
    private int precision;
    private int maximumValue;
    private double factor;

    public FloatSpinnerWrapper(Composite parent, int style) {
        this(parent, style, 3, 1);
    }

    public FloatSpinnerWrapper(Composite parent, int style, int width, int precision) {
        super(parent, style);
        this.setFormat(width, precision);
    }

    public void setFormat(int width, int precision) {
        this.precision = precision;
        this.setWidth(width);
        this.maximumValue = (int)Math.pow(10.0, width);
        this.factor = Math.pow(10.0, precision);
        this.spinner.setDigits(precision);
        this.spinner.setMinimum(-this.maximumValue);
        this.spinner.setMaximum(this.maximumValue);
        this.spinner.setIncrement(1);
        this.spinner.setPageIncrement(5);
        this.spinner.setSelection(0);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.spinner.setSelection(this.spinner.getMinimum());
            return;
        }
        this.spinner.setSelection((int)(((Number)value).doubleValue() * this.factor));
        if (this.notifyType != null && (this.notifyType == FieldComposite.NOTIFY_TYPE.ALWAYS || this.notifyType == FieldComposite.NOTIFY_TYPE.VALUE_CHANGED)) {
            ValueEvent evt = new ValueEvent(this.spinner, this.getFieldName());
            evt.setValue(this.getValue());
            this.eventDelegate.notifyValueListeners(evt);
        }
    }

    @Override
    public Object getValue() {
        return (double)this.spinner.getSelection() / this.factor;
    }

    public void setFloat(double value) {
        this.setValue(value);
    }

    public double getFloat() {
        return ((Number)this.getValue()).doubleValue();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.spinner.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (!this.spinner.isDisposed()) {
            this.spinner.removeSelectionListener(listener);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.spinner.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        if (!this.spinner.isDisposed()) {
            this.spinner.removeModifyListener(listener);
        }
    }

    public void setMinimum(double minimum) {
        this.spinner.setMinimum((int)(minimum * this.factor));
    }

    public void setMaximum(double maximum) {
        this.spinner.setMaximum((int)(maximum * this.factor));
    }
}

