/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.ButtonComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class ComboWrapper
extends ButtonComposite
implements IFieldWidget {
    protected final Combo combo;
    protected AutoCompleteField autoComplete;
    protected Map<String, ?> itemMap;
    private SelectionAdapter selectionListener;
    private ModifyListener modifyListener;

    public ComboWrapper(Composite parent, int style) {
        super(parent, 0);
        this.setLayout(new BorderLayout());
        int textStyle = style == 0 ? 2048 : style;
        this.combo = new Combo((Composite)this, textStyle);
        this.combo.setLayoutData((Object)"Center");
        this.mainControl = this.combo;
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComboWrapper.this.fireValueListeners();
            }
        };
        this.combo.addSelectionListener((SelectionListener)this.selectionListener);
        this.modifyListener = new ModifyListener(){
            private List<String> items;

            public void modifyText(ModifyEvent e) {
                String txt = ComboWrapper.this.combo.getText();
                if (this.items == null) {
                    this.items = Arrays.asList(ComboWrapper.this.combo.getItems());
                }
                if (this.items.contains(txt)) {
                    ComboWrapper.this.fireValueListeners();
                }
            }
        };
        this.combo.addModifyListener(this.modifyListener);
    }

    @Override
    public void setFieldName(String fieldName) {
        super.setFieldName(fieldName);
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setToolTipText(fieldName);
        }
    }

    @Override
    public void dispose() {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.removeSelectionListener((SelectionListener)this.selectionListener);
            this.combo.removeModifyListener(this.modifyListener);
        }
        super.dispose();
    }

    @Override
    public void fireValueListeners() {
        ValueEvent evt = new ValueEvent(this.combo, this.getFieldName());
        evt.setDoubleValue(this.combo.getSelectionIndex());
        evt.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(evt);
    }

    public void setItems(Map<String, ?> itemMap) {
        this.setItems(itemMap.keySet().toArray(new String[itemMap.size()]));
        this.itemMap = itemMap;
    }

    public void setItems(String[] items) {
        this.combo.setItems(items);
        if (this.autoComplete == null) {
            this.autoComplete = new AutoCompleteField((Control)this.combo, (IControlContentAdapter)new ComboContentAdapter(), items);
        }
        this.autoComplete.setProposals(items);
    }

    @Override
    public Object getValue() {
        if (this.combo == null) {
            return null;
        }
        if (this.combo.isDisposed()) {
            return null;
        }
        String text = this.combo.getText();
        int index = this.combo.getSelectionIndex();
        if (index < 0 && text != null) {
            return this.itemMap != null ? this.itemMap.get(text) : text;
        }
        if (index > -1) {
            return this.itemMap != null ? this.itemMap.get(this.combo.getItem(index)) : this.combo.getItem(index);
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        String textValue;
        if (value == null) {
            this.combo.clearSelection();
            if (this.combo.getSelectionIndex() != -1) {
                throw new IllegalArgumentException("Attempted to clearSelection of Read Only ComboWrapper " + this.getFieldName());
            }
            return;
        }
        String string = textValue = this.itemMap != null ? this.getKeyForValue(value) : value.toString();
        if (textValue == null && this.itemMap != null && !this.itemMap.isEmpty()) {
            textValue = this.itemMap.keySet().iterator().next();
        }
        if (textValue != null) {
            int index = this.combo.indexOf(textValue);
            if (index < 0) {
                this.combo.clearSelection();
                if (this.combo.getSelectionIndex() != -1) {
                    throw new IllegalArgumentException("Attempted to clearSelection of Read Only ComboWrapper " + this.getFieldName());
                }
            } else {
                this.combo.select(index);
            }
        }
    }

    private String getKeyForValue(Object value) {
        if (this.itemMap == null) {
            return null;
        }
        if (value == null) {
            return null;
        }
        for (Map.Entry<String, ?> entry : this.itemMap.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.combo.setVisible(active);
    }

    public void setTextLimit(int i) {
        this.combo.setTextLimit(i);
    }

    public void select(int indexOf) {
        this.combo.select(indexOf);
    }

    public void setForeground(Color systemColor) {
        if (systemColor.isDisposed()) {
            return;
        }
        this.combo.setForeground(systemColor);
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public String getItem(int index) {
        if (this.itemMap != null) {
            throw new RuntimeException("Cannot use getItem() when values are mapped!");
        }
        return this.combo.getItem(index);
    }

    public String[] getItems() {
        if (this.itemMap != null) {
            throw new RuntimeException("Cannot use getItems() when values are mapped!");
        }
        return this.combo.getItems();
    }

    public static Map<String, Integer> getItemMap(String[] items) {
        LinkedHashMap<String, Integer> ret = new LinkedHashMap<String, Integer>(items.length);
        int i = 0;
        while (i < items.length) {
            ret.put(items[i], i);
            ++i;
        }
        return ret;
    }
}

