/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class BooleanWrapper
extends FieldComposite {
    private BOOLEAN_MODE booleanMode;
    private Button checkBox;
    private SelectionAdapter selectionListener;

    public BooleanWrapper(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.checkBox = new Button((Composite)this, style | 0x20);
        this.mainControl = this.checkBox;
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEvent evt = new ValueEvent(BooleanWrapper.this.checkBox, BooleanWrapper.this.getFieldName());
                evt.setValue(BooleanWrapper.this.getValue());
                BooleanWrapper.this.eventDelegate.notifyValueListeners(evt);
            }
        };
        this.checkBox.addSelectionListener((SelectionListener)this.selectionListener);
    }

    @Override
    public void dispose() {
        if (this.checkBox != null && !this.checkBox.isDisposed()) {
            this.checkBox.removeSelectionListener((SelectionListener)this.selectionListener);
        }
        super.dispose();
    }

    public void setBooleanMode(BOOLEAN_MODE booleanMode) {
        this.booleanMode = booleanMode;
    }

    @Override
    public Boolean getValue() {
        boolean value = this.checkBox.getSelection();
        if (this.booleanMode == null || this.booleanMode == BOOLEAN_MODE.DIRECT) {
            return value;
        }
        return !value;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Boolean)) {
            throw new RuntimeException("Cannot parse " + value + " to Boolean.");
        }
        if (this.booleanMode == null || this.booleanMode == BOOLEAN_MODE.DIRECT) {
            this.checkBox.setSelection(((Boolean)value).booleanValue());
        } else {
            this.checkBox.setSelection((Boolean)value == false);
        }
    }

    protected void checkSubclass() {
    }

    public void setText(String string) {
        this.checkBox.setText(string);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.checkBox.setToolTipText(string);
    }

    public static enum BOOLEAN_MODE {
        DIRECT,
        REVERSE;

    }
}

