/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import com.swtdesigner.SWTResourceManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditor;
import uk.ac.gda.richbeans.components.selector.ListEditorUI;
import uk.ac.gda.richbeans.event.ValueEvent;

public final class VerticalListEditor
extends ListEditor {
    protected TableViewer listViewer;
    protected final Button add;
    protected final Button delete;
    protected final Button up;
    protected final Button down;
    private ISelectionChangedListener selectionChangedListener;
    private SelectionAdapter addListener;
    private SelectionAdapter deleteListener;
    private SelectionAdapter upListener;
    private SelectionAdapter downListener;
    private boolean requireSelectionPack = true;
    private String[] additionalFields;
    private int[] columnWidths = new int[]{300};
    protected boolean labelProivderAdded = false;
    protected List<TableViewerColumn> extraColumns;
    private boolean isShowingAdditionalFields = false;

    public VerticalListEditor(Composite par, int switches) {
        super(par, switches, VerticalListEditor.class.getName());
        this.eventDelegate = new EventManagerDelegate(this);
        this.setLayout((Layout)new GridLayout(1, false));
        this.listViewer = new TableViewer((Composite)this, 2820);
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!VerticalListEditor.this.isOn()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                BeanWrapper bean = (BeanWrapper)selection.getFirstElement();
                VerticalListEditor.super.setSelectedBean(bean, true);
                if (VerticalListEditor.this.requireSelectionPack) {
                    VerticalListEditor.this.pack(true);
                }
            }
        };
        this.listViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.listViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.setListHeight(100);
        Composite buttonsPanel = new Composite((Composite)this, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        buttonsPanel.setLayout((Layout)gridLayout_1);
        buttonsPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.add = new Button(buttonsPanel, 0);
        this.add.setImage(SWTResourceManager.getImage(VerticalListEditor.class, "add.png"));
        this.add.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.add.setText("Add");
        this.addListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VerticalListEditor.this.getListEditorUI().isAddAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.addBean();
            }
        };
        this.add.addSelectionListener((SelectionListener)this.addListener);
        this.delete = new Button(buttonsPanel, 0);
        this.delete.setImage(SWTResourceManager.getImage(VerticalListEditor.class, "delete.png"));
        this.delete.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.delete.setText("Delete");
        this.deleteListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VerticalListEditor.this.getListEditorUI().isDeleteAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.deleteBean();
            }
        };
        this.delete.addSelectionListener((SelectionListener)this.deleteListener);
        this.up = new Button(buttonsPanel, 4);
        this.up.setText("button");
        this.upListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VerticalListEditor.this.getListEditorUI().isReorderAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.moveBean(-1);
            }
        };
        this.up.addSelectionListener((SelectionListener)this.upListener);
        this.down = new Button(buttonsPanel, 1028);
        this.down.setText("button");
        this.downListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VerticalListEditor.this.editorUI instanceof ListEditorUI && !((ListEditorUI)VerticalListEditor.this.editorUI).isReorderAllowed(VerticalListEditor.this)) {
                    return;
                }
                VerticalListEditor.this.moveBean(1);
            }
        };
        this.down.addSelectionListener((SelectionListener)this.downListener);
        MenuManager man = new MenuManager();
        man.add((IAction)new Action("Compare", 2){
            private boolean show;
            {
                this.show = false;
            }

            public void run() {
                this.show = !this.show;
                VerticalListEditor.this.setShowAdditionalFields(this.show);
            }
        });
        Menu menu = man.createContextMenu(this.listViewer.getControl());
        this.listViewer.getControl().setMenu(menu);
        this.editorUI = null;
    }

    @Override
    public void dispose() {
        if (this.listViewer != null && !this.listViewer.getControl().isDisposed()) {
            this.listViewer.removeSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.listViewer != null && !this.add.isDisposed()) {
            this.add.removeSelectionListener((SelectionListener)this.addListener);
        }
        if (this.delete != null && !this.delete.isDisposed()) {
            this.delete.removeSelectionListener((SelectionListener)this.deleteListener);
        }
        if (this.up != null && !this.up.isDisposed()) {
            this.up.removeSelectionListener((SelectionListener)this.upListener);
        }
        if (this.down != null && !this.down.isDisposed()) {
            this.down.removeSelectionListener((SelectionListener)this.downListener);
        }
        super.dispose();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.listViewer.getTable().setEnabled(isEnabled);
        this.add.setEnabled(isEnabled);
        this.delete.setEnabled(isEnabled);
        this.up.setEnabled(isEnabled);
        this.down.setEnabled(isEnabled);
        if (isEnabled) {
            this.updateButtons();
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.listViewer;
    }

    public void addBean() {
        try {
            this.addBean(this.beanTemplate.getClass().newInstance());
        }
        catch (Exception ne) {
            ne.printStackTrace();
        }
    }

    public void addBean(Object bean) throws ClassCastException {
        this.addBean(bean, this.getSelectedIndex() + 1);
    }

    public void addBean(Object bean, int index) throws ClassCastException {
        if (!this.beanTemplate.getClass().isInstance(bean)) {
            throw new ClassCastException("Bean passed to addBean is not an instance of beanTemplate.getClass()");
        }
        BeanWrapper wrapper = new BeanWrapper(bean);
        String wrapperName = this.getFreeName(wrapper, this.getTemplateName(), index);
        wrapper.setName(wrapperName);
        this.updateName(wrapper);
        if (index < 0) {
            this.beans.add(wrapper);
        } else {
            this.beans.add(index, wrapper);
        }
        this.createProviders();
        this.listViewer.refresh();
        this.setSelectedBean(wrapper, true);
        this.listViewer.getControl().setFocus();
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    public void deleteBean() {
        BeanWrapper bean = this.getSelectedBeanWrapper();
        int index = this.beans.indexOf(bean);
        this.beans.remove(bean);
        this.lastSelectionBean = null;
        if (!this.beans.isEmpty()) {
            if (index > this.beans.size() - 1) {
                --index;
            }
            if (index < 0) {
                index = 0;
            }
            this.setSelectedBean((BeanWrapper)this.beans.get(index), true);
            this.listViewer.getControl().setFocus();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
        this.listViewer.refresh();
    }

    @Override
    protected void setSelectedBean(BeanWrapper wrapper, boolean fireListeners) {
        this.listViewer.setSelection((ISelection)new StructuredSelection((Object)wrapper), true);
        super.setSelectedBean(wrapper, fireListeners);
    }

    public void moveBean(int moveAmount) {
        BeanWrapper bean = this.getSelectedBeanWrapper();
        int index = this.beans.indexOf(bean);
        bean = (BeanWrapper)this.beans.remove(index);
        int newIndex = index + moveAmount;
        this.beans.add(newIndex, bean);
        this.lastSelectionBean = null;
        if (!this.beans.isEmpty()) {
            this.setSelectedBean((BeanWrapper)this.beans.get(newIndex), true);
            this.listViewer.getControl().setFocus();
        }
        this.notifyValueListeners();
        this.listViewer.refresh();
    }

    @Override
    protected void valueChanged(ValueEvent e) throws Exception {
        super.valueChanged(e);
        if (this.getNameField() != null && this.getNameField().equalsIgnoreCase(e.getFieldName()) || this.isShowingAdditionalFields) {
            this.updateName(this.lastSelectionBean);
            this.listViewer.refresh((Object)this.lastSelectionBean);
        }
    }

    @Override
    protected void updateButtons() {
        int selected = this.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        boolean reorderAllowed = this.getListEditorUI().isReorderAllowed(this);
        boolean addAllowed = this.getListEditorUI().isAddAllowed(this);
        boolean deleteAllowed = this.getListEditorUI().isDeleteAllowed(this);
        this.up.setEnabled(selected > 0 && reorderAllowed && this.isEnabled());
        this.down.setEnabled(reorderAllowed && selected < this.beans.size() - 1 && this.isEnabled());
        if (this.maxItems > 0) {
            this.add.setEnabled(addAllowed && this.beans.size() < this.maxItems && this.isEnabled());
        } else {
            this.add.setEnabled(addAllowed && this.isEnabled());
        }
        if (this.minItems > 0) {
            this.delete.setEnabled(deleteAllowed && this.beans.size() > this.minItems && this.isEnabled());
        } else if (this.beans.isEmpty()) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(deleteAllowed && this.isEnabled());
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.listViewer.getTable().getSelectionIndex();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.createProviders();
        if (!this.listViewer.getControl().isDisposed()) {
            this.listViewer.refresh();
        }
        try {
            if (!this.beans.isEmpty()) {
                this.setSelectedBean((BeanWrapper)this.beans.get(0), true);
            } else if (this.listeners != null) {
                BeanSelectionEvent evt = new BeanSelectionEvent(this, -1, null);
                for (BeanSelectionListener l : this.listeners) {
                    l.selectionChanged(evt);
                }
            }
            if (!this.listViewer.getControl().isDisposed()) {
                this.listViewer.refresh();
            }
        }
        finally {
            this.updateEditingUIVisibility();
            this.notifyValueListeners();
        }
    }

    private void createProviders() {
        if (this.listViewer.getContentProvider() == null) {
            this.listViewer.setContentProvider((IContentProvider)new BeanListProvider());
            this.createLabelProvider();
            if (!this.listViewer.getControl().isDisposed()) {
                this.listViewer.setInput(new Object());
            }
        }
    }

    public void setAdditionalFields(String[] fields) {
        this.additionalFields = fields;
    }

    public void setColumnWidths(int[] widths) {
        this.columnWidths = widths;
    }

    protected void createLabelProvider() {
        if (this.labelProivderAdded) {
            return;
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.listViewer, (int)2);
        TableViewerColumn name = new TableViewerColumn(this.listViewer, 0, 0);
        if (this.getNameField() != null) {
            name.getColumn().setText(BeansFactory.getFieldWithUpperCaseFirstLetter((String)this.getNameField()));
        } else {
            name.getColumn().setText("Name");
        }
        name.getColumn().setWidth(this.columnWidths[0]);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                BeanWrapper bean = (BeanWrapper)element;
                String name = bean.getName();
                return name != null ? name : "null";
            }

            public String getToolTipText(Object element) {
                return VerticalListEditor.this.additionalFields != null ? "Right click to choose compare mode." : "";
            }
        });
        if (this.additionalFields != null) {
            this.extraColumns = new ArrayList<TableViewerColumn>(this.additionalFields.length);
            int i = 0;
            while (i < this.additionalFields.length) {
                final String additionalField = BeansFactory.getFieldWithUpperCaseFirstLetter((String)this.additionalFields[i]);
                TableViewerColumn col = new TableViewerColumn(this.listViewer, 0, i + 1);
                this.extraColumns.add(col);
                col.getColumn().setText(additionalField);
                col.getColumn().setWidth(0);
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        BeanWrapper bean = (BeanWrapper)element;
                        Object ob = bean.getBean();
                        try {
                            Method method = ob.getClass().getMethod("get" + additionalField, new Class[0]);
                            return method.invoke(ob, new Object[0]).toString();
                        }
                        catch (Exception e) {
                            return e.getMessage();
                        }
                    }
                });
                ++i;
            }
        }
        this.labelProivderAdded = true;
    }

    public void setShowAdditionalFields(boolean b) {
        this.isShowingAdditionalFields = b;
        this.listViewer.getTable().setHeaderVisible(b);
        int colIndex = 1;
        for (TableViewerColumn col : this.extraColumns) {
            if (b) {
                col.getColumn().setWidth(colIndex < this.columnWidths.length ? this.columnWidths[colIndex] : 200);
            } else {
                col.getColumn().setWidth(0);
            }
            ++colIndex;
        }
    }

    public boolean isRequireSelectionPack() {
        return this.requireSelectionPack;
    }

    public void setRequireSelectionPack(boolean requireSelectionPack) {
        this.requireSelectionPack = requireSelectionPack;
    }

    private class BeanListProvider
    implements IStructuredContentProvider {
        private BeanListProvider() {
        }

        public Object[] getElements(Object ignored) {
            return VerticalListEditor.this.beans.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
        }
    }
}

