/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.FieldBeanComposite;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditorUI;
import uk.ac.gda.richbeans.components.selector.ListEditorUIAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public abstract class ListEditor
extends FieldBeanComposite {
    private static final Logger logger = LoggerFactory.getLogger(ListEditor.class);
    protected final List<BeanWrapper> beans = new ArrayList<BeanWrapper>(7);
    protected final Map<BeanWrapper, String> takenNames = new HashMap<BeanWrapper, String>(7);
    protected String nameField;
    protected int listHeight;
    protected int listWidth;
    protected int maxItems;
    protected int minItems;
    protected String defaultName;
    private ListEditorUI listEditorUI;
    protected BeanWrapper lastSelectionBean = null;
    private String templateName;

    public abstract StructuredViewer getViewer();

    public void setListVisible(boolean isVisible) {
        GridUtils.setVisibleAndLayout(this.getViewer().getControl(), isVisible);
    }

    public ListEditor(Composite parent, int style, String listenerName) {
        super(parent, style, listenerName);
    }

    protected void updateEditingUIVisibility() {
        if (this.editorUI instanceof Control) {
            ((Control)this.editorUI).setVisible(!this.beans.isEmpty());
        }
    }

    @Override
    public Object getValue() {
        ArrayList<Object> valueList = new ArrayList<Object>(7);
        for (BeanWrapper wrap : this.beans) {
            valueList.add(wrap.getBean());
        }
        return valueList;
    }

    @Override
    public void addValueListener(ValueListener listener) {
        this.eventDelegate.addValueListener(listener);
        super.addValueListener(listener);
    }

    @Override
    public void removeValueListener(ValueListener l) {
        this.eventDelegate.removeValueListener(l);
        super.removeValueListener(l);
    }

    @Override
    public void setEditorUI(Object ui) {
        if (ui instanceof Control) {
            Control control = (Control)ui;
            if (control.getLayoutData() == null) {
                control.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            }
            control.setVisible(false);
        }
        super.setEditorUI(ui);
    }

    public void setValue(int index, String fieldName, Object value) throws Exception {
        BeanWrapper wrapper = this.beans.get(index);
        BeansFactory.setBeanValue((Object)wrapper.getBean(), (String)fieldName, (Object)value);
        if (index == this.getSelectedIndex()) {
            BeanUI.beanToUI(wrapper.getBean(), this.editorUI);
        }
    }

    public abstract int getSelectedIndex();

    protected abstract void updateButtons();

    public void setSelectedIndex(int index) {
        this.setSelectedBean(this.beans.get(index), true);
    }

    public void setField(String fieldName, Object value) throws Exception {
        IFieldWidget box = BeanUI.getFieldWiget(fieldName, this.editorUI);
        box.setValue(value);
        box.fireValueListeners();
    }

    @Override
    public Object getBean() {
        return this.beans.get(this.getSelectedIndex()).getBean();
    }

    public int getListSize() {
        return this.beans.size();
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameMethod) {
        this.nameField = nameMethod;
    }

    public int getListHeight() {
        return this.listHeight;
    }

    public void setListHeight(int listHeight) {
        this.listHeight = listHeight;
        GridData data = (GridData)this.getViewer().getControl().getLayoutData();
        data.heightHint = listHeight;
    }

    public int getListWidth() {
        return this.listWidth;
    }

    public void setListWidth(int listWidth) {
        this.listWidth = listWidth;
        GridData data = (GridData)this.getViewer().getControl().getLayoutData();
        data.widthHint = listWidth;
    }

    protected void notifyValueListeners() {
        ValueEvent evt = new ValueEvent(this, this.getFieldName());
        evt.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(evt);
    }

    protected void setSelectedBean(BeanWrapper wrapper, boolean fireListeners) {
        if (wrapper == null) {
            this.lastSelectionBean = null;
            return;
        }
        boolean wasOn = this.isOn();
        try {
            try {
                if (wasOn) {
                    this.off();
                }
                BeanUI.beanToUI(wrapper.getBean(), this.editorUI);
                this.lastSelectionBean = wrapper;
                this.getListEditorUI().notifySelected(this);
                this.updateButtons();
                if (fireListeners && this.listeners != null) {
                    BeanSelectionEvent evt = new BeanSelectionEvent(this, this.getSelectedIndex(), this.lastSelectionBean.getBean());
                    for (BeanSelectionListener l : this.listeners) {
                        l.selectionChanged(evt);
                    }
                }
                if (this.getNameField() != null) {
                    this.updateName(this.lastSelectionBean);
                }
                if (this.lastSelectionBean != null && this.getViewer() != null) {
                    this.getViewer().refresh((Object)this.lastSelectionBean);
                }
            }
            catch (Throwable e) {
                logger.error("Cannot select value", e);
                if (wasOn) {
                    this.on();
                }
                try {
                    BeanUI.fireBoundsUpdaters(wrapper.getBean(), this.editorUI);
                }
                catch (Exception e2) {
                    logger.error("Cannot notify value listeners", (Throwable)e2);
                }
            }
        }
        finally {
            if (wasOn) {
                this.on();
            }
            try {
                BeanUI.fireBoundsUpdaters(wrapper.getBean(), this.editorUI);
            }
            catch (Exception e) {
                logger.error("Cannot notify value listeners", (Throwable)e);
            }
        }
    }

    @Override
    protected void valueChanged(ValueEvent e) throws Exception {
        try {
            if (this.lastSelectionBean != null && e.getFieldName() != null) {
                BeanUI.uiToBean(this.editorUI, this.lastSelectionBean.getBean(), e.getFieldName());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    protected BeanWrapper getSelectedBeanWrapper() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        return (BeanWrapper)selection.getFirstElement();
    }

    public String getSelectedBeanName() {
        BeanWrapper selectedBean = this.getSelectedBeanWrapper();
        if (selectedBean != null) {
            return selectedBean.getName();
        }
        return null;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public void setMinItems(int minItems) {
        this.minItems = minItems;
    }

    protected void clear() {
        this.beans.clear();
        this.takenNames.clear();
    }

    @Override
    public void setValue(Object value) {
        List obs = (List)value;
        this.clear();
        int i = 0;
        while (i < obs.size()) {
            Object bean = obs.get(i);
            BeanWrapper wrapper = new BeanWrapper(bean);
            wrapper.setName(this.getFreeName(wrapper, this.getTemplateName(), i));
            this.beans.add(wrapper);
            ++i;
        }
    }

    protected String getFreeName(BeanWrapper wrapper, String templateName, int index) {
        if (this.getNameField() != null) {
            this.updateName(wrapper);
            if (wrapper.isValidName()) {
                this.takenNames.put(wrapper, wrapper.getName());
                return wrapper.getName();
            }
        }
        if (this.takenNames.containsKey(wrapper)) {
            return this.takenNames.get(wrapper);
        }
        if (index < 1) {
            index = 1;
        }
        String suggestedName = String.valueOf(templateName) + " " + index;
        if (!this.takenNames.values().contains(suggestedName)) {
            this.takenNames.put(wrapper, suggestedName);
            return suggestedName;
        }
        String name = this.getFreeName(wrapper, templateName, index + 1);
        this.takenNames.put(wrapper, name);
        return name;
    }

    protected void updateName(BeanWrapper wrapper) {
        String methodName = BeansFactory.getGetterName((String)this.getNameField());
        try {
            String name;
            if (wrapper == null) {
                return;
            }
            Method method = wrapper.getBean().getClass().getMethod(methodName, new Class[0]);
            Object ob = method.invoke(wrapper.getBean(), new Object[0]);
            String string = name = ob != null ? ob.toString() : this.getDefaultName();
            if (name != null) {
                wrapper.setName(name);
            }
        }
        catch (Exception e) {
            logger.error("Cannot set the name field", (Throwable)e);
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    public ListEditorUI getListEditorUI() {
        if (this.listEditorUI == null) {
            this.listEditorUI = ListEditorUIAdapter.getDefault();
        }
        return this.listEditorUI;
    }

    public void setListEditorUI(ListEditorUI listEditorUI) {
        this.listEditorUI = listEditorUI;
    }
}

