/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import com.swtdesigner.ResourceManager;
import com.swtdesigner.SWTResourceManager;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditor;
import uk.ac.gda.richbeans.components.selector.ListEditorUI;
import uk.ac.gda.richbeans.event.ValueEvent;

public final class HorizontalListEditor
extends ListEditor {
    private final TableViewer regionViewer;
    private final ISelectionChangedListener selectionChangedListener;
    private final Button add;
    private final Button delete;
    private final Button left;
    private final Button right;
    private SelectionAdapter addListener;
    private SelectionAdapter deleteListener;
    private SelectionAdapter leftListener;
    private SelectionAdapter rightListener;
    private int selectedIndex = 0;

    public HorizontalListEditor(Composite parent, int style) {
        super(parent, style, HorizontalListEditor.class.getName());
        this.eventDelegate = new EventManagerDelegate(this);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, false));
        this.regionViewer = new TableViewer((Composite)this, 2818);
        this.regionViewer.getTable().setHeaderVisible(false);
        this.regionViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{new Object()};
            }
        });
        this.regionViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (!HorizontalListEditor.this.isOn()) {
                    return false;
                }
                if ("Spacer".equals(property)) {
                    return false;
                }
                HorizontalListEditor.this.selectedIndex = Integer.parseInt(property);
                BeanWrapper bean = (BeanWrapper)HorizontalListEditor.this.beans.get(HorizontalListEditor.this.selectedIndex);
                HorizontalListEditor.this.setSelectedBean(bean, false);
                HorizontalListEditor.this.regionViewer.refresh();
                if (HorizontalListEditor.this.listeners != null) {
                    BeanSelectionEvent evt = new BeanSelectionEvent(this, HorizontalListEditor.this.selectedIndex, bean.getBean());
                    for (BeanSelectionListener l : HorizontalListEditor.this.listeners) {
                        l.selectionChanged(evt);
                    }
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                return null;
            }

            public void modify(Object item, String property, Object value) {
            }
        });
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!HorizontalListEditor.this.isOn()) {
                    return;
                }
                BeanWrapper bean = HorizontalListEditor.this.getSelectedBeanWrapper();
                HorizontalListEditor.this.setSelectedBean(bean, true);
            }
        };
        this.regionViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.regionViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        Composite buttonsPanel = new Composite((Composite)this, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        buttonsPanel.setLayout((Layout)gridLayout_1);
        buttonsPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.add = new Button(buttonsPanel, 0);
        this.add.setImage(SWTResourceManager.getImage(HorizontalListEditor.class, "add.png"));
        GridData addGD = new GridData(4, 0x1000000, false, false);
        addGD.horizontalSpan = 2;
        this.add.setLayoutData((Object)addGD);
        this.add.setText("Add");
        this.addListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HorizontalListEditor.this.addBean();
            }
        };
        this.add.addSelectionListener((SelectionListener)this.addListener);
        this.delete = new Button(buttonsPanel, 0);
        this.delete.setImage(SWTResourceManager.getImage(HorizontalListEditor.class, "delete.png"));
        GridData deleteGD = new GridData(4, 0x1000000, false, false);
        deleteGD.horizontalSpan = 2;
        this.delete.setLayoutData((Object)deleteGD);
        this.delete.setText("Delete");
        this.deleteListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HorizontalListEditor.this.deleteBean();
            }
        };
        this.delete.addSelectionListener((SelectionListener)this.deleteListener);
        this.left = new Button(buttonsPanel, 16388);
        this.left.setText("button");
        this.leftListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HorizontalListEditor.this.getListEditorUI().isReorderAllowed(HorizontalListEditor.this)) {
                    return;
                }
                HorizontalListEditor.this.moveBean(-1);
            }
        };
        this.left.addSelectionListener((SelectionListener)this.leftListener);
        this.right = new Button(buttonsPanel, 131076);
        this.right.setText("button");
        this.rightListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HorizontalListEditor.this.editorUI instanceof ListEditorUI && !((ListEditorUI)HorizontalListEditor.this.editorUI).isReorderAllowed(HorizontalListEditor.this)) {
                    return;
                }
                HorizontalListEditor.this.moveBean(1);
            }
        };
        this.right.addSelectionListener((SelectionListener)this.rightListener);
        MenuManager man = new MenuManager();
        man.add((IAction)new Action("Add", ResourceManager.getImageDescriptor(HorizontalListEditor.class, "add.png")){

            public void run() {
                HorizontalListEditor.this.addBean();
            }
        });
        man.add((IAction)new Action("Delete", ResourceManager.getImageDescriptor(HorizontalListEditor.class, "delete.png")){

            public void run() {
                HorizontalListEditor.this.deleteBean();
            }
        });
        Menu menu = man.createContextMenu(this.regionViewer.getControl());
        this.regionViewer.getControl().setMenu(menu);
        this.editorUI = null;
    }

    public void moveBean(int moveAmount) {
        BeanWrapper bean = this.getSelectedBeanWrapper();
        int index = this.beans.indexOf(bean);
        bean = (BeanWrapper)this.beans.remove(index);
        int newIndex = index + moveAmount;
        this.beans.add(newIndex, bean);
        this.lastSelectionBean = null;
        if (!this.beans.isEmpty()) {
            this.setSelectedBean((BeanWrapper)this.beans.get(newIndex), true);
            this.regionViewer.getControl().setFocus();
        }
        this.notifyValueListeners();
        this.createColumns();
        this.regionViewer.refresh();
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    protected BeanWrapper getSelectedBeanWrapper() {
        return (BeanWrapper)this.beans.get(this.selectedIndex);
    }

    public void addBean() {
        try {
            this.addBean(this.beanTemplate.getClass().newInstance());
        }
        catch (Exception ne) {
            ne.printStackTrace();
        }
    }

    public void addBean(Object bean) throws ClassCastException {
        this.addBean(bean, this.getSelectedIndex() + 1);
    }

    public void addBean(Object bean, int index) throws ClassCastException {
        if (!this.beanTemplate.getClass().isInstance(bean)) {
            throw new ClassCastException("Bean passed to addBean is not an instance of beanTemplate.getClass()");
        }
        if (!this.getListEditorUI().isAddAllowed(this)) {
            return;
        }
        try {
            BeanWrapper wrapper = new BeanWrapper(bean);
            wrapper.setName(this.getFreeName(wrapper, this.getTemplateName(), index));
            if (index < 0) {
                this.beans.add(wrapper);
            } else {
                this.beans.add(index, wrapper);
            }
            this.createColumns();
            this.setSelectedBean(wrapper, true);
            this.regionViewer.getControl().setFocus();
            this.updateEditingUIVisibility();
            this.notifyValueListeners();
        }
        catch (Exception ne) {
            ne.printStackTrace();
        }
    }

    public void deleteBean() {
        if (!this.getListEditorUI().isDeleteAllowed(this)) {
            return;
        }
        BeanWrapper bean = this.getSelectedBeanWrapper();
        int index = this.beans.indexOf(bean);
        this.beans.remove(bean);
        this.createColumns();
        this.lastSelectionBean = null;
        if (!this.beans.isEmpty()) {
            if (index > this.beans.size() - 1) {
                --index;
            }
            if (index < 0) {
                index = 0;
            }
            this.setSelectedBean((BeanWrapper)this.beans.get(index), true);
            this.regionViewer.getControl().setFocus();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    @Override
    public StructuredViewer getViewer() {
        return this.regionViewer;
    }

    @Override
    public void dispose() {
        if (this.regionViewer != null && !this.regionViewer.getControl().isDisposed()) {
            this.regionViewer.removeSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.regionViewer != null && !this.add.isDisposed()) {
            this.add.removeSelectionListener((SelectionListener)this.addListener);
        }
        if (this.delete != null && !this.delete.isDisposed()) {
            this.delete.removeSelectionListener((SelectionListener)this.deleteListener);
        }
        if (this.right != null && !this.right.isDisposed()) {
            this.right.removeSelectionListener((SelectionListener)this.rightListener);
        }
        if (this.left != null && !this.left.isDisposed()) {
            this.left.removeSelectionListener((SelectionListener)this.leftListener);
        }
        super.dispose();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.regionViewer.getTable().setEnabled(isEnabled);
        this.add.setEnabled(isEnabled);
        this.delete.setEnabled(isEnabled);
        this.right.setEnabled(isEnabled);
        this.left.setEnabled(isEnabled);
        if (isEnabled) {
            this.updateButtons();
        }
    }

    @Override
    protected void setSelectedBean(BeanWrapper wrapper, boolean fireListeners) {
        super.setSelectedBean(wrapper, fireListeners);
        this.selectedIndex = this.beans.indexOf(wrapper);
        this.regionViewer.refresh();
    }

    @Override
    protected void valueChanged(ValueEvent e) throws Exception {
        super.valueChanged(e);
        if (this.getNameField() != null && this.getNameField().equalsIgnoreCase(e.getFieldName())) {
            this.updateName(this.lastSelectionBean);
            this.regionViewer.refresh();
        }
    }

    @Override
    protected void updateButtons() {
        int selected = this.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        boolean addAllowed = this.getListEditorUI().isAddAllowed(this);
        boolean deleteAllowed = this.getListEditorUI().isDeleteAllowed(this);
        if (this.maxItems > 0) {
            this.add.setEnabled(addAllowed && this.beans.size() < this.maxItems && this.isEnabled());
        } else {
            this.add.setEnabled(addAllowed && this.isEnabled());
        }
        if (this.beans.size() > 1 && this.isEnabled()) {
            this.right.setEnabled(true);
            this.left.setEnabled(true);
        } else {
            this.right.setEnabled(false);
            this.left.setEnabled(false);
        }
        if (this.minItems > 0) {
            this.delete.setEnabled(deleteAllowed && this.beans.size() > this.minItems && this.isEnabled());
        } else if (this.beans.isEmpty()) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(deleteAllowed && this.isEnabled());
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.createColumns();
        if (!this.beans.isEmpty()) {
            this.selectedIndex = 0;
            this.setSelectedBean((BeanWrapper)this.beans.get(0), true);
        } else if (this.listeners != null) {
            BeanSelectionEvent evt = new BeanSelectionEvent(this, -1, null);
            for (BeanSelectionListener l : this.listeners) {
                l.selectionChanged(evt);
            }
        }
        if (!this.regionViewer.getControl().isDisposed()) {
            this.regionViewer.refresh();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    private void createColumns() {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.regionViewer, (int)2);
        while (this.regionViewer.getTable().getColumns().length > 0) {
            this.regionViewer.getTable().getColumns()[0].dispose();
        }
        ArrayList<String> props = new ArrayList<String>(this.beans.size());
        int i = 0;
        while (i < this.beans.size()) {
            BeanWrapper wrap = (BeanWrapper)this.beans.get(i);
            TableViewerColumn col = new TableViewerColumn(this.regionViewer, 0, i);
            col.getColumn().setText(" ");
            col.setLabelProvider((CellLabelProvider)new BeanColumnProvider(wrap));
            col.getColumn().pack();
            col.getColumn().setWidth(150);
            props.add(String.valueOf(i));
            ++i;
        }
        TableViewerColumn col = new TableViewerColumn(this.regionViewer, 0, this.beans.size());
        col.getColumn().setText(" ");
        col.getColumn().setWidth(10);
        col.setLabelProvider((CellLabelProvider)new BeanColumnProvider());
        props.add("Spacer");
        this.regionViewer.setColumnProperties(props.toArray(new String[props.size()]));
        this.regionViewer.setInput(new Object());
    }

    public class BeanColumnProvider
    extends ColumnLabelProvider {
        private final BeanWrapper wrapper;
        private final Color blue = SWTResourceManager.getColor(10);
        private final Color white = SWTResourceManager.getColor(1);

        public BeanColumnProvider(BeanWrapper wrap) {
            this.wrapper = wrap;
        }

        public BeanColumnProvider() {
            this(null);
        }

        public String getText(Object element) {
            if (this.wrapper == null) {
                return "";
            }
            return this.wrapper.getName();
        }

        public Color getBackground(Object element) {
            if (this.wrapper == null) {
                return null;
            }
            if (HorizontalListEditor.this.beans.indexOf(this.wrapper) == HorizontalListEditor.this.selectedIndex) {
                return this.blue;
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (this.wrapper == null) {
                return null;
            }
            if (HorizontalListEditor.this.beans.indexOf(this.wrapper) == HorizontalListEditor.this.selectedIndex) {
                return this.white;
            }
            return null;
        }
    }
}

