/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.selector;

import com.swtdesigner.SWTResourceManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.BeanWrapper;
import uk.ac.gda.richbeans.components.selector.ListEditor;

public final class GridListEditor
extends ListEditor {
    protected TableViewer gridTable;
    protected int selectedIndex;
    protected final int columns;
    protected final int rows;
    private Listener tableListener;
    private Map<Integer, Integer> gridMap;
    protected ColumnLabelProvider columnLabelProviderDelegate;
    private Collection<TableViewerColumn> tableColumns;
    private GRID_ORDER gridOrder;
    private int gridHeight;
    private int gridWidth;

    public GridListEditor(Composite par, int switches) {
        this(par, switches, 5, 5);
        this.setGridHeight(126);
        this.setGridWidth(130);
    }

    public GridListEditor(Composite par, int switches, int squareTotal) {
        this(par, switches, GridListEditor.getSide(squareTotal, squareTotal), GridListEditor.getSide(squareTotal, 1));
    }

    private static int getSide(int squareTotal, int alternative) {
        if (squareTotal > 3) {
            return (int)Math.pow(squareTotal, 0.5);
        }
        return alternative;
    }

    public GridListEditor(Composite par, int switches, int columns, int rows) {
        super(par, switches, GridListEditor.class.getName());
        this.eventDelegate = new EventManagerDelegate(this);
        this.columns = columns;
        this.rows = rows;
        this.setLayout((Layout)new GridLayout(1, false));
        if (rows * columns > 1) {
            this.gridTable = new TableViewer((Composite)this, 67602);
            this.gridTable.getTable().setLinesVisible(true);
            this.createContentProvider();
            this.createLabelProvider();
            this.createEditor();
            this.tableListener = new Listener(){

                public void handleEvent(Event event) {
                    GridListEditor.this.gridTable.setSelection(null);
                }
            };
            this.gridTable.getTable().addListener(13, this.tableListener);
            this.gridTable.getControl().setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.setGridHeight(100);
            this.gridTable.setInput(new Object());
        } else {
            this.selectedIndex = 0;
        }
        this.editorUI = null;
    }

    @Override
    public StructuredViewer getViewer() {
        return this.gridTable;
    }

    @Override
    public void dispose() {
        if (this.gridTable != null && this.gridTable.getTable() != null && !this.gridTable.getTable().isDisposed()) {
            this.gridTable.getTable().removeListener(13, this.tableListener);
        }
        super.dispose();
    }

    @Override
    protected BeanWrapper getSelectedBeanWrapper() {
        return (BeanWrapper)this.beans.get(this.selectedIndex);
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    protected void setSelectedBean(BeanWrapper wrapper, boolean fireListeners) {
        super.setSelectedBean(wrapper, fireListeners);
        this.selectedIndex = this.beans.indexOf(wrapper);
        if (this.gridTable != null) {
            this.gridTable.refresh();
        }
    }

    @Override
    public void setValue(Object value) {
        List obs = (List)value;
        this.clear();
        int i = 0;
        while (i < obs.size()) {
            Object bean = obs.get(i);
            BeanWrapper wrapper = new BeanWrapper(bean);
            wrapper.setName(String.valueOf(i));
            this.beans.add(wrapper);
            ++i;
        }
        if (!this.beans.isEmpty()) {
            this.selectedIndex = 0;
            this.setSelectedBean((BeanWrapper)this.beans.get(0), false);
        }
        if (this.gridTable != null) {
            this.gridTable.refresh();
        }
        this.updateEditingUIVisibility();
        this.notifyValueListeners();
    }

    private void createEditor() {
        if (this.gridTable == null) {
            return;
        }
        String[] cols = new String[this.columns];
        int i = 0;
        while (i < cols.length) {
            cols[i] = String.valueOf(i);
            ++i;
        }
        this.gridTable.setColumnProperties(cols);
        this.gridTable.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (!GridListEditor.this.isOn()) {
                    return false;
                }
                Integer row = (Integer)element;
                int col = Integer.parseInt(property);
                GridListEditor.this.selectedIndex = GridListEditor.this.getElementIndex(row, col);
                BeanWrapper bean = (BeanWrapper)GridListEditor.this.beans.get(GridListEditor.this.selectedIndex);
                GridListEditor.this.setSelectedBean(bean, false);
                GridListEditor.this.gridTable.refresh();
                if (GridListEditor.this.listeners != null) {
                    BeanSelectionEvent evt = new BeanSelectionEvent(this, GridListEditor.this.selectedIndex, bean.getBean());
                    for (BeanSelectionListener l : GridListEditor.this.listeners) {
                        l.selectionChanged(evt);
                    }
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                return null;
            }

            public void modify(Object item, String property, Object value) {
            }
        });
    }

    private void createContentProvider() {
        if (this.gridTable == null) {
            return;
        }
        final Integer[] vals = new Integer[this.rows];
        int i = 0;
        while (i < vals.length) {
            vals[i] = i;
            ++i;
        }
        this.gridTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return vals;
            }
        });
    }

    public void setAdditionalLabelProvider(ColumnLabelProvider prov) {
        this.columnLabelProviderDelegate = prov;
    }

    public void setColumnWidth(int width) {
        if (this.gridTable == null) {
            return;
        }
        for (TableViewerColumn col : this.tableColumns) {
            col.getColumn().setWidth(width);
        }
    }

    private void createLabelProvider() {
        if (this.gridTable == null) {
            return;
        }
        this.tableColumns = new HashSet<TableViewerColumn>(7);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.gridTable, (int)2);
        int width = Math.round((float)this.gridWidth / (float)this.columns);
        if (width < 1) {
            width = 25;
        }
        int i = 0;
        while (i < this.columns) {
            final int column = i++;
            TableViewerColumn col = new TableViewerColumn(this.gridTable, 0);
            col.getColumn().setWidth(width);
            this.tableColumns.add(col);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
                private final Color blue = SWTResourceManager.getColor(10);
                private final Color white = SWTResourceManager.getColor(1);

                public String getText(Object element) {
                    int elementIndex;
                    String text;
                    if (GridListEditor.this.columnLabelProviderDelegate != null && (text = GridListEditor.this.columnLabelProviderDelegate.getText(((BeanWrapper)GridListEditor.this.beans.get(elementIndex = GridListEditor.this.getElementIndex(element, column))).getBean())) != null) {
                        return text;
                    }
                    if (!(element instanceof Integer)) {
                        return null;
                    }
                    int index = GridListEditor.this.getElementIndex(element, column);
                    return String.valueOf(index);
                }

                public Color getBackground(Object element) {
                    Color color;
                    if (GridListEditor.this.columnLabelProviderDelegate != null && (color = GridListEditor.this.columnLabelProviderDelegate.getBackground(((BeanWrapper)GridListEditor.this.beans.get(GridListEditor.this.getElementIndex(element, column))).getBean())) != null) {
                        return color;
                    }
                    if (GridListEditor.this.getElementIndex(element, column) == GridListEditor.this.selectedIndex) {
                        return this.blue;
                    }
                    return null;
                }

                public Color getForeground(Object element) {
                    Color color;
                    if (GridListEditor.this.columnLabelProviderDelegate != null && (color = GridListEditor.this.columnLabelProviderDelegate.getForeground(((BeanWrapper)GridListEditor.this.beans.get(GridListEditor.this.getElementIndex(element, column))).getBean())) != null) {
                        return color;
                    }
                    if (GridListEditor.this.getElementIndex(element, column) == GridListEditor.this.selectedIndex) {
                        return this.white;
                    }
                    return null;
                }

                public String getToolTipText(Object element) {
                    return "Click to select element.";
                }

                public Point getToolTipShift(Object object) {
                    return new Point(5, 5);
                }

                public int getToolTipDisplayDelayTime(Object object) {
                    return 50;
                }

                public int getToolTipTimeDisplayed(Object object) {
                    return 10000;
                }
            });
        }
    }

    public void setGridOrder(GRID_ORDER order) {
        this.gridOrder = order;
    }

    private int getElementIndex(Object element, int col) {
        int row = (Integer)element;
        if (this.gridOrder == GRID_ORDER.CUSTOM_MAP) {
            int index = col + row * this.columns;
            return this.gridMap.get(index);
        }
        if (this.columns == this.rows) {
            if (this.gridOrder == null || this.gridOrder == GRID_ORDER.LEFT_TO_RIGHT_TOP_TO_BOTTOM) {
                return col + row * this.columns;
            }
            int ref = this.rows * this.columns - this.columns;
            return ref + row - col * this.columns;
        }
        return row * this.columns + col;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int listHeight) {
        if (this.gridTable == null) {
            return;
        }
        this.gridHeight = listHeight;
        GridData data = (GridData)this.gridTable.getControl().getLayoutData();
        data.heightHint = listHeight;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        if (this.gridTable == null) {
            return;
        }
        this.gridWidth = gridWidth;
        GridData data = (GridData)this.gridTable.getControl().getLayoutData();
        data.widthHint = gridWidth;
        int width = Math.round((float)this.gridWidth / (float)this.columns);
        if (width < 1) {
            width = 25;
        }
        this.setColumnWidth(width);
        this.gridHeight = this.rows * 25;
        data = (GridData)this.gridTable.getControl().getLayoutData();
        data.heightHint = this.gridHeight;
    }

    @Override
    protected void updateButtons() {
    }

    public Map<Integer, Integer> getGridMap() {
        return this.gridMap;
    }

    public void setGridMap(Map<Integer, Integer> gridMap) {
        this.gridMap = gridMap;
    }

    public static enum GRID_ORDER {
        LEFT_TO_RIGHT_TOP_TO_BOTTOM,
        TOP_TO_BOTTOM_RIGHT_TO_LEFT,
        CUSTOM_MAP;

    }
}

