/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import uk.ac.gda.common.rcp.util.DialogUtils;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.doe.DOEFieldType;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.components.scalebox.internal.DoubleValueBean;
import uk.ac.gda.richbeans.components.scalebox.internal.IntegerValueBean;
import uk.ac.gda.richbeans.components.scalebox.internal.ListValueComposite;
import uk.ac.gda.richbeans.components.scalebox.internal.NumberValueBean;
import uk.ac.gda.richbeans.components.scalebox.internal.RangeComposite;
import uk.ac.gda.richbeans.components.selector.VerticalListEditor;
import uk.ac.gda.richbeans.components.wrappers.LabelWrapper;

public final class RangeDialog
extends Dialog {
    protected RangeComposite rangeComposite;
    protected VerticalListEditor listEditor;
    protected DOEFieldType currentRange;
    protected String currentValue;
    protected Combo rangeChoice;
    protected LabelWrapper singleValueLabel;
    protected boolean isInteger;
    private boolean rangeOnly = false;

    public RangeDialog(Shell parentShell, boolean isInteger) {
        super(parentShell);
        this.setShellStyle(48);
        this.setBlockOnOpen(true);
        this.isInteger = isInteger;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.pack();
        newShell.setText("Range");
        newShell.setSize(500, 380);
        DialogUtils.centerDialog(this.getParentShell(), newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        Link lblRange = new Link(comp, 0);
        GridData gd_lblRange = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblRange.widthHint = 60;
        lblRange.setLayoutData((Object)gd_lblRange);
        lblRange.setText("Range");
        this.rangeChoice = new Combo(comp, 8);
        this.rangeChoice.setItems(new String[]{"Single Value", "List", "Range"});
        this.rangeChoice.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.rangeChoice.select(this.rangeOnly ? 2 : 0);
        this.rangeChoice.setEnabled(!this.rangeOnly);
        new Label(comp, 0);
        Composite content = new Composite(comp, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        content.setLayout((Layout)new GridLayout(1, false));
        this.singleValueLabel = new LabelWrapper(content, 0);
        this.singleValueLabel.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.singleValueLabel.setTextType(LabelWrapper.TEXT_TYPE.NUMBER_WITH_UNIT);
        this.singleValueLabel.setValue(0.0);
        GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, false);
        this.rangeComposite = new RangeComposite(content, 0);
        this.rangeComposite.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        GridUtils.setVisibleAndLayout((Control)this.rangeComposite, false);
        this.listEditor = new VerticalListEditor(content, 0);
        this.listEditor.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.listEditor.setMinItems(1);
        this.listEditor.setMaxItems(100);
        this.listEditor.setDefaultName("0.0");
        if (this.isInteger) {
            this.listEditor.setEditorClass(IntegerValueBean.class);
        } else {
            this.listEditor.setEditorClass(DoubleValueBean.class);
        }
        ListValueComposite listValComp = new ListValueComposite(this.listEditor, 0);
        this.listEditor.setEditorUI((Object)listValComp);
        this.listEditor.setNameField("value");
        GridUtils.setVisibleAndLayout((Control)this.listEditor, false);
        this.listEditor.on();
        this.rangeChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RangeDialog.this.updateRangeType(RangeDialog.this.getRangeType(RangeDialog.this.rangeChoice.getSelectionIndex()), false);
            }
        });
        this.updateRangeType(this.currentRange, true);
        return comp;
    }

    private DOEFieldType getRangeType(int selectionIndex) {
        if (selectionIndex == 0) {
            return DOEFieldType.SINGLE_VALUE;
        }
        if (selectionIndex == 1) {
            return DOEFieldType.LIST;
        }
        if (selectionIndex == 2) {
            return DOEFieldType.RANGE;
        }
        return DOEFieldType.SINGLE_VALUE;
    }

    protected void updateRangeType(DOEFieldType range, boolean setChoice) {
        List vals = null;
        if (this.currentRange != null) {
            vals = DOEUtils.expand((String)this.getValueInternal());
        }
        this.currentRange = range;
        if (range == DOEFieldType.SINGLE_VALUE) {
            if (vals != null) {
                this.singleValueLabel.setValue(vals.get(0));
            }
            GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, true);
            GridUtils.setVisibleAndLayout((Control)this.rangeComposite, false);
            GridUtils.setVisibleAndLayout((Control)this.listEditor, false);
            if (setChoice) {
                this.rangeChoice.select(0);
            }
        } else if (range == DOEFieldType.LIST) {
            if (vals != null) {
                List<NumberValueBean> beans = this.isInteger ? IntegerValueBean.getBeanList(vals) : DoubleValueBean.getBeanList(vals);
                this.listEditor.setValue(beans);
            }
            GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, false);
            GridUtils.setVisibleAndLayout((Control)this.rangeComposite, false);
            GridUtils.setVisibleAndLayout((Control)this.listEditor, true);
            if (setChoice) {
                this.rangeChoice.select(1);
            }
        } else if (range == DOEFieldType.RANGE) {
            GridUtils.setVisibleAndLayout((Control)this.singleValueLabel, false);
            GridUtils.setVisibleAndLayout((Control)this.rangeComposite, true);
            GridUtils.setVisibleAndLayout((Control)this.listEditor, false);
            if (setChoice) {
                this.rangeChoice.select(2);
            }
            if (vals != null) {
                Collections.sort(vals, new Comparator<Number>(){

                    @Override
                    public int compare(Number n1, Number n2) {
                        return new Double(n1.doubleValue()).compareTo(new Double(n2.doubleValue()));
                    }
                });
                if (vals.size() > 1) {
                    if (this.rangeComposite.isForwards()) {
                        this.rangeComposite.setValue((Number)vals.get(0), (Number)vals.get(vals.size() - 1), 1.0);
                    } else {
                        this.rangeComposite.setValue((Number)vals.get(vals.size() - 1), (Number)vals.get(0), 1.0);
                    }
                }
            }
        }
        this.listEditor.getParent().layout();
    }

    public DOEFieldType getRangeType() {
        return DOEFieldType.SINGLE_VALUE;
    }

    public void setValue(String currentValue) {
        DOEFieldType range = DOEFieldType.getRangeType((String)currentValue);
        if (this.rangeOnly) {
            range = DOEFieldType.RANGE;
        }
        if (range == DOEFieldType.SINGLE_VALUE) {
            Double ov = Double.parseDouble(currentValue);
            this.singleValueLabel.setValue(ov);
        } else if (range == DOEFieldType.LIST) {
            List<NumberValueBean> beans = this.isInteger ? IntegerValueBean.getBeanList(currentValue) : DoubleValueBean.getBeanList(currentValue);
            this.listEditor.setValue(beans);
        } else if (range == DOEFieldType.RANGE) {
            this.rangeComposite.setValue(currentValue);
        }
        this.updateRangeType(range, true);
    }

    public void setUnit(String unit) {
        ((ListValueComposite)((Object)this.listEditor.getEditorUI())).getValue().setUnit(unit);
        this.rangeComposite.setUnit(unit);
        this.singleValueLabel.setUnit(unit);
    }

    public String getValue() {
        return this.currentValue;
    }

    protected void cancelPressed() {
        this.currentRange = null;
        this.currentValue = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        this.currentValue = this.getValueInternal();
        super.okPressed();
    }

    private String getValueInternal() {
        if (this.currentRange == null) {
            return null;
        }
        if (this.currentRange == DOEFieldType.SINGLE_VALUE) {
            if (this.singleValueLabel == null) {
                return null;
            }
            return this.singleValueLabel.getValue().toString();
        }
        if (this.currentRange == DOEFieldType.LIST) {
            if (this.listEditor == null) {
                return null;
            }
            List vals = (List)this.listEditor.getValue();
            return NumberValueBean.getString(vals);
        }
        if (this.currentRange == DOEFieldType.RANGE) {
            if (this.rangeComposite == null) {
                return null;
            }
            return this.rangeComposite.getValue();
        }
        return null;
    }

    public void setBounds(NumberBox numBox) {
        ScaleBox list = ((ListValueComposite)((Object)this.listEditor.getEditorUI())).getValue();
        list.copySettings(numBox);
        this.rangeComposite.setBounds(numBox);
    }

    public void setRangeOnly(boolean rangeOnly) {
        this.rangeOnly = rangeOnly;
    }
}

