/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox.internal;

import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.components.wrappers.LabelWrapper;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;

public class RangeComposite
extends Composite {
    private ScaleBox initialValue;
    private ScaleBox finalValue;
    private ScaleBox increment;
    private LabelWrapper size;

    public RangeComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblInitialValue = new Label((Composite)this, 0);
        lblInitialValue.setText("Initial Value");
        this.initialValue = new ScaleBox(this, 0);
        this.initialValue.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.initialValue.setValue(0.0);
        Label lblFinalValue = new Label((Composite)this, 0);
        lblFinalValue.setText("Final Value");
        this.finalValue = new ScaleBox(this, 0);
        this.finalValue.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.finalValue.setValue(10.0);
        Label lblIncrement = new Label((Composite)this, 0);
        lblIncrement.setText("Increment");
        this.increment = new ScaleBox(this, 0);
        this.increment.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.increment.setMinimum(0.0);
        this.increment.setMaximum(1000.0);
        this.increment.setToolTipText("If the initial value is larger than the final value the loop will be constructed using increment to go backwards from the start.");
        this.increment.setValue(1.0);
        Label lblSize = new Label((Composite)this, 0);
        lblSize.setText("Size");
        this.size = new LabelWrapper(this, 0);
        this.size.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        ValueAdapter sizeUpdate = new ValueAdapter(){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                try {
                    List vals = DOEUtils.expand((String)RangeComposite.this.getValue());
                    RangeComposite.this.size.setValue(vals.size());
                }
                catch (Exception exception) {
                    RangeComposite.this.size.setValue(0);
                }
            }
        };
        this.initialValue.addValueListener(sizeUpdate);
        this.finalValue.addValueListener(sizeUpdate);
        this.increment.addValueListener(sizeUpdate);
        try {
            BeanUI.switchState((Object)this, true);
        }
        catch (Exception exception) {}
    }

    public String getValue() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.initialValue.getValue());
        buf.append("; ");
        buf.append(this.finalValue.getValue());
        buf.append("; ");
        buf.append(this.increment.getValue());
        return buf.toString();
    }

    public void setUnit(String unit) {
        this.initialValue.setUnit(unit);
        this.finalValue.setUnit(unit);
        this.increment.setUnit(unit);
    }

    public void setValue(String range) {
        String[] vals = range.split(";");
        Double start = vals != null && vals.length > 0 ? Double.parseDouble(vals[0].trim()) : 0.0;
        Double end = vals != null && vals.length > 1 ? Double.parseDouble(vals[1].trim()) : start + 1.0;
        Double inc = vals != null && vals.length > 2 ? Double.parseDouble(vals[2].trim()) : 1.0;
        this.setValue(start, end, inc);
    }

    public void setValue(Number initialV, Number finalV, Number inc) {
        this.initialValue.setValue(initialV);
        this.finalValue.setValue(finalV);
        this.increment.setValue(inc);
    }

    public void setBounds(NumberBox numBox) {
        this.initialValue.copySettings(numBox);
        this.finalValue.copySettings(numBox);
        this.increment.setIntegerBox(numBox.isIntegerBox());
        this.increment.setDecimalPlaces(numBox.getDecimalPlaces());
    }

    public ScaleBox getInitialValue() {
        return this.initialValue;
    }

    public ScaleBox getFinalValue() {
        return this.finalValue;
    }

    public ScaleBox getIncrement() {
        return this.increment;
    }

    public boolean isForwards() {
        Double s = (Double)this.getInitialValue().getValue();
        Double f = (Double)this.getFinalValue().getValue();
        return f > s;
    }
}

