/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.ui.utils.SWTUtils;

public class StandardBox
extends NumberBox {
    public StandardBox(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createTextListeners(StyledText text) {
        this.createFocusListener(text);
        this.createModifyListener(text);
        this.createVerifyKeyListener(text);
    }

    @Override
    protected void createVerifyKeyListener(StyledText text) {
        this.verifyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.character == '\r') {
                    StandardBox.this.textUpdateAndFireListeners();
                }
            }
        };
        text.addVerifyKeyListener(this.verifyListener);
    }

    @Override
    protected void createModifyListener(StyledText text) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardBox.this.textUpdate();
            }
        };
        text.addModifyListener(this.modifyListener);
    }

    @Override
    protected void createFocusListener(StyledText text) {
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                StandardBox.this.textUpdateAndFireListeners();
            }
        };
        text.addFocusListener((FocusListener)this.focusListener);
    }

    public static void main(String ... args) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
        Composite comp = new Composite((Composite)shell, 0);
        comp.setLayoutData((Object)"North");
        comp.setLayout((Layout)new GridLayout(1, false));
        final StandardBox x = new StandardBox(comp, 0);
        x.setUnit("micron");
        x.setLabel("x");
        x.setLabelWidth(20);
        x.setValue(1);
        x.setLayoutData(new GridData(4, 0x1000000, true, false));
        final StandardBox y = new StandardBox(comp, 0);
        y.setUnit("micron");
        y.setLabel("y");
        y.setLabelWidth(20);
        y.setLayoutData(new GridData(4, 0x1000000, true, false));
        y.setValue(2);
        final StandardBox z = new StandardBox(comp, 0);
        z.setUnit("micron");
        z.setLabel("x");
        z.setLabelWidth(20);
        z.setLayoutData(new GridData(4, 0x1000000, true, false));
        z.setValue(2);
        final Label value = new Label(comp, 0);
        value.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ValueAdapter l = new ValueAdapter("test"){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                StringBuilder buf = new StringBuilder();
                this.addValue("x", x, buf);
                this.addValue("y", y, buf);
                this.addValue("z", z, buf);
                value.setText(buf.toString());
                shell.layout();
            }

            private void addValue(String label, StandardBox box, StringBuilder buf) {
                buf.append(label);
                buf.append("=");
                buf.append(box.getValue());
                buf.append(" ");
                buf.append(box.getUnit());
                buf.append("    ");
            }
        };
        x.addValueListener(l);
        y.addValueListener(l);
        z.addValueListener(l);
        shell.pack();
        shell.setSize(400, 400);
        x.on();
        y.on();
        z.on();
        SWTUtils.showCenteredShell(shell);
    }
}

