/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import java.text.NumberFormat;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;

public class ScaleBoxAndFixedExpression
extends ScaleBox {
    private static Logger logger = LoggerFactory.getLogger(ScaleBoxAndFixedExpression.class);
    private Label fixedExpressionLabel;
    private JEP jepParser;
    private SymbolTable symbolTable;
    private Object dataProvider;
    private String expression;
    private String thisVariable;
    private String labelUnit;
    private String prefix;
    private ExpressionProvider provider;
    private NumberFormat labelNumberFormat;

    public ScaleBoxAndFixedExpression(Composite parent, int style) {
        super(parent, style);
        this.createFixedExpressionLabel();
    }

    public ScaleBoxAndFixedExpression(Composite parent, int style, ExpressionProvider ep) {
        super(parent, style);
        this.createFixedExpressionLabel();
        this.provider = ep;
        IFieldWidget[] fw = this.provider.getPrecedents();
        if (fw != null) {
            int i = 0;
            while (i < fw.length) {
                fw[i].addValueListener(new ValueAdapter(){

                    @Override
                    public void valueChangePerformed(ValueEvent e) {
                        ScaleBoxAndFixedExpression.this.updateLabel();
                    }
                });
                ++i;
            }
        }
    }

    public ScaleBoxAndFixedExpression(Composite parent, int style, String thisVariable, String expression, Object dataProvider) throws ParseException {
        super(parent, style);
        this.createFixedExpressionLabel();
        this.thisVariable = thisVariable;
        this.expression = expression;
        this.symbolTable = this.getSymbolTable(expression);
        this.dataProvider = dataProvider;
    }

    private void createFixedExpressionLabel() {
        if (!this.label.isVisible()) {
            GridData data = (GridData)this.label.getLayoutData();
            data.exclude = true;
        }
        this.createExpressionLabel(-1);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        if (this.fixedExpressionLabel != null) {
            return;
        }
        this.fixedExpressionLabel = new Label((Composite)this, 131072);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = 80;
        this.fixedExpressionLabel.setLayoutData((Object)gd);
        this.layout();
    }

    public void setFixedExpressionValue(double numericalValue) {
        String labelText = this.getLabel(numericalValue);
        this.fixedExpressionLabel.setText(labelText);
        if (labelText == null || "".equals(labelText.trim()) || "-".equals(labelText.trim())) {
            GridUtils.setVisibleAndLayout((Control)this.fixedExpressionLabel, false);
        } else {
            GridUtils.setVisibleAndLayout((Control)this.fixedExpressionLabel, true);
        }
    }

    public void setExpressionLabelTooltip(String tip) {
        this.fixedExpressionLabel.setToolTipText(tip);
    }

    @Override
    protected void checkValue(String txt) {
        super.checkValue(txt);
        if (txt == null || "".equals(txt.trim()) || "-".equals(txt.trim())) {
            GridUtils.setVisibleAndLayout((Control)this.fixedExpressionLabel, false);
            return;
        }
        double num = this.getNumericValue();
        this.updateLabel(num);
    }

    private void updateLabel() {
        this.updateLabel(this.getNumericValue());
    }

    private void updateLabel(double value) {
        try {
            if (this.provider == null && this.jepParser == null) {
                return;
            }
            double labelVal = Double.NaN;
            if (this.provider != null) {
                labelVal = this.provider.getValue(value);
            } else {
                SymbolTable vars = this.symbolTable;
                Set entries = vars.entrySet();
                for (Map.Entry entry : entries) {
                    if (entry.getValue() != null || entry.getKey().equals(this.thisVariable)) continue;
                    double val = (Double)BeansFactory.getBeanValue((Object)this.dataProvider, (String)entry.getKey().toString());
                    this.jepParser.addVariable(entry.getKey().toString(), val);
                }
                this.jepParser.addVariable(this.thisVariable, value);
                this.jepParser.parseExpression(this.expression);
                labelVal = this.jepParser.getValue();
            }
            this.setFixedExpressionValue(labelVal);
            this.layout();
        }
        catch (Exception ne) {
            logger.error("Cannot compute value " + this.expression, (Throwable)ne);
            this.fixedExpressionLabel.setText("");
        }
    }

    private String getLabel(double labelVal) {
        StringBuilder buf = new StringBuilder();
        if (this.getPrefix() != null) {
            buf.append(this.getPrefix());
            buf.append(" ");
        }
        String text = this.labelNumberFormat != null ? this.labelNumberFormat.format(labelVal) : this.numberFormat.format(labelVal);
        buf.append(text);
        if (this.getLabelUnit() != null) {
            buf.append(" ");
            buf.append(this.getLabelUnit());
        }
        return buf.toString();
    }

    public void setLabelDecimalPlaces(int decimalPlaces) {
        if (this.labelNumberFormat == null) {
            this.labelNumberFormat = NumberFormat.getInstance();
        }
        this.labelNumberFormat.setMaximumFractionDigits(decimalPlaces);
    }

    private SymbolTable getSymbolTable(String expression) throws ParseException {
        this.jepParser = new JEP();
        this.jepParser.addStandardFunctions();
        this.jepParser.addStandardConstants();
        this.jepParser.setAllowUndeclared(true);
        this.jepParser.setImplicitMul(true);
        this.jepParser.parse(expression);
        return this.jepParser.getSymbolTable();
    }

    public Object getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(Object dataProvider) {
        this.dataProvider = dataProvider;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getThisVariable() {
        return this.thisVariable;
    }

    public void setThisVariable(String thisVariable) {
        this.thisVariable = thisVariable;
    }

    public String getLabelUnit() {
        return this.labelUnit;
    }

    public void setLabelUnit(String labelUnit) {
        this.labelUnit = labelUnit;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public static interface ExpressionProvider {
        public double getValue(double var1);

        public IFieldWidget[] getPrecedents();
    }
}

