/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.components.scalebox.DecimalScale;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.event.BoundsEvent;
import uk.ac.gda.richbeans.event.BoundsListener;
import uk.ac.gda.ui.utils.SWTUtils;

public class ScaleBox
extends NumberBox {
    protected Shell scaleShell;
    protected DecimalScale scale;
    protected double increment = 1.0;
    protected double pageIncrement = 100.0;
    protected int scaleDecimalPlaces = 0;
    protected boolean shellCreated = false;
    protected boolean showingScale = false;

    public ScaleBox(Composite parent, int style) {
        super(parent, style);
        this.buttonSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScaleBox.this.scaleShell != null && ScaleBox.this.scaleShell.isVisible()) {
                    return;
                }
                ScaleBox.this.setShowingScale(true);
            }
        };
    }

    @Override
    public void dispose() {
        if (this.scaleShell != null && !this.scaleShell.isDisposed()) {
            this.scaleShell.dispose();
        }
        super.dispose();
    }

    protected void createScaleShell() {
        if (this.shellCreated) {
            return;
        }
        this.scaleShell = new Shell(this.getShell(), 540676);
        this.scaleShell.setLayout((Layout)new BorderLayout());
        Listener closeListener = new Listener(){

            public void handleEvent(Event e) {
                ScaleBox.this.setShowingScale(false);
            }
        };
        this.scaleShell.addListener(27, closeListener);
        this.scaleShell.addListener(21, closeListener);
        this.text.addListener(8, closeListener);
        this.text.addListener(3, closeListener);
        this.text.addListener(12, closeListener);
        this.text.addListener(16, closeListener);
        Shell controlShell = this.getShell();
        controlShell.addListener(10, closeListener);
        controlShell.addListener(11, closeListener);
        Composite popup = new Composite((Composite)this.scaleShell, 0);
        popup.setLayoutData((Object)"Center");
        popup.setLayout((Layout)new BorderLayout());
        this.scale = new DecimalScale(popup, 524288);
        this.scale.setLayoutData("Center");
        this.scale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScaleBox.this.text.setText(String.valueOf(ScaleBox.this.scale.getSelection()));
            }
        });
        this.scale.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ScaleBox.this.setShowingScale(false);
            }
        });
        this.scaleShell.pack();
        this.shellCreated = true;
    }

    @Override
    public void closeDialog() {
        if (this.scaleShell != null && !this.scaleShell.isDisposed()) {
            this.scaleShell.setVisible(false);
        }
    }

    protected void toggleShowingScale() {
        this.setShowingScale(!this.showingScale);
    }

    protected void setShowingScale(boolean isShow) {
        try {
            if (isShow) {
                this.createScaleShell();
                if (this.button != null) {
                    this.button.removeSelectionListener(this.buttonSelection);
                }
                Rectangle sizeT = this.text.getBounds();
                Point pntT = this.text.toDisplay(-2, sizeT.height - 4);
                Rectangle rect = new Rectangle(pntT.x, pntT.y, sizeT.width - 2, this.scaleShell.getBounds().height);
                this.scale.setDecimalPlaces(this.getScaleDecimalPlaces());
                this.scale.setMaximum(this.getMaximum());
                this.scale.setMinimum(this.getMinimum());
                this.scale.setIncrement(this.getIncrement());
                this.scale.setPageIncrement(this.getPageIncrement());
                this.scale.setSelection(this.getIntegerValue());
                this.scaleShell.setBounds(rect);
                this.scaleShell.setVisible(true);
                this.text.setFocus();
            } else if (this.scaleShell != null && !this.scaleShell.isDisposed()) {
                this.scaleShell.setVisible(false);
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ScaleBox.this.button != null) {
                            ScaleBox.this.button.addSelectionListener(ScaleBox.this.buttonSelection);
                        }
                    }
                });
            }
        }
        finally {
            this.showingScale = isShow;
        }
    }

    public static void main(String ... args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
        Composite comp = new Composite((Composite)shell, 0);
        comp.setLayoutData((Object)"North");
        comp.setLayout((Layout)new ColumnLayout());
        ScaleBox box1 = new ScaleBox(comp, 0);
        box1.setLayoutData(new ColumnLayoutData(200));
        box1.setUnit("eV");
        box1.setLabel("Fred");
        box1.setLabelWidth(200);
        box1.setScaleDecimalPlaces(2);
        box1.addBoundsListener(new BoundsListener(){

            @Override
            public void valueGreater(BoundsEvent e) {
                System.out.println(e);
            }

            @Override
            public void valueLegal(BoundsEvent e) {
                System.out.println(e);
            }

            @Override
            public void valueLess(BoundsEvent e) {
                System.out.println(e);
            }
        });
        ScaleBox box2 = new ScaleBox(comp, 0);
        box2.setLayoutData(new ColumnLayoutData(200));
        box2.setMaximum(1000.0);
        box2.setMinimum(0.0);
        box2.setIncrement(10.0);
        box2.setPageIncrement(100.0);
        box2.setUnit("eV");
        box2.setLabelWidth(200);
        box2.setDecimalPlaces(4);
        ScaleBox box3 = new ScaleBox(comp, 0);
        box3.setLayoutData(new ColumnLayoutData(200));
        box3.setDecimalPlaces(2);
        box3.setMaximum(20.51);
        box3.setMinimum(-20.51);
        box3.setIncrement(0.02);
        box3.setUnit("eV");
        ScaleBox box4 = new ScaleBox(comp, 0);
        box4.setLayoutData(new ColumnLayoutData(200));
        box4.setDecimalPlaces(0);
        box4.setUnit("s");
        box4.setIntegerValue(-25);
        box4.setMaximum(-20.0);
        box4.setMinimum(-50.0);
        shell.pack();
        shell.setSize(400, 400);
        SWTUtils.showCenteredShell(shell);
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setIncrement(double increment) {
        this.increment = increment;
    }

    public double getPageIncrement() {
        return this.pageIncrement;
    }

    public void setPageIncrement(double pageIncrement) {
        this.pageIncrement = pageIncrement;
    }

    public int getScaleDecimalPlaces() {
        return this.scaleDecimalPlaces;
    }

    public void setScaleDecimalPlaces(int scaleDecimalPlaces) {
        this.scaleDecimalPlaces = scaleDecimalPlaces;
    }
}

