/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import com.swtdesigner.SWTResourceManager;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IRangeWidget;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.scalebox.internal.RangeDialog;
import uk.ac.gda.richbeans.event.ValueEvent;

public class RangeBox
extends NumberBox
implements IRangeWidget {
    private String dialogTitle;
    private boolean rangeOnly = false;
    private boolean error = false;
    private RangeDialog dialog = null;

    public RangeBox(Composite parent, int style) {
        super(parent, style);
        this.buttonSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RangeBox.this.dialog = new RangeDialog(RangeBox.this.getShell(), RangeBox.this.isIntegerBox());
                RangeBox.this.dialog.setRangeOnly(RangeBox.this.isRangeOnly());
                RangeBox.this.dialog.create();
                if (RangeBox.this.getDialogTitle() != null) {
                    RangeBox.this.dialog.getShell().setText(RangeBox.this.getDialogTitle());
                }
                RangeBox.this.dialog.setUnit(RangeBox.this.getUnit());
                RangeBox.this.dialog.setValue(RangeBox.this.getValue());
                RangeBox.this.dialog.setBounds(RangeBox.this);
                if (RangeBox.this.dialog.open() == 0) {
                    RangeBox.this.checkValue(RangeBox.this.dialog.getValue());
                }
                RangeBox.this.dialog = null;
            }
        };
        this.setButtonVisible(true);
        this.button.setToolTipText("Open range form which allows this value to be defined as a range.");
        this.button.setImage(SWTResourceManager.getImage(RangeBox.class, "/icons/arrow_divide.png"));
        this.button.setText("");
        GridData bLayout = (GridData)this.button.getLayoutData();
        bLayout.widthHint = 29;
    }

    @Override
    public void closeDialog() {
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    @Override
    protected void createTextListeners(final StyledText text) {
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!RangeBox.this.isOn()) {
                    return;
                }
                try {
                    RangeBox.this.on = false;
                    RangeBox.this.checkValue(text.getText());
                }
                finally {
                    RangeBox.this.on = true;
                }
            }
        };
        text.addFocusListener((FocusListener)this.focusListener);
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RangeBox.this.checkValue(text.getText());
                ValueEvent evt = new ValueEvent(RangeBox.this, RangeBox.this.getFieldName());
                evt.setValue(RangeBox.this.getValue());
                RangeBox.this.eventDelegate.notifyValueListeners(evt);
            }
        };
        text.addModifyListener(this.modifyListener);
    }

    @Override
    protected void checkValue(String txt) {
        if (txt == null) {
            return;
        }
        if ("".equals(txt.trim())) {
            return;
        }
        if ("-".equals(txt.trim())) {
            return;
        }
        try {
            Pattern regExp = this.getRegExpression();
            if (regExp.matcher(txt).matches() || regExp.matcher(String.valueOf(txt) + " " + this.unit).matches()) {
                super.checkValue(txt);
                return;
            }
        }
        catch (Throwable throwable) {}
        String value = DOEUtils.removeUnit((String)txt, (String)this.unit);
        if (this.unit != null) {
            txt = String.valueOf(value.trim()) + " " + this.unit;
        }
        if (!txt.equals(this.text.getText())) {
            int pos = this.text.getCaretOffset();
            this.text.setText(txt);
            this.text.setCaretOffset(pos);
        }
        boolean isList = DOEUtils.isList((String)value, (int)this.getDecimalPlaces(), null);
        if (this.isRangeOnly()) {
            isList = false;
        }
        boolean isRange = DOEUtils.isRange((String)value, (int)this.getDecimalPlaces(), null);
        if (!isList && !isRange) {
            this.error = true;
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setForeground(this.red);
            }
            if (this.isRangeOnly()) {
                this.setTooltipOveride("A range should be entered in the form: <start>; <stop>; <increment>.\n");
            } else {
                this.setTooltipOveride("A range should be entered in the form: <start>; <stop>; <increment>.\n\nA list should be a comma separerated list of numbers (two or more).");
            }
        } else {
            this.error = false;
            if (!this.checkBounds(value)) {
                return;
            }
            this.setTooltipOveride(null);
            if (this.isEditable()) {
                if (this.black == null) {
                    this.black = this.getDisplay().getSystemColor(2);
                }
                if (!this.black.isDisposed()) {
                    this.text.setForeground(this.black);
                }
            } else {
                if (this.grey == null) {
                    this.grey = this.getDisplay().getSystemColor(16);
                }
                if (!this.grey.isDisposed()) {
                    this.text.setForeground(this.grey);
                }
            }
        }
    }

    private boolean checkBounds(String value) {
        this.error = false;
        List dbls = DOEUtils.expand((String)value);
        for (Number val : dbls) {
            if (this.isValidBounds(val.doubleValue())) continue;
            this.error = true;
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setForeground(this.red);
            }
            this.setTooltipOveride("The range '" + value + "' would give the value '" + val + "' which is out of bounds.");
            return false;
        }
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.text.setText("");
            return;
        }
        this.checkValue(value.toString());
    }

    @Override
    public String getValue() {
        String txt = this.text.getText();
        if (txt == null) {
            return null;
        }
        if ("".equals(txt.trim())) {
            return null;
        }
        return DOEUtils.removeUnit((String)txt, (String)this.unit);
    }

    @Override
    public void setExpressionManager(IExpressionManager man) {
        this.expressionManager = null;
    }

    @Override
    public boolean isExpressionAllowed() {
        return false;
    }

    public List<? extends Number> getRange() {
        return DOEUtils.expand((String)this.getValue());
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public boolean isRangeOnly() {
        return this.rangeOnly;
    }

    public void setRangeOnly(boolean rangeOnly) {
        this.rangeOnly = rangeOnly;
    }

    public boolean isError() {
        return this.error;
    }
}

