/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.components.scalebox.DemandBox;

public class NumberBoxTest {
    private static Display display;
    private static Shell shell;

    @BeforeClass
    public static void beforeClass() {
        display = new Display();
        shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
    }

    private void testDecimalPlaces(int decimalPlaces, String newUnit, double expected, String txt) {
        DemandBox box = new DemandBox((Composite)shell, 0);
        box.setDecimalPlaces(decimalPlaces);
        box.setUnit(newUnit);
        Assert.assertEquals((String)"0.12345", (double)expected, (double)box.getNumericValue(txt), (double)1.0E-10);
    }

    @Test
    public void testDecimalPlaces0() {
        this.testDecimalPlaces(0, null, 0.0, "0.12345");
    }

    @Test
    public void testDecimalPlaces1() {
        this.testDecimalPlaces(1, null, 0.1, "0.12345");
    }

    @Test
    public void testDecimalPlaces2() {
        this.testDecimalPlaces(2, null, 0.12, "0.12345");
    }

    @Test
    public void testDecimalPlaces3() {
        this.testDecimalPlaces(3, null, 0.123, "0.12345");
    }

    @Test
    public void testDecimalPlaces4() {
        this.testDecimalPlaces(4, null, 0.1235, "0.12345");
    }

    @Test
    public void testDecimalPlaces5() {
        this.testDecimalPlaces(5, null, 0.12345, "0.12345");
    }

    @Test
    public void testDecimalPlaces0Units() {
        this.testDecimalPlaces(0, "mm", 0.0, "0.12345 mm");
    }

    @Test
    public void testDecimalPlaces1Units() {
        this.testDecimalPlaces(1, "mm", 0.1, "0.12345 mm");
    }

    @Test
    public void testDecimalPlaces2Units() {
        this.testDecimalPlaces(2, "mm", 0.12, "0.12345 mm");
    }

    @Test
    public void testDecimalPlaces3Units() {
        this.testDecimalPlaces(3, "mm", 0.123, "0.12345 mm");
    }

    @Test
    public void testDecimalPlaces4Units() {
        this.testDecimalPlaces(4, "mm", 0.1235, "0.12345 mm");
    }

    @Test
    public void testDecimalPlaces5Units() {
        this.testDecimalPlaces(5, "mm", 0.12345, "0.12345 mm");
    }

    @Test
    public void testDecimalPlaces5UnitsPlus() {
        this.testDecimalPlaces(5, "mm", 0.12345, "+0.12345 mm");
    }

    @Test
    public void testDecimalPlaces5UnitsMinus() {
        this.testDecimalPlaces(5, "mm", -0.12345, "-0.12345 mm");
    }

    @Test
    public void testDecimalPlaces0NoDecPoint() {
        this.testDecimalPlaces(0, null, 0.0, "0");
    }

    @Test
    public void testDecimalPlaces5UnitsSpaceBefore() {
        this.testDecimalPlaces(5, "mm", 0.12345, " 0.12345 mm");
    }

    @Test
    public void testDecimalPlaces5UnitsSpaceBeforeNoDecPlace() {
        this.testDecimalPlaces(5, "mm", 1234.0, " 1234 mm");
    }

    @Test
    public void testDecimalPlaces5UnitsSpaceBeforeNoNumberBeforeDecPlace() {
        this.testDecimalPlaces(5, "mm", 0.1234, " .1234 mm");
    }
}

