/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.ACTIVE_MODE;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.BoundsProvider;
import uk.ac.gda.richbeans.components.BoundsUpdater;
import uk.ac.gda.richbeans.components.ButtonComposite;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.event.BoundsEvent;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.ui.utils.StringUtils;

public abstract class NumberBox
extends ButtonComposite
implements BoundsProvider,
IFieldWidget,
IExpressionWidget {
    protected StyledText expressionLabel;
    protected Label label;
    protected StyledText text;
    protected double maximum = 1000.0;
    protected double minimum = 0.0;
    protected int decimalPlaces = 2;
    protected String name;
    protected String unit;
    protected BoundsProvider minProvider;
    protected BoundsProvider maxProvider;
    protected boolean isIntegerBox = false;
    protected boolean validBounds = true;
    protected String tooltipOveride;
    protected NumberFormat numberFormat;
    protected MouseTrackAdapter mouseTrackListener;
    protected FocusAdapter focusListener;
    protected ModifyListener modifyListener;
    protected VerifyKeyListener verifyListener;
    protected SelectionListener selectionListener;
    protected IExpressionManager expressionManager;
    private Object value;
    protected BoundsEvent.Mode currentBoundsMode = BoundsEvent.Mode.LEGAL;
    protected Color red;
    protected Color black;
    protected Color grey;
    protected Color blue;
    protected double numericValue;
    protected double integerValue;
    protected boolean isEditable = true;
    protected String maxFieldName;
    protected Class<?> maxClass;
    protected String minFieldName;
    protected Class<?> minClass;
    private ACTIVE_MODE activeMode = ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE;
    private String boundsKey;

    public NumberBox(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 16384);
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.label.setVisible(false);
        this.text = new StyledText((Composite)this, 2052);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createTextListeners(this.text);
        this.text.setToolTipText(null);
        this.text.setStyleRange(null);
        this.mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                NumberBox.this.setupToolTip();
            }

            public void mouseExit(MouseEvent e) {
                NumberBox.this.text.setToolTipText(null);
            }
        };
        this.text.addMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(this.decimalPlaces);
        this.numberFormat.setGroupingUsed(false);
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    protected void createExpressionLabel(int expressionWidthHint) {
        if (this.expressionLabel != null) {
            return;
        }
        this.expressionLabel = new StyledText((Composite)this, 2060);
        GridData gridLayout = new GridData(4, 0x1000000, false, false);
        gridLayout.widthHint = expressionWidthHint >= 0 ? expressionWidthHint : 100;
        this.expressionLabel.setLayoutData((Object)gridLayout);
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
    }

    protected void checkSubclass() {
    }

    @Override
    public void dispose() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeSelectionListener(this.buttonSelection);
            this.button.dispose();
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
            if (this.focusListener != null) {
                this.text.removeFocusListener((FocusListener)this.focusListener);
            }
            if (this.modifyListener != null) {
                this.text.removeModifyListener(this.modifyListener);
            }
            if (this.selectionListener != null) {
                this.text.removeSelectionListener(this.selectionListener);
            }
            if (this.verifyListener != null) {
                this.text.removeVerifyKeyListener(this.verifyListener);
            }
            this.text.dispose();
        }
        if (this.label != null && !this.label.isDisposed()) {
            this.label.dispose();
        }
        super.dispose();
    }

    protected void createTextListeners(StyledText text) {
        this.createFocusListener(text);
        this.createModifyListener(text);
    }

    protected void createModifyListener(StyledText text) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NumberBox.this.textUpdateAndFireListeners();
            }
        };
        text.addModifyListener(this.modifyListener);
    }

    protected void createSelectionListener(StyledText text) {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NumberBox.this.textUpdateAndFireListeners();
            }
        };
        text.addSelectionListener(this.selectionListener);
    }

    protected void createVerifyKeyListener(StyledText text) {
        this.verifyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
            }
        };
        text.addVerifyKeyListener(this.verifyListener);
    }

    protected void createFocusListener(StyledText text) {
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NumberBox.this.textUpdate();
            }
        };
        text.addFocusListener((FocusListener)this.focusListener);
    }

    protected void textUpdate() {
        if (this.text.isDisposed()) {
            return;
        }
        if (!this.isOn()) {
            return;
        }
        try {
            this.on = false;
            this.checkValue(this.text.getText());
        }
        finally {
            this.on = true;
        }
    }

    protected void textUpdateAndFireListeners() {
        this.textUpdate();
        double numericalValue = this.getNumericValue();
        ValueEvent evt = new ValueEvent(this, this.getFieldName());
        evt.setDoubleValue(numericalValue);
        this.eventDelegate.notifyValueListeners(evt);
    }

    @Override
    public Object getValue() {
        Double val = this.getNumericValue();
        if (Double.isNaN(val)) {
            return null;
        }
        if (this.isIntegerBox || this.getDecimalPlaces() == 0) {
            return new Integer(Math.round(Math.round(val)));
        }
        return new Double(val);
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (value instanceof String) {
                this.checkValue(value.toString());
            } else {
                this.checkValue(this.numberFormat.format(value));
            }
        } else {
            this.text.setText("");
        }
    }

    protected Pattern getRegExpression() {
        String regex = this.getRegExpressionString();
        return Pattern.compile(regex);
    }

    protected String getRegExpressionString() {
        String ndec = this.decimalPlaces > 0 ? "\\d*\\.?\\d{0," + this.decimalPlaces + "})" : ")";
        String digitExpr = "(\\-?\\d*" + ndec;
        if (this.unit == null) {
            return digitExpr;
        }
        return String.valueOf(digitExpr) + "\\ {1}\\Q" + this.unit + "\\E";
    }

    protected void updateValue() {
        this.setupToolTip();
        this.checkValue(this.text.getText());
    }

    protected void checkValue(String txt) {
        if (txt == null || "".equals(txt.trim()) || "-".equals(txt.trim())) {
            GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
            return;
        }
        if (!txt.equals(this.text.getText())) {
            this.text.setText(txt);
        }
        if (this.expressionManager != null) {
            this.processAsExpression(txt);
        } else {
            this.processAsNumber(txt);
        }
    }

    private void processAsExpression(String txt) {
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(txt);
        if (matcher.matches()) {
            this.processAsNumber(txt);
            return;
        }
        txt = txt.trim();
        if (this.unit != null && txt.endsWith(this.unit)) {
            txt = txt.substring(0, txt.length() - this.unit.length());
        } else {
            pattern = Pattern.compile("(.*)\\(" + this.getRegExpressionString() + "\\)");
            matcher = pattern.matcher(txt);
            if (matcher.matches()) {
                txt = matcher.group(1).trim();
            }
        }
        if ("".equals(txt) || txt == null || txt.equals(this.unit)) {
            this.processAsNumber(txt);
            return;
        }
        try {
            Double.parseDouble(txt);
            this.processAsNumber(txt);
            return;
        }
        catch (Throwable throwable) {
            this.expressionManager.setExpression(txt);
            int pos = this.text.getCaretOffset();
            if (this.expressionManager.isExpressionValid()) {
                this.text.setForeground(this.blue);
                this.text.setText(txt);
                this.setExpressionValue(this.expressionManager.getExpressionValue());
                this.checkBounds(this.expressionManager.getExpressionValue());
            } else {
                if (this.red == null) {
                    this.red = this.getDisplay().getSystemColor(3);
                }
                this.text.setForeground(this.red);
                this.text.setText(txt);
                GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
            }
            this.text.setCaretOffset(pos);
            this.layout();
            return;
        }
    }

    @Override
    public void setExpressionValue(double numericalValue) {
        String stringValue = this.numberFormat.format(numericalValue);
        if (Double.isNaN(numericalValue)) {
            GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
            return;
        }
        if (Double.isInfinite(numericalValue)) {
            stringValue = "\u221e";
        }
        if (!this.isExpressionAllowed()) {
            return;
        }
        String u = this.unit != null ? this.unit : "";
        String value = String.valueOf(stringValue) + " " + u;
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, true);
        this.expressionLabel.setText(value);
        this.layout();
        this.checkBounds(numericalValue);
    }

    private void processAsNumber(String txt) {
        Pattern pattern;
        Matcher matcher;
        StringBuilder buf;
        if (this.expressionManager != null) {
            this.expressionManager.setExpression(null);
        }
        if (this.expressionLabel != null) {
            GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
        }
        StringBuilder stringBuilder = buf = (matcher = (pattern = this.getRegExpression()).matcher(txt)).matches() ? null : StringUtils.keepDigits(txt, this.decimalPlaces);
        if (buf != null && "-".equals(buf.toString())) {
            return;
        }
        double numericalValue = Double.NaN;
        try {
            numericalValue = buf != null && buf.length() > 0 ? Double.parseDouble(buf.toString()) : Double.parseDouble(matcher.group(1));
        }
        catch (Exception exception) {
            numericalValue = Double.NaN;
        }
        if (this.unit != null && buf != null && buf.length() > 0) {
            String unitLine = " " + this.unit;
            buf.append(unitLine);
        }
        if (buf != null) {
            int pos = this.text.getCaretOffset();
            this.text.setText(buf.toString());
            this.text.setCaretOffset(pos);
        }
        this.checkBounds(numericalValue);
        GridUtils.layout(this);
    }

    public void checkBounds() {
        this.checkBounds(this.getNumericValue());
    }

    protected void checkBounds(double numericalValue) {
        if (this.isDisposed() || this.text.isDisposed()) {
            return;
        }
        BoundsEvent evt = new BoundsEvent((Widget)this);
        evt.setValue(numericalValue);
        evt.setUpper(this.getMaximum());
        evt.setLower(this.getMinimum());
        this.validBounds = true;
        if (!this.isValidBounds(numericalValue)) {
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setStyleRange(null);
                this.text.setForeground(this.red);
            }
            this.validBounds = false;
            if (numericalValue > this.maximum) {
                evt.setMode(BoundsEvent.Mode.GREATER);
                this.setTooltipOveride("The value '" + numericalValue + "' is greater than the upper limit.");
            } else if (numericalValue < this.minimum) {
                evt.setMode(BoundsEvent.Mode.LESS);
                this.setTooltipOveride("The value '" + numericalValue + "' is less than the lower limit.");
            }
        } else {
            this.setTooltipOveride(null);
            if (this.isEditable()) {
                if (this.blue == null) {
                    this.blue = this.getDisplay().getSystemColor(9);
                }
                if (this.black == null) {
                    this.black = this.getDisplay().getSystemColor(2);
                }
                if (this.expressionManager != null && this.expressionManager.isExpressionValid()) {
                    if (!this.blue.isDisposed()) {
                        this.text.setForeground(this.blue);
                    }
                } else if (!this.black.isDisposed()) {
                    this.text.setForeground(this.black);
                }
            } else {
                if (this.grey == null) {
                    this.grey = this.getDisplay().getSystemColor(16);
                }
                if (!this.grey.isDisposed()) {
                    this.text.setForeground(this.grey);
                }
            }
            evt.setMode(BoundsEvent.Mode.LEGAL);
        }
        try {
            if (this.currentBoundsMode != evt.getMode()) {
                this.eventDelegate.notifyBoundsListeners(evt);
            }
        }
        finally {
            this.currentBoundsMode = evt.getMode();
        }
    }

    protected boolean isValidBounds(double numericalValue) {
        double maximum = this.getMaximum();
        double minimum = this.getMinimum();
        if (Double.isNaN(numericalValue)) {
            return true;
        }
        return numericalValue >= minimum && numericalValue <= maximum;
    }

    protected void setupToolTip() {
        StringBuilder buf = new StringBuilder();
        if (this.getTooltipOveride() != null) {
            buf.append(this.getTooltipOveride());
            buf.append("\n\n");
        }
        buf.append(this.numberFormat.format(this.getMinimum()));
        if (this.unit != null) {
            buf.append(" " + this.unit);
        }
        buf.append(" < ");
        String field = this.getFieldName() != null ? this.getFieldName() : "value";
        buf.append(field);
        buf.append(" < ");
        buf.append(this.numberFormat.format(this.getMaximum()));
        if (this.unit != null) {
            buf.append(" " + this.unit);
        }
        this.text.setToolTipText(buf.toString());
    }

    public void setIntegerBox(boolean isInt) {
        this.isIntegerBox = isInt;
        this.setDecimalPlaces(isInt ? 0 : 2);
    }

    public boolean isIntegerBox() {
        return this.isIntegerBox;
    }

    public double getNumericValue() {
        if (this.text.isDisposed()) {
            return Double.NaN;
        }
        String txt = this.text.getText();
        return this.getNumericValue(txt);
    }

    public double getNumericValue(String txt) {
        String group;
        if (txt == null) {
            return Double.NaN;
        }
        if ("".equals(txt.trim())) {
            return Double.NaN;
        }
        if ("-".equals(txt.trim())) {
            return -0.0;
        }
        if (this.expressionManager != null && this.expressionManager.isExpressionValid()) {
            return this.expressionManager.getExpressionValue();
        }
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(txt);
        if (matcher.matches() && !(group = matcher.group(1)).trim().isEmpty()) {
            Double parsedDouble = Double.parseDouble(group);
            return Double.valueOf(String.format("%." + this.decimalPlaces + "f", parsedDouble));
        }
        return Double.NaN;
    }

    public void setNumericValue(double value) {
        this.numericValue = value;
        this.checkValue("" + value);
    }

    public int getIntegerValue() {
        return (int)this.getNumericValue();
    }

    public void setIntegerValue(int value) {
        this.checkValue("" + value);
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        if (this.isDisposed()) {
            return;
        }
        this.text.setEditable(isEditable);
        if (this.isValidBounds()) {
            if (this.black == null) {
                this.black = this.getDisplay().getSystemColor(2);
            }
            if (this.grey == null) {
                this.grey = this.getDisplay().getSystemColor(16);
            }
            if (!this.black.isDisposed() && !this.grey.isDisposed()) {
                this.text.setForeground(isEditable ? this.black : this.grey);
            }
        } else {
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setForeground(this.red);
            }
        }
        if (this.button != null) {
            this.button.setEnabled(isEditable);
        }
    }

    public Color _testGetForeGroundColor() {
        return this.text.getForeground();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.setEditable(isEnabled);
        this.text.setEnabled(isEnabled);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        this.numberFormat.setMaximumFractionDigits(decimalPlaces);
    }

    public double getMaximum() {
        ScaleBox max;
        if (this.maxProvider != null) {
            return this.maxProvider.getBoundValue();
        }
        if (this.maxFieldName != null && this.maxClass != null && (max = (ScaleBox)BeanUI.getBeanField(this.maxFieldName, this.maxClass)) != null) {
            return max.getNumericValue();
        }
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
        this.checkBounds();
    }

    public void setMaximum(double maximum, String fieldName, Class<?> fieldClass) {
        this.maximum = maximum;
        this.maxFieldName = fieldName;
        this.maxClass = fieldClass;
    }

    public void setMaximum(BoundsProvider maxProvider) {
        this.maxProvider = maxProvider;
        this.checkBounds();
        maxProvider.addValueListener(new BoundsUpdater("maxProviderListener", this.getBoundsKey()){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                NumberBox.this.checkBounds();
            }
        });
    }

    public double getMinimum() {
        ScaleBox min;
        if (this.minProvider != null) {
            return this.minProvider.getBoundValue();
        }
        if (this.minFieldName != null && this.minClass != null && (min = (ScaleBox)BeanUI.getBeanField(this.minFieldName, this.minClass)) != null) {
            return min.getNumericValue();
        }
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
        this.checkBounds();
    }

    public void setMinimum(BoundsProvider minProvider) {
        this.minProvider = minProvider;
        this.checkBounds();
        minProvider.addValueListener(new BoundsUpdater("minProviderListener", this.getBoundsKey()){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                NumberBox.this.checkBounds();
            }
        });
    }

    public void setMinimum(double minimum, String fieldName, Class<?> fieldClass) {
        this.minimum = minimum;
        this.minFieldName = fieldName;
        this.minClass = fieldClass;
    }

    public void setLabel(String txt) {
        GridUtils.setVisibleAndLayout((Control)this.label, true);
        this.label.setText(txt);
    }

    public void setLabelWidth(int width) {
        GridData data = (GridData)this.label.getLayoutData();
        data.widthHint = width;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String newUnit) {
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(this.text.getText());
        if (matcher.matches()) {
            this.text.setText(String.valueOf(matcher.group(1)) + " " + newUnit);
        }
        this.unit = newUnit;
        this.updateValue();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String elementName) {
        this.name = elementName;
    }

    @Override
    public double getBoundValue() {
        return this.getNumericValue();
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.activeMode == ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE) {
            this.setVisible(active);
        } else if (this.activeMode == ACTIVE_MODE.SET_ENABLED_AND_ACTIVE) {
            this.setEditable(active);
        }
    }

    public ACTIVE_MODE getActiveMode() {
        return this.activeMode;
    }

    public void setActiveMode(ACTIVE_MODE activeMode) {
        this.activeMode = activeMode;
    }

    public boolean isValidBounds() {
        return this.validBounds;
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    public void copySettings(NumberBox numBox) {
        this.maxProvider = numBox.maxProvider;
        this.minProvider = numBox.minProvider;
        this.maximum = numBox.maximum;
        this.minimum = numBox.minimum;
        this.isIntegerBox = numBox.isIntegerBox;
        this.decimalPlaces = numBox.decimalPlaces;
    }

    public String getTooltipOveride() {
        return this.tooltipOveride;
    }

    public void setTooltipOveride(String tooltipOveride) {
        this.tooltipOveride = tooltipOveride;
    }

    @Override
    public void setExpressionManager(IExpressionManager man) {
        this.expressionManager = man;
        this.createExpressionLabel(-1);
    }

    @Override
    public boolean isExpressionAllowed() {
        return this.expressionManager != null;
    }

    @Override
    public boolean isExpressionParseRequired(String value) {
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            return false;
        }
        if ("".equals(value) || value == null || value.equals(this.unit)) {
            return false;
        }
        try {
            Double.parseDouble(value);
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private String getBoundsKey() {
        if (this.boundsKey == null) {
            this.boundsKey = this.fieldName != null ? this.fieldName : "Widget " + Calendar.getInstance().getTimeInMillis();
        }
        return this.boundsKey;
    }

    @Override
    protected void createButton() {
        super.createButton();
        if (this.button != null && this.button.getLayoutData() instanceof GridData) {
            GridData bLayout = (GridData)this.button.getLayoutData();
            bLayout.heightHint = 25;
        }
    }
}

