/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.ui.utils.SWTUtils;

public class DemandBox
extends NumberBox {
    boolean enabled = true;
    boolean desiredEnabledState = true;

    public DemandBox(Composite parent, int style) {
        this(parent, style, -1);
    }

    public DemandBox(Composite parent, int style, int expressionWidthHint) {
        super(parent, style);
        this.createExpressionLabel(expressionWidthHint);
    }

    public void demandComplete(Object finalPosition) {
        this.desiredEnabledState = true;
        this.setRealState();
        this.setValue(finalPosition);
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
    }

    public void demandComplete() {
        this.desiredEnabledState = true;
        this.setRealState();
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
    }

    public void demandBegin(double startPosition) {
        this.desiredEnabledState = false;
        this.setRealState();
        this.setExpressionValue(startPosition);
    }

    public void demandStep(double stepPosition) {
        this.desiredEnabledState = false;
        this.setRealState();
        this.setExpressionValue(stepPosition);
    }

    @Override
    public boolean isExpressionAllowed() {
        return true;
    }

    @Override
    public void setExpressionManager(IExpressionManager man) {
        this.expressionManager = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setRealState();
    }

    public void setRealState() {
        super.setEnabled(this.desiredEnabledState & this.enabled);
    }

    @Override
    protected void createTextListeners(StyledText text) {
        this.createFocusListener(text);
        this.createModifyListener(text);
        this.createVerifyKeyListener(text);
    }

    @Override
    protected void createVerifyKeyListener(StyledText text) {
        this.verifyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.character == '\r') {
                    DemandBox.this.textUpdateAndFireListeners();
                }
            }
        };
        text.addVerifyKeyListener(this.verifyListener);
    }

    @Override
    protected void createModifyListener(StyledText text) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DemandBox.this.textUpdate();
            }
        };
        text.addModifyListener(this.modifyListener);
    }

    @Override
    protected void createFocusListener(StyledText text) {
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DemandBox.this.textUpdateAndFireListeners();
            }
        };
        text.addFocusListener((FocusListener)this.focusListener);
    }

    public static void main(String ... args) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
        Composite comp = new Composite((Composite)shell, 0);
        comp.setLayoutData((Object)"North");
        comp.setLayout((Layout)new GridLayout(1, false));
        final DemandBox x = new DemandBox(comp, 0);
        x.setUnit("micron");
        x.setLabel("x");
        x.setLabelWidth(20);
        x.setLayoutData(new GridData(4, 0x1000000, true, false));
        final DemandBox y = new DemandBox(comp, 0, 30);
        y.setUnit("micron");
        y.setLabel("y");
        y.setLabelWidth(20);
        y.setLayoutData(new GridData(4, 0x1000000, true, false));
        final DemandBox z = new DemandBox(comp, 0);
        z.setUnit("micron");
        z.setLabel("z");
        z.setLabelWidth(20);
        z.setLayoutData(new GridData(4, 0x1000000, true, false));
        final Label value = new Label(comp, 0);
        value.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Label moveError = new Label(comp, 0);
        value.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        moveError.setText("");
        final TestMover xMotor = new TestMover(1.0);
        final TestMover zMotor = new TestMover(1.0);
        xMotor.setInitialPosition(5.0);
        zMotor.setInitialPosition(5.0);
        x.setValue(xMotor.getPosition());
        y.setValue(xMotor.getPosition());
        z.setValue(zMotor.getPosition());
        xMotor.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (xMotor.isBusy()) {
                            x.demandStep(xMotor.getPosition());
                            y.demandStep(xMotor.getPosition());
                        } else {
                            x.demandComplete(xMotor.getPosition());
                            y.demandComplete(xMotor.getPosition());
                        }
                    }
                });
            }
        });
        zMotor.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (zMotor.isBusy()) {
                            z.demandStep(zMotor.getPosition());
                        } else {
                            z.demandComplete();
                        }
                    }
                });
            }
        });
        x.addValueListener(new ValueAdapter("x value listener"){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                double destPosition = e.getDoubleValue();
                x.demandBegin(xMotor.getPosition());
                xMotor.moveTo(destPosition);
                moveError.setText("");
                shell.layout();
            }
        });
        y.addValueListener(new ValueAdapter("y value listener"){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                double destPosition = e.getDoubleValue();
                y.demandBegin(xMotor.getPosition());
                xMotor.moveTo(destPosition);
                moveError.setText("");
                shell.layout();
            }
        });
        z.addValueListener(new ValueAdapter("z value listener"){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                double destPosition = e.getDoubleValue();
                z.demandBegin(zMotor.getPosition());
                zMotor.moveTo(destPosition);
                moveError.setText("");
                shell.layout();
            }
        });
        ValueAdapter l = new ValueAdapter("test"){

            @Override
            public void valueChangePerformed(ValueEvent e) {
                StringBuilder buf = new StringBuilder();
                this.addValue("x", x, buf);
                this.addValue("y", y, buf);
                this.addValue("z", z, buf);
                value.setText(buf.toString());
                shell.layout();
            }

            private void addValue(String label, DemandBox box, StringBuilder buf) {
                buf.append(label);
                buf.append("=");
                buf.append(box.getValue());
                buf.append(" ");
                buf.append(box.getUnit());
                buf.append("    ");
            }
        };
        x.addValueListener(l);
        y.addValueListener(l);
        z.addValueListener(l);
        shell.pack();
        shell.setSize(400, 400);
        x.on();
        y.on();
        z.on();
        SWTUtils.showCenteredShell(shell);
    }

    private static class TestMover
    extends Observable {
        private boolean busy = false;
        private double value = 0.0;
        private double stepSize = 1.0;

        TestMover(double stepSize) {
            this.stepSize = stepSize;
        }

        public void setInitialPosition(double d) {
            this.value = d;
        }

        public void moveTo(final double target) {
            if (this.busy) {
                return;
            }
            this.busy = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    double step = TestMover.this.value > target ? -TestMover.this.stepSize : TestMover.this.stepSize;
                    while (true) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (step < 0.0 && TestMover.this.value <= target || step > 0.0 && TestMover.this.value >= target) break;
                        TestMover testMover = TestMover.this;
                        testMover.value = testMover.value + step;
                        TestMover.this.setChanged();
                        TestMover.this.notifyObservers(TestMover.this.value);
                    }
                    TestMover.this.setChanged();
                    TestMover.this.notifyObservers();
                    TestMover.this.busy = false;
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        }

        public double getPosition() {
            return this.value;
        }

        public boolean isBusy() {
            return this.busy;
        }
    }
}

