/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;

class DecimalScale {
    private Scale scale;
    private double offset = 0.0;
    private double scaleset = 1.0;
    private double minimum = 0.0;
    private double maximum = 100.0;

    public DecimalScale(Composite comp, int flags) {
        this.scale = new Scale(comp, flags);
    }

    private final int toScale(double val) {
        val += this.offset;
        return (int)(val *= this.scaleset);
    }

    private final double toWorld(double val) {
        val /= this.scaleset;
        return val -= this.offset;
    }

    public double getSelection() {
        return this.toWorld(this.scale.getSelection());
    }

    public void setSelection(double val) {
        this.scale.setSelection(this.toScale(val));
    }

    private void calculateOffset() {
        this.offset = this.minimum >= 0.0 && this.maximum > 0.0 ? 0.0 : -1.0 * this.minimum;
        this.scale.setMinimum(this.toScale(this.minimum));
        this.scale.setMaximum(this.toScale(this.maximum));
    }

    public double getMinimum() {
        return this.toWorld(this.scale.getMinimum());
    }

    public void setMinimum(double min) {
        this.minimum = min;
        if (min >= this.maximum) {
            this.maximum = min + 1.0;
        }
        this.calculateOffset();
    }

    public double getMaximum() {
        return this.toWorld(this.scale.getMaximum());
    }

    public void setMaximum(double max) {
        this.maximum = max;
        if (max <= this.minimum) {
            this.minimum = max - 1.0;
        }
        this.calculateOffset();
    }

    public void setLayoutData(Object data) {
        this.scale.setLayoutData(data);
    }

    public void addListener(int selection, Listener listener) {
        this.scale.addListener(selection, listener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.scale.addFocusListener(focusListener);
    }

    public void setDecimalPlaces(int places) {
        this.scaleset = Math.pow(10.0, places);
    }

    public void setIncrement(double increment) {
        this.scale.setIncrement((int)(increment * this.scaleset));
    }

    public void setPageIncrement(double pageIncrement) {
        this.scale.setPageIncrement((int)(pageIncrement * this.scaleset));
    }
}

