/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.file;

import java.io.File;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;
import uk.ac.gda.ui.content.FileContentProposalProvider;
import uk.ac.gda.ui.content.IFilterExtensionProvider;
import uk.ac.gda.ui.utils.SWTUtils;

public class FileBox
extends FieldComposite
implements IFieldWidget,
IFilterExtensionProvider {
    private ChoiceType choiceType = ChoiceType.FULL_PATH;
    private final Text text;
    private String[] filterExtensions;
    private String fileTitle;
    private File selectedFolder;
    private ModifyListener modifyListener;
    private SelectionAdapter selectionListener;
    private Button button;
    private boolean isFolder = false;
    private Dialog dialog;
    private boolean active = true;

    public FileBox(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new BorderLayout());
        this.eventDelegate = new EventManagerDelegate(this);
        int textStyle = style == 0 ? 2048 : style;
        this.text = new Text((Composite)this, textStyle);
        this.text.setLayoutData((Object)"Center");
        this.mainControl = this.text;
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValueEvent evt = new ValueEvent(FileBox.this, FileBox.this.getFieldName());
                evt.setValue(FileBox.this.getValue());
                FileBox.this.eventDelegate.notifyValueListeners(evt);
            }
        };
        this.text.addModifyListener(this.modifyListener);
        FileContentProposalProvider prov = new FileContentProposalProvider();
        prov.setFilterExtensionProv(this);
        ContentProposalAdapter ad = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)prov, null, null);
        ad.setProposalAcceptanceStyle(2);
        this.button = new Button((Composite)this, 8);
        this.button.setText("..");
        this.button.setLayoutData((Object)"East");
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path;
                if (FileBox.this.dialog == null) {
                    FileBox.this.dialog = (Dialog)(FileBox.this.isFolder() ? new DirectoryDialog(FileBox.this.getShell(), 4096) : new FileDialog(FileBox.this.getShell(), 4096));
                    String title = FileBox.this.getFileTitle();
                    if (title != null) {
                        FileBox.this.dialog.setText(title);
                    }
                }
                if (FileBox.this.dialog instanceof FileDialog) {
                    ((FileDialog)FileBox.this.dialog).setFilterExtensions(FileBox.this.getFilterExtensions());
                    if (FileBox.this.text.getText() != null) {
                        try {
                            if (FileBox.this.selectedFolder != null) {
                                ((FileDialog)FileBox.this.dialog).setFilterPath(FileBox.this.selectedFolder.getAbsolutePath());
                            }
                            ((FileDialog)FileBox.this.dialog).setFileName(FileBox.this.text.getText());
                        }
                        catch (Exception exception) {}
                    }
                }
                String string = path = FileBox.this.isFolder() ? ((DirectoryDialog)FileBox.this.dialog).open() : ((FileDialog)FileBox.this.dialog).open();
                if (path == null) {
                    return;
                }
                FileBox.this.setValue(path);
            }
        };
        this.button.addSelectionListener((SelectionListener)this.selectionListener);
    }

    @Override
    public void closeDialog() {
    }

    @Override
    public void dispose() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
            this.text.dispose();
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeSelectionListener((SelectionListener)this.selectionListener);
            this.button.dispose();
        }
        super.dispose();
    }

    @Override
    public Object getValue() {
        if (this.getChoiceType() == ChoiceType.FULL_PATH) {
            return new File(this.selectedFolder, this.text.getText()).getAbsolutePath();
        }
        return this.text.getText();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.text.setText("");
            return;
        }
        if (this.getChoiceType() == ChoiceType.FULL_PATH || value.toString().contains(System.getProperty("file.separator"))) {
            File sel = new File(value.toString());
            this.selectedFolder = sel.getParentFile();
            this.text.setToolTipText(this.selectedFolder.getAbsolutePath());
            this.text.setText(sel.getName());
            this.text.setSelection(sel.getName().length());
        } else {
            if (this.selectedFolder != null) {
                this.text.setToolTipText(this.selectedFolder.getAbsolutePath());
            }
            this.text.setText((String)value);
            this.text.setSelection(((String)value).length());
        }
    }

    public void setError(boolean isError, String reason) {
        if (isError) {
            Color red = this.getDisplay().getSystemColor(3);
            if (!red.isDisposed()) {
                this.text.setForeground(red);
            }
            this.text.setToolTipText(reason);
        } else {
            Color black = this.getDisplay().getSystemColor(2);
            if (!black.isDisposed()) {
                this.text.setForeground(black);
            }
            this.text.setToolTipText(this.selectedFolder.getAbsolutePath());
        }
    }

    protected void checkSubclass() {
    }

    @Override
    public boolean isActivated() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        this.setVisible(active);
    }

    @Override
    public void addValueListener(ValueListener l) {
        this.eventDelegate.addValueListener(l);
    }

    @Override
    public void removeValueListener(ValueListener l) {
        this.eventDelegate.removeValueListener(l);
    }

    @Override
    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public static void main(String ... args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
        Composite comp = new Composite((Composite)shell, 0);
        comp.setLayoutData((Object)"North");
        comp.setLayout((Layout)new ColumnLayout());
        FileBox box1 = new FileBox(comp, 0);
        box1.setLayoutData(new ColumnLayoutData(200));
        box1.setFilterExtensions(new String[]{"*.xml", "*.txt"});
        box1.setFileTitle("XML or Text file chooser");
        FileBox box2 = new FileBox(comp, 0);
        box2.setLayoutData(new ColumnLayoutData(200));
        box2.setFilterExtensions(new String[]{"*.jpg", "*.png"});
        FileBox box3 = new FileBox(comp, 0);
        box3.setLayoutData(new ColumnLayoutData(200));
        shell.pack();
        shell.setSize(400, 400);
        SWTUtils.showCenteredShell(shell);
    }

    public String getFileTitle() {
        return this.fileTitle;
    }

    public void setFileTitle(String fileTitle) {
        this.fileTitle = fileTitle;
    }

    public void setFolder(File selectedFolder) {
        this.selectedFolder = selectedFolder;
        this.text.setToolTipText(selectedFolder.getAbsolutePath());
    }

    public void setText(String fileName) {
        if (fileName == null) {
            this.text.setText("");
            return;
        }
        this.text.setText(fileName);
    }

    public String getText() {
        return this.text.getText();
    }

    public ChoiceType getChoiceType() {
        return this.choiceType;
    }

    public void setChoiceType(ChoiceType choiceType) {
        this.choiceType = choiceType;
    }

    public File getFolder() {
        return this.selectedFolder;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setFolder(boolean isFolder) {
        this.dialog = null;
        this.isFolder = isFolder;
    }

    public static enum ChoiceType {
        FULL_PATH,
        NAME_ONLY;

    }
}

