/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.cell;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.richbeans.components.cell.IXMLFileListProvider;

public class XMLChooserEditor
extends CellEditor {
    private IFolder containingFolder;
    private IXMLFileListProvider[] fileListProviders;
    private CCombo comboBox;
    private List<String> names;
    private KeyAdapter keyListener;
    private SelectionAdapter selectionListener;
    private TraverseListener traverseListener;
    private FocusAdapter focusListener;
    private IResourceChangeListener resourceChangeListener;

    public XMLChooserEditor(Composite parent, IFolder containingFolder, IXMLFileListProvider[] fileListProviders) {
        super(parent);
        this.containingFolder = containingFolder;
        this.fileListProviders = fileListProviders;
    }

    protected Control createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        content.setLayout((Layout)gridLayout);
        this.comboBox = new CCombo(content, 8);
        this.comboBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.comboBox.setFont(parent.getFont());
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                XMLChooserEditor.this.keyReleaseOccured(e);
            }
        };
        this.comboBox.addKeyListener((KeyListener)this.keyListener);
        this.selectionListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                XMLChooserEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
            }
        };
        this.comboBox.addSelectionListener((SelectionListener)this.selectionListener);
        this.traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        };
        this.comboBox.addTraverseListener(this.traverseListener);
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                XMLChooserEditor.this.focusLost();
            }
        };
        this.comboBox.addFocusListener((FocusListener)this.focusListener);
        return content;
    }

    public void dispose() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener((KeyListener)this.keyListener);
        }
        if (this.selectionListener != null) {
            this.comboBox.removeSelectionListener((SelectionListener)this.selectionListener);
        }
        if (this.traverseListener != null) {
            this.comboBox.removeTraverseListener(this.traverseListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener((FocusListener)this.focusListener);
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        super.dispose();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected Object doGetValue() {
        int sel;
        if (this.comboBox != null && (sel = this.comboBox.getSelectionIndex()) >= 0 && sel < this.getNames().size()) {
            return this.getNames().get(sel);
        }
        return null;
    }

    protected void doSetFocus() {
        if (this.comboBox != null) {
            this.comboBox.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        if (this.comboBox != null) {
            this.comboBox.setItems(this.getNames().toArray(new String[this.getNames().size()]));
            this.comboBox.select(this.getNames().indexOf(value));
        }
    }

    private List<String> getNames() {
        this.names = new ArrayList<String>();
        try {
            if (this.containingFolder != null) {
                IXMLFileListProvider[] iXMLFileListProviderArray = this.fileListProviders;
                int n = this.fileListProviders.length;
                int n2 = 0;
                while (n2 < n) {
                    IXMLFileListProvider fileListProvider = iXMLFileListProviderArray[n2];
                    List<IFile> sortedFileList = fileListProvider.getSortedFileList(this.containingFolder);
                    for (IFile iFile : sortedFileList) {
                        this.names.add(iFile.getName());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    XMLChooserEditor.this.names = null;
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        }
        return this.names;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    void applyEditorValueAndDeactivate() {
        int selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            if (this.getNames().size() > 0 && selection >= 0 && selection < this.getNames().size()) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.getNames().get(selection)));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }
}

