/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.cell;

import com.swtdesigner.SWTResourceManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.components.cell.AppliableCellEditor;
import uk.ac.gda.richbeans.components.scalebox.RangeBox;
import uk.ac.gda.richbeans.components.wrappers.SpinnerWrapper;
import uk.ac.gda.richbeans.event.ValueListener;

public class SpinnerCellEditorWithPlayButton
extends AppliableCellEditor {
    private final String playJobName;
    private final long waitTime;
    private boolean isPlaying = false;
    private Button play;
    private RangeBox rangeBox;
    private SpinnerWrapper spinner;
    private IProgressMonitor playMonitor;

    public SpinnerCellEditorWithPlayButton(TableViewer viewer, String playJobName, long waitTime) {
        super((Composite)viewer.getTable());
        this.playJobName = playJobName;
        this.waitTime = waitTime > 0L ? waitTime : 1000L;
    }

    protected Control createControl(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(3, false));
        GridUtils.removeMargins(area);
        this.spinner = new SpinnerWrapper(area, 0);
        this.spinner.setLayoutData(new GridData(4, 0x1000000, true, true));
        this.spinner.on();
        this.play = new Button(area, 2);
        this.play.setImage(SWTResourceManager.getImage(SpinnerCellEditorWithPlayButton.class, "/icons/control_play_blue.png"));
        GridData playData = new GridData(0x1000000, 0x1000000, false, false);
        playData.widthHint = 24;
        playData.heightHint = 24;
        this.play.setLayoutData((Object)playData);
        this.play.setToolTipText("Play through the slices");
        this.play.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SpinnerCellEditorWithPlayButton.this.isPlaying = !SpinnerCellEditorWithPlayButton.this.isPlaying;
                SpinnerCellEditorWithPlayButton.this.updatePlaying();
            }

            public void widgetSelected(SelectionEvent e) {
                SpinnerCellEditorWithPlayButton.this.isPlaying = !SpinnerCellEditorWithPlayButton.this.isPlaying;
                SpinnerCellEditorWithPlayButton.this.updatePlaying();
            }
        });
        this.rangeBox = new RangeBox(area, 0);
        this.rangeBox.setLayoutData(new GridData(4, 4, true, true));
        this.rangeBox.setIntegerBox(true);
        this.rangeBox.setRangeOnly(true);
        GridUtils.setVisible((Control)this.rangeBox, false);
        this.rangeBox.off();
        return area;
    }

    public void setRangeMode(boolean range) {
        GridUtils.setVisible((Control)this.rangeBox, range);
        GridUtils.setVisible((Control)this.spinner, !range);
        GridUtils.setVisible((Control)this.play, !range);
        ((Composite)this.getControl()).getParent().layout(new Control[]{this.rangeBox, this.spinner, this.play});
        if (range) {
            this.rangeBox.setValue(this.spinner.getValue().toString());
            this.rangeBox.on();
            this.spinner.off();
        } else {
            this.spinner.setValue(this.rangeBox.getRange().get(0).intValue());
            this.rangeBox.off();
            this.spinner.on();
        }
    }

    protected void updatePlaying() {
        if (this.playJobName == null) {
            return;
        }
        if (!this.isPlaying) {
            if (this.playMonitor != null) {
                this.playMonitor.setCanceled(true);
            }
            this.playMonitor = null;
            return;
        }
        final int currentValue = (Integer)this.spinner.getValue();
        final int max = this.spinner.getMaximum();
        final int min = this.spinner.getMinimum();
        Job job = new Job(this.playJobName){

            protected IStatus run(IProgressMonitor monitor) {
                SpinnerCellEditorWithPlayButton.this.playMonitor = monitor;
                int val = currentValue;
                while (!monitor.isCanceled() && !SpinnerCellEditorWithPlayButton.this.getControl().isDisposed()) {
                    if (++val > max) {
                        val = min;
                    }
                    final int newValue = val;
                    SpinnerCellEditorWithPlayButton.this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SpinnerCellEditorWithPlayButton.this.spinner.isDisposed()) {
                                return;
                            }
                            SpinnerCellEditorWithPlayButton.this.spinner.setValue(newValue);
                            SpinnerCellEditorWithPlayButton.this.spinner.fireValueListeners();
                        }
                    });
                    try {
                        Thread.sleep(SpinnerCellEditorWithPlayButton.this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setUser(false);
        job.schedule();
    }

    public void activate() {
        ((Composite)this.getControl()).getParent().layout();
    }

    public void deactivate() {
        super.deactivate();
        this.play.setSelection(false);
        this.isPlaying = false;
        this.updatePlaying();
    }

    protected Object doGetValue() {
        if (this.spinner.isOn()) {
            return this.spinner.getValue();
        }
        if (this.rangeBox.isOn()) {
            return this.rangeBox.getValue();
        }
        return null;
    }

    protected void doSetFocus() {
        if (this.spinner.isOn()) {
            this.spinner.setFocus();
        } else if (this.rangeBox.isOn()) {
            this.rangeBox.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        if (this.spinner.isOn()) {
            try {
                this.spinner.setValue(value);
            }
            catch (NumberFormatException numberFormatException) {
                this.spinner.setValue(0.0);
            }
        } else if (this.rangeBox.isOn()) {
            this.rangeBox.setValue(value);
        }
    }

    @Override
    public void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public void addValueListener(ValueListener l) {
        this.spinner.addValueListener(l);
        this.rangeBox.addValueListener(l);
    }

    public void setMaximum(int i) {
        if (this.spinner != null) {
            this.spinner.setMaximum(i);
        }
        if (this.rangeBox != null) {
            this.rangeBox.setMaximum(i);
        }
    }

    public void setMinimum(int i) {
        if (this.spinner != null) {
            this.spinner.setMinimum(i);
        }
        if (this.rangeBox != null) {
            this.rangeBox.setMinimum(i);
        }
    }

    public void setRangeDialogTitle(String title) {
        if (this.rangeBox != null) {
            this.rangeBox.setDialogTitle(title);
        }
    }

    public void setPlayButtonVisible(boolean isVisible) {
        GridUtils.setVisible((Control)this.play, isVisible);
        this.play.getParent().layout(this.play.getParent().getChildren());
    }
}

