/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.cell;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerCellEditor
extends CellEditor {
    protected Spinner spinner;
    private FocusAdapter focusListener;
    private KeyListener keyListener;
    private static final int defaultStyle = 0;

    public SpinnerCellEditor() {
        this.setStyle(0);
    }

    public SpinnerCellEditor(Composite parent) {
        this(parent, 0);
    }

    public SpinnerCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        this.spinner = new Spinner(parent, this.getStyle());
        this.spinner.setFont(parent.getFont());
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SpinnerCellEditor.this.focusLost();
            }
        };
        this.spinner.addFocusListener((FocusListener)this.focusListener);
        this.keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\n') {
                    SpinnerCellEditor.this.focusLost();
                }
                if (e.character == '\r') {
                    SpinnerCellEditor.this.focusLost();
                }
            }
        };
        this.spinner.addKeyListener(this.keyListener);
        return this.spinner;
    }

    public void dispose() {
        if (this.focusListener != null) {
            this.spinner.removeFocusListener((FocusListener)this.focusListener);
        }
        if (this.keyListener != null) {
            this.spinner.removeKeyListener(this.keyListener);
        }
        super.dispose();
    }

    protected Object doGetValue() {
        return this.spinner.getSelection();
    }

    protected void doSetFocus() {
        this.spinner.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.spinner == null || this.spinner.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.spinner);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.spinner != null && value instanceof Integer ? 1 : 0) != 0);
        this.spinner.setSelection(((Integer)value).intValue());
    }

    void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    public void setMaximum(int i) {
        if (this.spinner != null) {
            this.spinner.setMaximum(i);
        }
    }

    public void setMinimum(int i) {
        if (this.spinner != null) {
            this.spinner.setMinimum(i);
        }
    }

    public Spinner getSpinner() {
        return this.spinner;
    }
}

