/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.cell;

import java.lang.reflect.Constructor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.ValueListener;

public class FieldComponentCellEditor
extends CellEditor {
    private static Logger logger = LoggerFactory.getLogger(FieldComponentCellEditor.class);
    private FieldComposite fieldWidget;
    private Class<? extends FieldComposite> fieldWidgetClass;
    private int widgetStyle;

    public FieldComponentCellEditor(TableViewer viewer, String fieldWidgetClass) throws ClassNotFoundException {
        this((Composite)viewer.getTable(), fieldWidgetClass);
    }

    public FieldComponentCellEditor(Composite viewerControl, String fieldWidgetClass) throws ClassNotFoundException {
        this(viewerControl, fieldWidgetClass, 0);
    }

    public FieldComponentCellEditor(Composite viewerControl, String fieldWidgetClass, int style) throws ClassNotFoundException {
        this.fieldWidgetClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(fieldWidgetClass);
        this.widgetStyle = style;
        this.setStyle(0);
        this.create(viewerControl);
    }

    protected Control createControl(Composite parent) {
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(3, false));
        area.setBackground(Display.getCurrent().getSystemColor(1));
        GridUtils.removeMargins(area);
        try {
            Constructor<? extends FieldComposite> constructor = this.fieldWidgetClass.getConstructor(Composite.class, Integer.TYPE);
            this.fieldWidget = constructor.newInstance(area, this.widgetStyle);
            this.fieldWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
            this.fieldWidget.setBackground(Display.getCurrent().getSystemColor(1));
            if (this.fieldWidget.getLayout() instanceof GridLayout) {
                GridUtils.removeMargins(this.fieldWidget);
            }
            if (this.fieldWidget.getControl() != null) {
                this.fieldWidget.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 13) {
                            FieldComponentCellEditor.this.applyEditorValueAndDeactivate();
                        }
                    }
                });
            }
            this.fieldWidget.on();
        }
        catch (Exception ne) {
            logger.error("Cannot load and instantiate class as FieldComposite " + this.fieldWidgetClass, (Throwable)ne);
        }
        return area;
    }

    public void activate() {
        ((Composite)this.getControl()).getParent().layout();
    }

    public void deactivate() {
        if (this.fieldWidget != null) {
            this.fieldWidget.closeDialog();
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        if (this.fieldWidget != null) {
            return this.fieldWidget.getValue();
        }
        return null;
    }

    protected void doSetFocus() {
        if (this.fieldWidget != null) {
            this.fieldWidget.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        if (this.fieldWidget != null) {
            this.fieldWidget.setValue(value);
        }
    }

    void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public void addValueListener(ValueListener l) {
        this.fieldWidget.addValueListener(l);
    }

    public IFieldWidget getFieldWidget() {
        return this.fieldWidget;
    }
}

