/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.event.BoundsListener;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public abstract class FieldComposite
extends Composite
implements IFieldWidget {
    protected Control mainControl;
    protected EventManagerDelegate eventDelegate = new EventManagerDelegate(this);
    protected NOTIFY_TYPE notifyType;
    protected String fieldName;
    protected boolean on = false;
    protected boolean active = true;

    public void setNotifyType(NOTIFY_TYPE type) {
        this.notifyType = type;
    }

    public FieldComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public void off() {
        this.on = false;
    }

    @Override
    public void on() {
        this.on = true;
    }

    public NOTIFY_TYPE getNotifyType() {
        return this.notifyType;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.mainControl != null) {
            this.mainControl.setEnabled(isEnabled);
        }
    }

    @Override
    public void addValueListener(ValueListener l) {
        this.eventDelegate.addValueListener(l);
    }

    @Override
    public void fireValueListeners() {
        ValueEvent evt = new ValueEvent(this, this.getFieldName());
        evt.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(evt);
    }

    @Override
    public void fireBoundsUpdaters() {
        ValueEvent evt = new ValueEvent(this, this.getFieldName());
        evt.setValue(this.getValue());
        this.eventDelegate.notifyBoundsProviderListeners(evt);
    }

    @Override
    public void dispose() {
        if (this.eventDelegate != null) {
            this.eventDelegate.dispose();
        }
        if (this.mainControl != null) {
            this.mainControl.dispose();
        }
        super.dispose();
    }

    @Override
    public void removeValueListener(ValueListener l) {
        this.eventDelegate.removeValueListener(l);
    }

    public void addBoundsListener(BoundsListener l) {
        this.eventDelegate.addBoundsListener(l);
    }

    public void removeBoundsListener(BoundsListener l) {
        this.eventDelegate.removeBoundsListener(l);
    }

    @Override
    public boolean isActivated() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        return String.valueOf(this.fieldName) + " [" + this.getClass().getName() + "]";
    }

    public Control getControl() {
        return this.mainControl;
    }

    public void closeDialog() {
    }

    public static enum NOTIFY_TYPE {
        DEFAULT,
        VALUE_CHANGED,
        ALWAYS;

    }
}

