/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.richbeans.ACTIVE_MODE;
import uk.ac.gda.richbeans.beans.BeanProvider;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldCollection;
import uk.ac.gda.richbeans.beans.IFieldProvider;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.editors.BeanExpressionManager;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class FieldBeanComposite
extends FieldComposite
implements IFieldCollection,
IExpressionWidget,
IFieldProvider,
BeanProvider {
    private static Logger logger = LoggerFactory.getLogger(FieldBeanComposite.class);
    protected Object beanTemplate;
    protected Object editorUI;
    protected Object editorBean;
    protected String listenerName;
    protected List<String> expressionFields;
    protected boolean active = true;
    private ACTIVE_MODE activeMode = ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE;
    private boolean isOn = false;
    protected Collection<BeanSelectionListener> listeners;
    private boolean isEnabled = true;

    public FieldBeanComposite(Composite parent, int style) {
        this(parent, style, FieldBeanComposite.class.getName());
        this.editorUI = this;
    }

    public FieldBeanComposite(Composite parent, int style, String listenerName) {
        super(parent, style);
        this.listenerName = listenerName;
        this.editorUI = this;
    }

    public void setEditorClass(Class<?> clazz) {
        try {
            this.beanTemplate = clazz.newInstance();
            if (this.editorUI == this) {
                this.addValueListeners(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setEditorUI(Object ui) {
        this.editorUI = ui;
        this.addValueListeners(this.editorUI);
    }

    public Object getEditorUI() {
        return this.editorUI;
    }

    protected void addValueListeners(Object editorUI) {
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...) before setting the editorUI object.");
        }
        try {
            BeanUI.addValueListener(this.beanTemplate, editorUI, new ValueAdapter(this.getListenerName()){

                @Override
                public void valueChangePerformed(ValueEvent e) {
                    try {
                        FieldBeanComposite.this.valueChanged(e);
                    }
                    catch (Exception e1) {
                        logger.error("Cannot process value changed.", (Throwable)e1);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void valueChanged(ValueEvent e) throws Exception {
        try {
            if (e.getFieldName() != null) {
                BeanUI.uiToBean(this.editorUI, this.editorBean, e.getFieldName());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    @Override
    public void addValueListener(ValueListener listener) {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI for each item with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        try {
            BeanUI.addValueListener(this.beanTemplate, this.editorUI, listener);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeValueListener(ValueListener l) {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI for each item with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        try {
            BeanUI.removeValueListener(this.beanTemplate, this.editorUI, l);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dispose() {
        block8: {
            try {
                if (this.listeners != null) {
                    this.listeners.clear();
                }
                if (this.editorUI == null || this.beanTemplate == null) break block8;
                if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                    return;
                }
                try {
                    BeanUI.dispose(this.beanTemplate, this.editorUI);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                super.dispose();
            }
        }
    }

    @Override
    public Object getValue() {
        return this.editorBean;
    }

    @Override
    public void setValue(Object value) {
        this.editorBean = value;
        try {
            this.off();
            if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                return;
            }
            try {
                BeanUI.beanToUI(this.editorBean, this.editorUI);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.on();
        }
    }

    @Override
    public void setExpressionManager(IExpressionManager man) {
        try {
            if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                return;
            }
            BeanUI.notify(this.editorBean, this.editorUI, new BeanUI.BeanProcessor(){

                @Override
                public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                    if (box instanceof IExpressionWidget) {
                        IExpressionWidget expressionBox = (IExpressionWidget)box;
                        if (!expressionBox.isExpressionAllowed()) {
                            return;
                        }
                        BeanExpressionManager man = new BeanExpressionManager(expressionBox, FieldBeanComposite.this);
                        man.setAllowedSymbols(FieldBeanComposite.this.getExpressionFields());
                        expressionBox.setExpressionManager(man);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Cannot link expression widgets for " + this.editorBean, (Throwable)e);
        }
    }

    @Override
    public void setExpressionValue(final double value) {
        try {
            if (this.editorUI instanceof Widget && ((Widget)this.editorUI).isDisposed()) {
                return;
            }
            BeanUI.notify(this.editorBean, this.editorUI, new BeanUI.BeanProcessor(){

                @Override
                public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                    if (box instanceof IExpressionWidget) {
                        IExpressionWidget expressionBox = (IExpressionWidget)box;
                        expressionBox.setExpressionValue(value);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Cannot link expression widgets for " + this.editorBean, (Throwable)e);
        }
    }

    protected List<String> getExpressionFields() throws Exception {
        if (this.expressionFields == null) {
            this.expressionFields = BeanUI.getEditingFields(this.editorBean, this.editorUI);
        }
        return this.expressionFields;
    }

    public void setEditingBean(Object bean) {
        boolean newBean = this.editorBean == null;
        this.editorBean = bean;
        if (newBean) {
            this.setValue(bean);
        }
    }

    @Override
    public boolean isActivated() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        if (this.activeMode == ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE) {
            this.setVisible(active);
        } else if (this.activeMode == ACTIVE_MODE.SET_ENABLED_AND_ACTIVE) {
            this.setVisible(active);
        }
    }

    public ACTIVE_MODE getActiveMode() {
        return this.activeMode;
    }

    public void setActiveMode(ACTIVE_MODE activeMode) {
        this.activeMode = activeMode;
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void off() {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        this.isOn = false;
        this.updateState(this.isOn);
    }

    @Override
    public void on() {
        if (this.editorUI == null) {
            throw new RuntimeException("You must set the editing UI for each item with setEditorUI(...)");
        }
        if (this.beanTemplate == null) {
            throw new RuntimeException("You must set the editing class for with setEditorClass(...)");
        }
        this.isOn = true;
        this.updateState(this.isOn);
    }

    protected void updateState(boolean isOn) {
        try {
            BeanUI.switchState(this.beanTemplate, this.editorUI, isOn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void addBeanSelectionListener(BeanSelectionListener l) {
        if (this.listeners == null) {
            this.listeners = new HashSet<BeanSelectionListener>(7);
        }
        this.listeners.add(l);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        try {
            BeanUI.setEnabled(this.beanTemplate, this.editorUI, isEnabled);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public void setListenerName(String listenerName) {
        this.listenerName = listenerName;
    }

    @Override
    public Object getBean() {
        return this.editorBean;
    }

    @Override
    public Object getInstance() throws Exception {
        return this.beanTemplate.getClass().newInstance();
    }

    @Override
    public IFieldWidget getField(String fieldName) throws Exception {
        return BeanUI.getFieldWiget(fieldName, this.editorUI);
    }

    @Override
    public Object getFieldValue(String fieldName) throws Exception {
        return this.getField(fieldName).getValue();
    }

    @Override
    public Control getControl() {
        return null;
    }

    @Override
    public boolean isExpressionParseRequired(String value) {
        return true;
    }

    @Override
    public boolean isExpressionAllowed() {
        return true;
    }
}

