/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.BoundsUpdater;
import uk.ac.gda.richbeans.components.FieldComposite;
import uk.ac.gda.richbeans.event.BoundsEvent;
import uk.ac.gda.richbeans.event.BoundsListener;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class EventManagerDelegate {
    private IFieldWidget parent;
    protected Collection<ValueListener> valueListeners;
    protected Map<String, ValueListener> valueListenersMap;
    protected Collection<BoundsListener> boundsListeners;

    public EventManagerDelegate(IFieldWidget par) {
        this.parent = par;
    }

    public void addValueListener(ValueListener l) {
        if (l.getValueListenerName() != null) {
            if (this.valueListenersMap == null) {
                this.valueListenersMap = new HashMap<String, ValueListener>(3);
            }
            this.valueListenersMap.put(l.getValueListenerName(), l);
            return;
        }
        if (this.valueListeners == null) {
            this.valueListeners = new HashSet<ValueListener>(3);
        }
        this.valueListeners.add(l);
    }

    public void removeValueListener(ValueListener l) {
        if (l.getValueListenerName() != null) {
            if (this.valueListenersMap == null) {
                return;
            }
            this.valueListenersMap.remove(l.getValueListenerName());
            return;
        }
        if (this.valueListeners == null) {
            return;
        }
        this.valueListeners.remove(l);
    }

    public void notifyValueListeners(ValueEvent evt) {
        if (!this.checkCanNofity()) {
            return;
        }
        try {
            try {
                this.parent.off();
                if (this.valueListenersMap != null) {
                    for (ValueListener l : this.valueListenersMap.values()) {
                        l.valueChangePerformed(evt);
                    }
                }
                if (this.valueListeners != null) {
                    for (ValueListener l : this.valueListeners) {
                        l.valueChangePerformed(evt);
                    }
                }
            }
            catch (Throwable ne) {
                ne.printStackTrace();
                throw new RuntimeException(ne);
            }
        }
        finally {
            this.parent.on();
        }
    }

    public void notifyBoundsProviderListeners(ValueEvent evt) {
        if (!this.checkCanNofity()) {
            return;
        }
        try {
            try {
                this.parent.off();
                if (this.valueListenersMap != null) {
                    for (ValueListener l : this.valueListenersMap.values()) {
                        if (!(l instanceof BoundsUpdater)) continue;
                        l.valueChangePerformed(evt);
                    }
                }
                if (this.valueListeners != null) {
                    for (ValueListener l : this.valueListeners) {
                        if (!(l instanceof BoundsUpdater)) continue;
                        l.valueChangePerformed(evt);
                    }
                }
            }
            catch (Throwable ne) {
                ne.printStackTrace();
                throw new RuntimeException(ne);
            }
        }
        finally {
            this.parent.on();
        }
    }

    private boolean checkCanNofity() {
        FieldComposite comp;
        if (this.parent == null) {
            return false;
        }
        if (this.valueListeners == null && this.valueListenersMap == null) {
            return false;
        }
        if (this.valueListeners != null && this.valueListenersMap != null && this.valueListeners.isEmpty() && this.valueListenersMap.isEmpty()) {
            return false;
        }
        if (this.valueListeners == null && this.valueListenersMap != null && this.valueListenersMap.isEmpty()) {
            return false;
        }
        if (this.valueListenersMap == null && this.valueListeners != null && this.valueListeners.isEmpty()) {
            return false;
        }
        FieldComposite fieldComposite = comp = this.parent instanceof FieldComposite ? (FieldComposite)this.parent : null;
        return comp != null && comp.getNotifyType() != null && comp.getNotifyType() == FieldComposite.NOTIFY_TYPE.ALWAYS || this.parent.isOn();
    }

    public void addBoundsListener(BoundsListener l) {
        if (this.boundsListeners == null) {
            this.boundsListeners = new HashSet<BoundsListener>(3);
        }
        this.boundsListeners.add(l);
    }

    public void removeBoundsListener(BoundsListener l) {
        if (this.boundsListeners == null) {
            return;
        }
        this.boundsListeners.remove(l);
    }

    public void notifyBoundsListeners(BoundsEvent evt) {
        if (this.boundsListeners == null) {
            return;
        }
        if (!this.parent.isOn()) {
            return;
        }
        try {
            try {
                this.parent.off();
                if (evt.getMode() == BoundsEvent.Mode.GREATER) {
                    for (BoundsListener l : this.boundsListeners) {
                        l.valueGreater(evt);
                    }
                } else if (evt.getMode() == BoundsEvent.Mode.LESS) {
                    for (BoundsListener l : this.boundsListeners) {
                        l.valueLess(evt);
                    }
                } else if (evt.getMode() == BoundsEvent.Mode.LEGAL) {
                    for (BoundsListener l : this.boundsListeners) {
                        l.valueLegal(evt);
                    }
                }
            }
            catch (Throwable ne) {
                ne.printStackTrace();
                throw new RuntimeException(ne);
            }
        }
        finally {
            this.parent.on();
        }
    }

    public void dispose() {
        if (this.valueListeners != null) {
            this.valueListeners.clear();
        }
        if (this.valueListenersMap != null) {
            this.valueListenersMap.clear();
        }
        if (this.boundsListeners != null) {
            this.boundsListeners.clear();
        }
        this.parent = null;
    }
}

