/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.beans;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.richbeans.beans.IFieldCollection;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.event.ValueListener;

public class BeanUI {
    private static Map<String, IFieldWidget> cachedWidgets;
    private static Map<String, Collection<ValueListener>> waitingListeners;

    public static void beanToUI(Object bean, Object uiObject) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                Object value = prop.getValue();
                box.setFieldName(prop.getKey().toString());
                if (value == null && !box.isActivated()) {
                    return;
                }
                box.setValue(value);
            }
        });
    }

    public static void fireValueListeners(Object bean, Object uiObject) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                box.fireValueListeners();
            }
        });
    }

    public static void fireBoundsUpdaters(Object bean, Object uiObject) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                box.fireBoundsUpdaters();
            }
        });
    }

    public static void uiToBean(Object uiObject, Object bean) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                try {
                    if (!(box instanceof IFieldCollection)) {
                        prop.setValue(null);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (!box.isActivated()) {
                    return;
                }
                Object ob = box.getValue();
                if (!(ob == null || "".equals(ob) || BeanUI.isNaN(ob) || BeanUI.isInfinity(ob))) {
                    prop.setValue(ob);
                }
            }
        });
    }

    public static void uiToBean(Object uiObject, Object bean, String fieldName) throws Exception {
        if (fieldName == null) {
            throw new Exception("Null fieldName passed to uiToBean. Please set the field name.");
        }
        IFieldWidget box = BeanUI.getFieldWiget(fieldName, uiObject);
        if (box == null) {
            return;
        }
        if (!box.isActivated()) {
            return;
        }
        Object ob = box.getValue();
        if (!(ob == null || "".equals(ob) || BeanUI.isNaN(ob) || BeanUI.isInfinity(ob))) {
            BeansFactory.setBeanValue((Object)bean, (String)fieldName, (Object)ob);
        } else if (ob != null) {
            Method setter = bean.getClass().getMethod(BeansFactory.getSetterName((String)fieldName), ob.getClass());
            setter.invoke(bean, ob.getClass().cast(null));
        }
    }

    private static boolean isInfinity(Object ob) {
        if (!(ob instanceof Double)) {
            return false;
        }
        return Double.isInfinite((Double)ob);
    }

    private static boolean isNaN(Object ob) {
        if (!(ob instanceof Double)) {
            return false;
        }
        return Double.isNaN((Double)ob);
    }

    public static void addValueListener(Object bean, Object uiObject, final ValueListener listener) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                box.addValueListener(listener);
            }
        });
    }

    public static void removeValueListener(Object bean, Object uiObject, final ValueListener listener) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                box.removeValueListener(listener);
            }
        });
    }

    public static void setBeanFields(final Object bean, Object uiObject) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) throws Exception {
                BeanUI.addBeanField(bean.getClass(), prop.getKey().toString(), box);
            }
        });
    }

    public static void addBeanField(Class<? extends Object> beanClazz, String fieldName, IFieldWidget box) {
        Collection<ValueListener> listeners;
        fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase(Locale.US)) + fieldName.substring(1);
        if (cachedWidgets == null) {
            cachedWidgets = new ConcurrentHashMap<String, IFieldWidget>(89);
        }
        String id = String.valueOf(beanClazz.getName()) + ":" + fieldName;
        cachedWidgets.put(id, box);
        if (waitingListeners != null && (listeners = waitingListeners.get(id)) != null) {
            for (ValueListener valueListener : listeners) {
                box.addValueListener(valueListener);
            }
            waitingListeners.remove(id);
        }
    }

    public static void addBeanFieldValueListener(Class<? extends Object> beanClass, String fieldName, ValueListener listener) {
        IFieldWidget box;
        fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase(Locale.US)) + fieldName.substring(1);
        String id = String.valueOf(beanClass.getName()) + ":" + fieldName;
        IFieldWidget iFieldWidget = box = cachedWidgets != null ? cachedWidgets.get(id) : null;
        if (box == null) {
            Collection<ValueListener> listeners;
            if (waitingListeners == null) {
                waitingListeners = new ConcurrentHashMap<String, Collection<ValueListener>>(31);
            }
            if ((listeners = waitingListeners.get(id)) == null) {
                listeners = new HashSet<ValueListener>(3);
                waitingListeners.put(id, listeners);
            }
            listeners.add(listener);
            return;
        }
        box.addValueListener(listener);
    }

    public static IFieldWidget getBeanField(String fieldName, Class<? extends Object> ... beanClasses) {
        fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase(Locale.US)) + fieldName.substring(1);
        int i = 0;
        while (i < beanClasses.length) {
            IFieldWidget box;
            String id = String.valueOf(beanClasses[i].getName()) + ":" + fieldName;
            IFieldWidget iFieldWidget = box = cachedWidgets != null ? cachedWidgets.get(id) : null;
            if (box != null) {
                return box;
            }
            ++i;
        }
        return null;
    }

    public static void switchState(Object bean, Object uiObject, final boolean on) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) {
                if (on) {
                    box.on();
                } else {
                    box.off();
                }
            }
        });
    }

    public static void switchState(Object uiObject, boolean on) throws Exception {
        Method[] methods = uiObject.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Object ob;
            Method m = methods[i];
            if (m.getReturnType() != null && m.getName().startsWith("get") && (ob = m.invoke(uiObject, new Object[0])) instanceof IFieldWidget) {
                IFieldWidget box = (IFieldWidget)ob;
                if (on) {
                    box.on();
                } else {
                    box.off();
                }
            }
            ++i;
        }
    }

    public static void setEnabled(Object bean, Object uiObject, final boolean isEnabled) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) {
                box.setEnabled(isEnabled);
            }
        });
    }

    public static void dispose(Object bean, Object uiObject) throws Exception {
        BeanUI.notify(bean, uiObject, new BeanProcessor(){

            @Override
            public void process(Map.Entry<Object, Object> prop, IFieldWidget box) {
                box.dispose();
            }
        });
    }

    public static final void notify(Object bean, Object uiObject, BeanProcessor worker) throws Exception {
        BeanMap properties = new BeanMap(bean);
        Iterator it = properties.entryIterator();
        while (it.hasNext()) {
            Map.Entry prop = (Map.Entry)it.next();
            try {
                IFieldWidget box;
                String fieldName = prop.getKey().toString();
                if (fieldName.equals("class") || (box = BeanUI.getFieldWiget(fieldName, uiObject)) == null) continue;
                worker.process(prop, box);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public static IFieldWidget getFieldWiget(String fieldName, Object uiObject) throws Exception {
        String methodName = BeansFactory.getGetterName((String)fieldName);
        Method getter = uiObject.getClass().getMethod(methodName, new Class[0]);
        Object box = getter.invoke(uiObject, new Object[0]);
        if (box instanceof IFieldWidget) {
            return (IFieldWidget)box;
        }
        return null;
    }

    public static List<?> cloneBeans(List<?> beans) throws Exception {
        ArrayList<Object> ret = new ArrayList<Object>(beans.size());
        for (Object bean : beans) {
            ret.add(BeansFactory.deepClone(bean));
        }
        return ret;
    }

    public static List<String> getEditingFields(Object editorBean, Object editorUI) throws Exception {
        Set fields = BeanUtils.describe((Object)editorBean).keySet();
        ArrayList<String> expressionFields = new ArrayList<String>(fields);
        expressionFields.remove("class");
        Iterator it = expressionFields.iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            try {
                IFieldWidget wid = BeanUI.getFieldWiget(field, editorUI);
                if (wid != null) continue;
                it.remove();
            }
            catch (Exception exception) {
                it.remove();
            }
        }
        return expressionFields;
    }

    public static Object getBean(String xml, ClassLoader loader) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        try {
            Object bean;
            Thread.currentThread().setContextClassLoader(loader);
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(stream));
            Object object = bean = d.readObject();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
            stream.close();
        }
    }

    public static String getString(Object bean) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bean.getClass().getClassLoader());
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(stream));
            e.writeObject(bean);
            e.close();
            String string = stream.toString("UTF-8");
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
            stream.close();
        }
    }

    public static interface BeanProcessor {
        public void process(Map.Entry<Object, Object> var1, IFieldWidget var2) throws Exception;
    }
}

