/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.util.io.IPathConstructor;

public class PathUtils {
    private static Logger logger = LoggerFactory.getLogger(PathUtils.class);
    private static IPathConstructor pathConstructor;

    public static String createFromDefaultProperty() {
        try {
            IPathConstructor constructor = PathUtils.getPathConstructor();
            return constructor.getDefaultDataDir();
        }
        catch (Exception ne) {
            logger.error("Cannot get IPathConstructor", (Throwable)ne);
            return null;
        }
    }

    public static String createFromTemplate(String pattern) {
        try {
            IPathConstructor constructor = PathUtils.getPathConstructor();
            return constructor.getFromTemplate(pattern);
        }
        catch (Exception ne) {
            logger.error("Cannot get IPathConstructor", (Throwable)ne);
            return null;
        }
    }

    private static IPathConstructor getPathConstructor() throws CoreException {
        if (pathConstructor != null) {
            return pathConstructor;
        }
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("uk.ac.gda.common.path.constructor");
        pathConstructor = (IPathConstructor)config[0].createExecutableExtension("class");
        return pathConstructor;
    }
}

