/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import uk.ac.gda.util.list.SortNatural;

public class ISortingUtils {
    public static final Comparator<IResource> DEFAULT_COMPARATOR = new Comparator<IResource>(){

        @Override
        public int compare(IResource one, IResource two) {
            return one.getLocation().toString().compareTo(two.getLocation().toString());
        }
    };
    public static final Comparator<IResource> NATURAL_COMPARATOR = new SortNatural(true);

    public static List<IResource> getSortedFileList(IContainer dir, Comparator<IResource> comp) throws CoreException {
        IResource[] fa = dir.members();
        if (fa == null || fa.length < 1) {
            return null;
        }
        ArrayList<IResource> files = new ArrayList<IResource>(fa.length);
        files.addAll(Arrays.asList(fa));
        Collections.sort(files, comp);
        return files;
    }

    public static Collection<IResource> getSortedFileListIgnoreHidden(IContainer dir, Comparator<IResource> comp) throws CoreException {
        IResource[] fa = dir.members();
        if (fa == null || fa.length < 1) {
            return null;
        }
        ArrayList<IResource> files = new ArrayList<IResource>(fa.length);
        int i = 0;
        while (i < fa.length) {
            IResource member = fa[i];
            if (member.exists() && !member.isHidden() && !member.isPhantom() && !member.getLocation().toFile().isHidden() && member.isAccessible()) {
                files.add(member);
            }
            ++i;
        }
        Collections.sort(files, comp);
        return files;
    }

    public static List<IFolder> getSortedFolderList(IContainer dir) throws CoreException {
        IResource[] fa = dir.members();
        if (fa == null || fa.length < 1) {
            return null;
        }
        ArrayList<IFolder> folders = new ArrayList<IFolder>(7);
        int i = 0;
        while (i < fa.length) {
            if (fa[i] instanceof IFolder) {
                folders.add((IFolder)fa[i]);
            }
            ++i;
        }
        Collections.sort(folders, DEFAULT_COMPARATOR);
        return folders;
    }

    public static List<IFile> getSortedFileList(IFolder folder, String ending) throws CoreException {
        IResource[] fa = folder.members();
        if (fa == null || fa.length < 1) {
            return null;
        }
        ArrayList<IFile> files = new ArrayList<IFile>(7);
        int i = 0;
        while (i < fa.length) {
            if (fa[i] instanceof IFile && (ending == null || fa[i].getName().endsWith(ending))) {
                files.add((IFile)fa[i]);
            }
            ++i;
        }
        Collections.sort(files, DEFAULT_COMPARATOR);
        return files;
    }
}

