/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IFileUtils {
    public static StringBuilder readFile(IFile file) throws Exception {
        BufferedReader ir = null;
        try {
            int c;
            ir = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));
            StringBuilder currentStrBuffer = new StringBuilder();
            char[] buf = new char[4096];
            while ((c = ir.read(buf, 0, 4096)) > 0) {
                currentStrBuffer.append(buf, 0, c);
            }
            StringBuilder stringBuilder = currentStrBuffer;
            return stringBuilder;
        }
        finally {
            if (ir != null) {
                ir.close();
            }
        }
    }

    public static List<String> parseFile(IFile file) throws Exception {
        BufferedReader ir = null;
        try {
            String line;
            ir = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));
            ArrayList<String> currentStrBuffer = new ArrayList<String>(89);
            while ((line = ir.readLine()) != null) {
                currentStrBuffer.add(line);
            }
            ArrayList<String> arrayList = currentStrBuffer;
            return arrayList;
        }
        finally {
            if (ir != null) {
                ir.close();
            }
        }
    }

    public static void saveFile(IFile file, List<String> lines) throws Exception {
        BufferedWriter iw = null;
        try {
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            iw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, file.getCharset()));
            for (String line : lines) {
                iw.write(line);
                iw.newLine();
            }
            iw.close();
            file.setContents((InputStream)in, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (iw != null) {
                iw.close();
            }
        }
    }

    public static long getLength(IResource iResource) throws Exception {
        if (!iResource.exists()) {
            return 0L;
        }
        return EFS.getStore((URI)iResource.getLocationURI()).fetchInfo().getLength();
    }

    public static long getLastModified(IResource iResource) throws Exception {
        if (!iResource.exists()) {
            return 0L;
        }
        if (iResource instanceof IFile) {
            ((IFile)iResource).getLocalTimeStamp();
        }
        return EFS.getStore((URI)iResource.getLocationURI()).fetchInfo().getLastModified();
    }

    public static void createLinks(IFolder src, Path path, IProgressMonitor monitor) throws CoreException {
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        File parent = path.toFile();
        File[] fa = parent.listFiles();
        int i = 0;
        while (i < fa.length) {
            File file = fa[i];
            if (!file.isHidden() && file.isDirectory()) {
                Path child = new Path(file.getAbsolutePath());
                IFolder folder = src.getFolder(child.lastSegment());
                if (child.isPrefixOf(workspacePath)) {
                    folder.create(false, true, monitor);
                    IFileUtils.createLinks(folder, child, monitor);
                } else {
                    folder.createLink((IPath)child, 2, monitor);
                }
            }
            ++i;
        }
    }
}

