/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GridUtils {
    private static int depthCount = 0;
    private static Set<Control> controlsToLayout = new HashSet<Control>();
    private static Stack<Control> controlsToRedraw = new Stack();

    public static void startMultiLayout(Control parent) {
        if (parent != null) {
            parent.setRedraw(false);
        }
        controlsToRedraw.push(parent);
        ++depthCount;
    }

    public static void endMultiLayout() {
        Control parent;
        if (--depthCount == 0 && controlsToLayout.size() > 0) {
            Control[] controls = controlsToLayout.toArray(new Control[controlsToLayout.size()]);
            controls[0].getShell().layout(controls);
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setRedraw(true);
                ++n2;
            }
            controlsToLayout.clear();
        }
        if ((parent = controlsToRedraw.pop()) != null) {
            parent.setRedraw(true);
        }
    }

    public static void setVisibleAndLayout(Control widget, boolean isVisible) {
        if (widget == null) {
            return;
        }
        if (!(widget.getLayoutData() instanceof GridData)) {
            throw new IllegalArgumentException("Widget must have GridData layout data applied");
        }
        GridData data = (GridData)widget.getLayoutData();
        if (data.exclude != !isVisible || widget.getVisible() != isVisible) {
            boolean bl = data.exclude = !isVisible;
            if (depthCount == 0) {
                widget.setVisible(isVisible);
                try {
                    widget.getShell().layout(new Control[]{widget});
                }
                catch (Exception exception) {}
            } else {
                if (!controlsToLayout.contains(widget)) {
                    widget.setRedraw(false);
                }
                widget.setVisible(isVisible);
                controlsToLayout.add(widget);
            }
        }
    }

    public static void setVisible(Control widget, boolean isVisible) {
        if (widget == null) {
            return;
        }
        if (widget.getLayoutData() instanceof GridData) {
            GridData data = (GridData)widget.getLayoutData();
            data.exclude = !isVisible;
        }
        widget.setVisible(isVisible);
    }

    public static void layout(Composite control) {
        if (depthCount == 0) {
            control.layout();
        } else {
            controlsToLayout.add((Control)control);
            controlsToLayout.addAll(Arrays.asList(control.getChildren()));
        }
    }

    public static void layoutFull(Composite control) {
        if (depthCount == 0) {
            try {
                control.setRedraw(false);
                control.getShell().layout(new Control[]{control});
                control.layout();
            }
            finally {
                control.setRedraw(true);
            }
        } else {
            controlsToLayout.add((Control)control);
            controlsToLayout.addAll(Arrays.asList(control.getChildren()));
        }
    }

    public static void removeMargins(Composite area) {
        GridLayout layout = (GridLayout)area.getLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    }
}

