/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import uk.ac.gda.util.beans.xml.URLResolver;

public class EclipseUtils {
    private static URLResolver resolver;
    private static final Pattern UNIQUE_PATTERN;

    static {
        UNIQUE_PATTERN = Pattern.compile("(.+)(\\d+)", 2);
    }

    public static URI getFileURI(IEditorInput fileInput) {
        if (fileInput instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)fileInput).getURI();
            return uri;
        }
        return null;
    }

    public static File getFile(IEditorInput fileInput) {
        URI uri = EclipseUtils.getFileURI(fileInput);
        return uri == null ? null : new File(uri);
    }

    public static String getFilePath(IEditorInput fileInput) {
        File f = EclipseUtils.getFile(fileInput);
        return f == null || !f.exists() ? null : f.getPath();
    }

    public static IFile getIFile(IEditorInput input) {
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return (IFile)input.getAdapter(IFile.class);
    }

    public static String getFileName(IEditorInput input) {
        File f = EclipseUtils.getFile(input);
        return f == null || !f.exists() ? null : f.getName();
    }

    public static URL getAbsoluteUrl(URL bundleUrl) {
        if (bundleUrl == null) {
            return null;
        }
        if (bundleUrl.toString().startsWith("bundle")) {
            try {
                return FileLocator.resolve((URL)bundleUrl);
            }
            catch (IOException iOException) {
                return bundleUrl;
            }
        }
        return bundleUrl;
    }

    public static IWorkbenchPage getPage() {
        IWorkbenchPage activePage = EclipseUtils.getActivePage();
        if (activePage != null) {
            return activePage;
        }
        return EclipseUtils.getDefaultPage();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench == null) {
            return null;
        }
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = EclipseUtils.getPage();
        return page.getActiveEditor();
    }

    public static IWorkbenchPage getDefaultPage() {
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench == null) {
            return null;
        }
        IWorkbenchWindow[] windows = bench.getWorkbenchWindows();
        if (windows == null) {
            return null;
        }
        return windows[0].getActivePage();
    }

    public static URLResolver getUrlResolver() {
        if (resolver == null) {
            resolver = new URLResolver(){

                public URL resolve(URL url) {
                    return EclipseUtils.getAbsoluteUrl(url);
                }
            };
        }
        return resolver;
    }

    public static void addBuilderToProject(IProject project, String id, IProgressMonitor monitor) throws CoreException {
        ICommand[] cmds;
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription des = project.getDescription();
        ICommand[] iCommandArray = cmds = des.getBuildSpec();
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (cmd.getBuilderName().equals(id)) {
                return;
            }
            ++n2;
        }
        ICommand com = des.newCommand();
        com.setBuilderName(id);
        ArrayList<ICommand> coms = new ArrayList<ICommand>(cmds.length + 1);
        coms.addAll(Arrays.asList(cmds));
        coms.add(com);
        des.setBuildSpec(coms.toArray(new ICommand[0]));
        project.setDescription(des, monitor);
    }

    public static void removeBuilderFromProject(IProject project, String id, IProgressMonitor monitor) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription des = project.getDescription();
        ICommand[] cmds = des.getBuildSpec();
        Vector<ICommand> newCmds = new Vector<ICommand>();
        ICommand[] iCommandArray = cmds;
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (!cmd.getBuilderName().equals(id)) {
                newCmds.add(cmd);
            }
            ++n2;
        }
        des.setBuildSpec(newCmds.toArray(new ICommand[0]));
        project.setDescription(des, monitor);
    }

    public static boolean isActivePerspective(String id) {
        IWorkbenchPage page = EclipseUtils.getActivePage();
        if (page == null) {
            return false;
        }
        try {
            return id.equals(page.getPerspective().getId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void delay(long waitTimeMillis) {
        EclipseUtils.delay(waitTimeMillis, false);
    }

    public static void delay(long waitTimeMillis, boolean returnInsteadOfSleep) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                try {
                    if (display.readAndDispatch()) continue;
                    if (returnInsteadOfSleep) break;
                    display.sleep();
                }
                catch (Exception exception) {
                    try {
                        if (returnInsteadOfSleep) break;
                        Thread.sleep(waitTimeMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
            }
            display.update();
        } else {
            try {
                if (!returnInsteadOfSleep) {
                    Thread.sleep(waitTimeMillis);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void threadJoin(Thread thread, long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis && thread.isAlive()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                thread.join(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static IFile getUniqueFile(IFile file, String extension) {
        return EclipseUtils.getUniqueFile(file, null, extension);
    }

    public static IFile getUniqueFile(IFile file, String conjunctive, String extension) {
        IContainer parent;
        IFile newFile;
        String name = file.getName();
        Matcher matcher = Pattern.compile("(.+)(\\d+)\\." + extension, 2).matcher(name);
        int start = 0;
        String frag = name.substring(0, name.lastIndexOf("."));
        if (matcher.matches()) {
            frag = matcher.group(1);
            start = Integer.parseInt(matcher.group(2));
        }
        if (conjunctive != null) {
            frag = String.valueOf(frag) + conjunctive;
        }
        if ((newFile = (parent = file.getParent()) instanceof IFolder ? ((IFolder)parent).getFile(String.valueOf(frag) + "." + extension) : (parent instanceof IProject ? ((IProject)parent).getFile(String.valueOf(frag) + "." + extension) : null)) != null && !newFile.exists()) {
            return newFile;
        }
        return EclipseUtils.getUniqueFile(parent, frag, ++start, extension);
    }

    public static IFile getUniqueFile(IContainer parent, String filename, String extension) {
        Matcher matcher = Pattern.compile("(.+)(\\d+)\\." + extension, 2).matcher(filename);
        int start = 0;
        String frag = filename.substring(0, filename.lastIndexOf("."));
        if (matcher.matches()) {
            frag = matcher.group(1);
            start = Integer.parseInt(matcher.group(2));
        }
        return EclipseUtils.getUniqueFile(parent, frag, start, extension);
    }

    private static IFile getUniqueFile(IContainer parent, String frag, int start, String extension) {
        IFile file;
        if (parent instanceof IFolder) {
            file = ((IFolder)parent).getFile(String.valueOf(frag) + start + "." + extension);
        } else if (parent instanceof IProject) {
            file = ((IProject)parent).getFile(String.valueOf(frag) + start + "." + extension);
        } else {
            throw new RuntimeException("The parent is neither a project nor a folder.");
        }
        if (!file.exists()) {
            return file;
        }
        return EclipseUtils.getUniqueFile(parent, frag, ++start, extension);
    }

    public static String getUnique(IResource res) {
        String frag;
        String name = res.getName();
        Matcher matcher = UNIQUE_PATTERN.matcher(name);
        int start = 0;
        String string = frag = name.indexOf(".") > -1 ? name.substring(0, name.lastIndexOf(".")) : name;
        if (matcher.matches()) {
            frag = matcher.group(1);
            start = Integer.parseInt(matcher.group(2));
        }
        return EclipseUtils.getUnique(res.getParent(), frag, ++start);
    }

    private static String getUnique(IContainer parent, String frag, int start) {
        IFolder folder;
        IFile file;
        if (parent instanceof IFolder) {
            file = ((IFolder)parent).getFile(String.valueOf(frag) + start);
            folder = ((IFolder)parent).getFolder(String.valueOf(frag) + start);
        } else if (parent instanceof IProject) {
            file = ((IProject)parent).getFile(String.valueOf(frag) + start);
            folder = ((IProject)parent).getFolder(String.valueOf(frag) + start);
        } else {
            throw new RuntimeException("The parent is niether a project nor a folder.");
        }
        if (!file.exists() && !folder.exists()) {
            return file.getName();
        }
        return EclipseUtils.getUnique(parent, frag, ++start);
    }

    public static Object getAdapter(Object sourceObject, Class<?> adapterType) {
        Assert.isNotNull(adapterType);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        return ResourceUtil.getAdapter((Object)sourceObject, adapterType, (boolean)true);
    }

    public static IEditorPart openEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = EclipseUtils.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (desc == null) {
            desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(file.getName()) + ".txt");
        }
        return page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
    }

    public static IEditorPart openExternalEditor(String filename) throws PartInitException {
        IWorkbenchPage page = EclipseUtils.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(filename);
        if (desc == null) {
            desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(filename) + ".txt");
        }
        IFileStore externalFile = EFS.getLocalFileSystem().fromLocalFile(new File(filename));
        return page.openEditor((IEditorInput)new FileStoreEditorInput(externalFile), desc.getId());
    }

    public static IProject getActiveProject() {
        IEditorInput input;
        IWorkbenchPage page = EclipseUtils.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor != null && (input = activeEditor.getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile().getProject();
        }
        ISelectionService service = page.getWorkbenchWindow().getSelectionService();
        ISelection sel = service.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)sel;
        Object element = ss.getFirstElement();
        if (element instanceof IResource) {
            return ((IResource)element).getProject();
        }
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)element;
        Object adapter = adaptable.getAdapter(IResource.class);
        return ((IResource)adapter).getProject();
    }

    public static void activateView(String ID) {
        IViewReference[] viewReferences;
        IViewReference[] iViewReferenceArray = viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            if (view.getId().equals(ID)) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(view.getView(true).getViewSite().getPart());
                break;
            }
            ++n2;
        }
    }

    public static void setBusy(final boolean isBusy) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Cursor cursor = display.getSystemCursor(1);
                Shell[] shells = display.getShells();
                int i = 0;
                while (i < shells.length) {
                    if (isBusy) {
                        shells[i].setCursor(cursor);
                    } else {
                        shells[i].setCursor(null);
                    }
                    ++i;
                }
            }
        });
    }
}

