/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleUtils {
    public static File getBundleLocation(String bundleName) throws IOException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        return BundleUtils.getBundleLocation(bundle);
    }

    public static File getBundleLocation(Bundle bundle) throws IOException {
        String dirPath = BundleUtils.cleanPath(bundle.getLocation());
        File dir = new File(dirPath);
        if (dir.exists()) {
            return dir;
        }
        String eclipseDir = BundleUtils.cleanPath(System.getProperty("eclipse.home.location"));
        File bundDir = new File(String.valueOf(eclipseDir) + "/" + dirPath);
        if (bundDir.exists()) {
            return bundDir;
        }
        File plugins = new File(String.valueOf(eclipseDir) + "/plugins/");
        if (plugins.exists()) {
            File[] fa = plugins.listFiles();
            int i = 0;
            while (i < fa.length) {
                File file = fa[i];
                if (file.getName().equals(bundle.getSymbolicName())) {
                    return file;
                }
                if (file.getName().startsWith(String.valueOf(bundle.getSymbolicName()) + "_")) {
                    return file;
                }
                ++i;
            }
        }
        throw new IOException("Cannot locate bundle " + bundle.getSymbolicName());
    }

    private static String cleanPath(String loc) {
        if (loc.startsWith("reference:file:")) {
            loc = loc.substring(15);
        } else if (loc.startsWith("file:")) {
            loc = loc.substring(5);
        } else {
            return loc;
        }
        loc = loc.replace("//", "/");
        loc = loc.replace("\\\\", "\\");
        return loc;
    }

    public static File getBundlePathNoLoading(String bundleName) {
        String home = System.getProperty("eclipse.home.location");
        if (home.startsWith("file:")) {
            home = home.substring("file:".length());
        }
        String path = home.endsWith("/plugins/") ? new File(home).getParentFile().getParentFile().getAbsolutePath() : home;
        return new File(String.valueOf(path) + "/plugins/" + bundleName);
    }
}

