/*
 * Decompiled with CFR 0.152.
 */
package swing2swt.layout;

import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swing2swt.layout.AWTLayout;

public class FlowLayout
extends AWTLayout {
    public static final int CENTER = 1;
    public static final int LEADING = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int TRAILING = 5;
    private int hgap;
    private int vgap;
    private int align;
    private Vector<Control> currentLine = new Vector();

    public FlowLayout() {
        this(1);
    }

    public FlowLayout(int align) {
        this(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        this.setAlignment(align);
        this.hgap = hgap;
        this.vgap = vgap;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = new Point(0, 0);
        Control[] children = composite.getChildren();
        int nb = 0;
        int i = 0;
        while (i < children.length) {
            Point childSize = this.getPreferredSize(children[i], wHint, hHint, flushCache);
            size.x += childSize.x;
            size.y = Math.max(childSize.y, size.y);
            ++nb;
            ++i;
        }
        if (nb > 0) {
            size.x += (nb + 1) * this.hgap;
            size.y += this.vgap;
        }
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        Control[] children = composite.getChildren();
        int x = clientArea.x + this.hgap;
        int y = clientArea.y + this.vgap;
        int lineWidth = this.hgap;
        int lineHeight = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (children[i].isVisible()) {
                Point childSize = this.getPreferredSize(child, -1, -1, flushCache);
                if (lineWidth + childSize.x > clientArea.width && this.currentLine.size() > 0) {
                    this.alignCurrentLine(clientArea, lineWidth, lineHeight);
                    this.currentLine.clear();
                    x = clientArea.x + this.hgap;
                    y += lineHeight + this.vgap;
                    lineHeight = this.hgap;
                    lineWidth = 0;
                }
                child.setBounds(x, y, childSize.x, childSize.y);
                this.currentLine.add(child);
                lineWidth += childSize.x + this.hgap;
                lineHeight = Math.max(lineHeight, childSize.y);
                x += childSize.x + this.hgap;
            }
            ++i;
        }
        this.alignCurrentLine(clientArea, lineWidth, lineHeight);
        this.currentLine.clear();
    }

    private void alignCurrentLine(Rectangle clientArea, int lineWidth, int lineHeight) {
        int j = 0;
        while (j < this.currentLine.size()) {
            Control c = this.currentLine.get(j);
            Rectangle bounds = c.getBounds();
            int x = bounds.x;
            if (this.align == 1) {
                x += (clientArea.width - lineWidth) / 2;
            } else if (this.align == 4) {
                x += clientArea.width - lineWidth;
            }
            int y = bounds.y + (lineHeight - bounds.height) / 2;
            c.setLocation(x, y);
            ++j;
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        if (align == 2 || align == 5) {
            ComponentOrientation orientation = ComponentOrientation.getOrientation(Locale.getDefault());
            align = align == 2 ? (orientation.isLeftToRight() ? 3 : 4) : (orientation.isLeftToRight() ? 4 : 3);
        }
        this.align = align;
    }
}

