/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ResourceManager
extends SWTResourceManager {
    private static HashMap<ImageDescriptor, Image> m_DescriptorImageMap = new HashMap();
    private static HashMap<Image, HashMap<Image, Image>> m_ImageToDecoratorMap = new HashMap();
    private static HashMap<URL, Image> m_URLImageMap = new HashMap();

    public static void dispose() {
        ResourceManager.disposeColors();
        ResourceManager.disposeFonts();
        ResourceManager.disposeImages();
        ResourceManager.disposeCursors();
    }

    public static ImageDescriptor getImageDescriptor(Class<?> clazz, String path) {
        return ImageDescriptor.createFromFile(clazz, (String)path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new File(path).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = m_DescriptorImageMap.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            m_DescriptorImageMap.put(descriptor, image);
        }
        return image;
    }

    public static Image decorateImage(final Image baseImage, final Image decorator, final int corner) {
        Image result;
        HashMap<Object, Object> decoratedMap = m_ImageToDecoratorMap.get(baseImage);
        if (decoratedMap == null) {
            decoratedMap = new HashMap();
            m_ImageToDecoratorMap.put(baseImage, decoratedMap);
        }
        if ((result = decoratedMap.get(decorator)) == null) {
            final Rectangle bid = baseImage.getBounds();
            final Rectangle did = decorator.getBounds();
            final Point baseImageSize = new Point(bid.width, bid.height);
            CompositeImageDescriptor compositImageDesc = new CompositeImageDescriptor(){

                protected void drawCompositeImage(int width, int height) {
                    this.drawImage(baseImage.getImageData(), 0, 0);
                    if (corner == 1) {
                        this.drawImage(decorator.getImageData(), 0, 0);
                    } else if (corner == 2) {
                        this.drawImage(decorator.getImageData(), bid.width - did.width - 1, 0);
                    } else if (corner == 3) {
                        this.drawImage(decorator.getImageData(), 0, bid.height - did.height - 1);
                    } else if (corner == 4) {
                        this.drawImage(decorator.getImageData(), bid.width - did.width - 1, bid.height - did.height - 1);
                    }
                }

                protected Point getSize() {
                    return baseImageSize;
                }
            };
            result = compositImageDesc.createImage();
            decoratedMap.put(decorator, result);
        }
        return result;
    }

    public static void disposeImages() {
        SWTResourceManager.disposeImages();
        Iterator<Object> I = m_DescriptorImageMap.values().iterator();
        while (I.hasNext()) {
            I.next().dispose();
        }
        m_DescriptorImageMap.clear();
        I = m_URLImageMap.values().iterator();
        while (I.hasNext()) {
            I.next().dispose();
        }
        m_URLImageMap.clear();
        for (HashMap hashMap : m_ImageToDecoratorMap.values()) {
            for (Image decoratedImage : hashMap.values()) {
                decoratedImage.dispose();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static Image getPluginImage(Object plugin, String name) {
        try {
            Image image;
            URL url;
            block8: {
                url = ResourceManager.getPluginImageURL(plugin, name);
                if (!m_URLImageMap.containsKey(url)) break block8;
                return m_URLImageMap.get(url);
            }
            InputStream is = url.openStream();
            try {
                image = ResourceManager.getImage(is);
                m_URLImageMap.put(url, image);
            }
            finally {
                is.close();
            }
            return image;
        }
        catch (Throwable throwable) {
            {
                catch (Throwable throwable2) {}
            }
        }
        return null;
    }

    public static ImageDescriptor getPluginImageDescriptor(Object plugin, String name) {
        try {
            URL url = ResourceManager.getPluginImageURL(plugin, name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (Throwable throwable) {
            try {
            }
            catch (Throwable throwable2) {}
            return null;
        }
    }

    private static URL getPluginImageURL(Object plugin, String name) throws Exception {
        try {
            Class<?> bundleClass = Class.forName("org.osgi.framework.Bundle");
            Class<?> bundleContextClass = Class.forName("org.osgi.framework.BundleContext");
            if (bundleContextClass.isAssignableFrom(plugin.getClass())) {
                Method getBundleMethod = bundleContextClass.getMethod("getBundle", new Class[0]);
                Object bundle = getBundleMethod.invoke(plugin, new Object[0]);
                Class<?> ipathClass = Class.forName("org.eclipse.core.runtime.IPath");
                Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
                Constructor<?> pathConstructor = pathClass.getConstructor(String.class);
                Object path = pathConstructor.newInstance(name);
                Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
                Method findMethod = platformClass.getMethod("find", bundleClass, ipathClass);
                return (URL)findMethod.invoke(null, bundle, path);
            }
        }
        catch (Throwable throwable) {}
        Class<?> pluginClass = Class.forName("org.eclipse.core.runtime.Plugin");
        if (pluginClass.isAssignableFrom(plugin.getClass())) {
            Class<?> ipathClass = Class.forName("org.eclipse.core.runtime.IPath");
            Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
            Constructor<?> pathConstructor = pathClass.getConstructor(String.class);
            Object path = pathConstructor.newInstance(name);
            Method findMethod = pluginClass.getMethod("find", ipathClass);
            return (URL)findMethod.invoke(plugin, path);
        }
        return null;
    }
}

