/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.projection.AbstractStructuredFoldingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.reconcile.DirtyRegionProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorBuilder;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorStrategy;
import org.eclipse.wst.sse.ui.internal.spelling.SpellcheckStrategy;
import org.eclipse.wst.sse.ui.reconcile.ISourceReconcilingListener;

public class DocumentRegionProcessor
extends DirtyRegionProcessor {
    private static final boolean DEBUG_VALIDATORS = Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerValidators"));
    private IReconcilingStrategy fSpellcheckStrategy;
    private ValidatorStrategy fValidatorStrategy;
    private ISourceReconcilingListener[] fReconcileListeners = new ISourceReconcilingListener[0];
    private IReconcilingStrategy fSemanticHighlightingStrategy;
    private AbstractStructuredFoldingStrategy fFoldingStrategy;
    private final String SSE_UI_ID = "org.eclipse.wst.sse.ui";
    private boolean fValidationEnabled;

    public void addReconcilingListener(ISourceReconcilingListener listener) {
        HashSet<ISourceReconcilingListener> listeners = new HashSet<ISourceReconcilingListener>(Arrays.asList(this.fReconcileListeners));
        listeners.add(listener);
        this.fReconcileListeners = listeners.toArray(new ISourceReconcilingListener[listeners.size()]);
    }

    protected void beginProcessing() {
        super.beginProcessing();
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (validatorStrategy != null) {
            validatorStrategy.beginProcessing();
        }
        if (this.getTextViewer() instanceof ISourceViewer) {
            int i = 0;
            while (i < this.fReconcileListeners.length) {
                this.fReconcileListeners[i].aboutToBeReconciled();
                ++i;
            }
        }
    }

    protected void endProcessing() {
        IReconcilingStrategy semanticHighlightingStrategy;
        super.endProcessing();
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (validatorStrategy != null) {
            validatorStrategy.endProcessing();
        }
        IReconcilingStrategy spellingStrategy = this.getSpellcheckStrategy();
        IDocument document = this.getDocument();
        if (spellingStrategy != null && document != null) {
            spellingStrategy.reconcile((IRegion)new Region(0, document.getLength()));
        }
        if ((semanticHighlightingStrategy = this.getSemanticHighlightingStrategy()) != null && document != null) {
            semanticHighlightingStrategy.reconcile((IRegion)new Region(0, document.getLength()));
        }
        if (this.getTextViewer() instanceof ISourceViewer) {
            ISourceViewer sourceViewer = (ISourceViewer)this.getTextViewer();
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            int i = 0;
            while (i < this.fReconcileListeners.length) {
                this.fReconcileListeners[i].reconciled(document, annotationModel, false, (IProgressMonitor)new NullProgressMonitor());
                ++i;
            }
        }
    }

    public void forceReconciling() {
        super.forceReconciling();
    }

    protected String getContentType(IDocument doc) {
        if (doc == null) {
            return null;
        }
        String contentTypeId = null;
        IContentType ct = null;
        try {
            IContentDescription desc = Platform.getContentTypeManager().getDescriptionFor((Reader)new StringReader(doc.get()), null, IContentDescription.ALL);
            if (desc != null && (ct = desc.getContentType()) != null) {
                contentTypeId = ct.getId();
            }
        }
        catch (IOException iOException) {}
        return contentTypeId;
    }

    protected IReconcilingStrategy getSpellcheckStrategy() {
        if (this.fSpellcheckStrategy == null && this.getDocument() != null) {
            String contentTypeId = this.getContentType(this.getDocument());
            if (contentTypeId == null) {
                contentTypeId = "org.eclipse.core.runtime.text";
            }
            if (this.getTextViewer() instanceof ISourceViewer) {
                ISourceViewer viewer = (ISourceViewer)this.getTextViewer();
                this.fSpellcheckStrategy = new SpellcheckStrategy(viewer, contentTypeId);
                this.fSpellcheckStrategy.setDocument(this.getDocument());
            }
        }
        return this.fSpellcheckStrategy;
    }

    protected IReconcilingStrategy getFoldingStrategy() {
        if (this.fFoldingStrategy == null && this.getDocument() != null) {
            ITextViewer viewer;
            String contentTypeId = this.getContentType(this.getDocument());
            if (contentTypeId == null) {
                contentTypeId = "org.eclipse.core.runtime.text";
            }
            if ((viewer = this.getTextViewer()) instanceof ProjectionViewer) {
                ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
                IContentType type = Platform.getContentTypeManager().getContentType(contentTypeId);
                while (this.fFoldingStrategy == null && type != null) {
                    this.fFoldingStrategy = (AbstractStructuredFoldingStrategy)builder.getConfiguration("foldingstrategy", type.getId());
                    type = type.getBaseType();
                }
                if (this.fFoldingStrategy != null) {
                    this.fFoldingStrategy.setViewer((ProjectionViewer)viewer);
                    this.fFoldingStrategy.setDocument(this.getDocument());
                }
            }
        }
        return this.fFoldingStrategy;
    }

    public void setValidatorStrategyEnabled(boolean enable) {
        this.fValidationEnabled = enable;
    }

    protected ValidatorStrategy getValidatorStrategy() {
        ValidatorStrategy validatorStrategy = null;
        if (this.fValidatorStrategy == null && this.fValidationEnabled) {
            if (this.getTextViewer() instanceof ISourceViewer) {
                ISourceViewer viewer = (ISourceViewer)this.getTextViewer();
                String contentTypeId = null;
                IDocument doc = viewer.getDocument();
                contentTypeId = this.getContentType(doc);
                if (contentTypeId != null) {
                    validatorStrategy = new ValidatorStrategy(viewer, contentTypeId);
                    ValidatorBuilder vBuilder = new ValidatorBuilder();
                    ValidatorMetaData[] vmds = vBuilder.getValidatorMetaData("org.eclipse.wst.sse.ui");
                    ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>(1);
                    boolean foundSpecificContentTypeValidators = false;
                    int i = 0;
                    while (i < vmds.length) {
                        if (vmds[i].mustHandleContentType(contentTypeId)) {
                            if (DEBUG_VALIDATORS) {
                                Logger.log(1, String.valueOf(contentTypeId) + " using specific validator " + vmds[i].getValidatorId());
                            }
                            foundSpecificContentTypeValidators = true;
                            enabledValidators.add(vmds[i]);
                        }
                        ++i;
                    }
                    if (!foundSpecificContentTypeValidators) {
                        i = 0;
                        while (i < vmds.length) {
                            if (vmds[i].canHandleContentType(contentTypeId)) {
                                if (DEBUG_VALIDATORS) {
                                    Logger.log(1, String.valueOf(contentTypeId) + " using inherited(?) validator " + vmds[i].getValidatorId());
                                }
                                enabledValidators.add(vmds[i]);
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < enabledValidators.size()) {
                        validatorStrategy.addValidatorMetaData((ValidatorMetaData)enabledValidators.get(i));
                        ++i;
                    }
                }
            }
            this.fValidatorStrategy = validatorStrategy;
        } else if (this.fValidatorStrategy != null && this.fValidationEnabled) {
            validatorStrategy = this.fValidatorStrategy;
        }
        return validatorStrategy;
    }

    public void setSemanticHighlightingStrategy(IReconcilingStrategy semanticHighlightingStrategy) {
        this.fSemanticHighlightingStrategy = semanticHighlightingStrategy;
        this.fSemanticHighlightingStrategy.setDocument(this.getDocument());
    }

    protected IReconcilingStrategy getSemanticHighlightingStrategy() {
        return this.fSemanticHighlightingStrategy;
    }

    protected void process(DirtyRegion dirtyRegion) {
        if (!this.isInstalled() || this.isInRewriteSession() || dirtyRegion == null || this.getDocument() == null) {
            return;
        }
        super.process(dirtyRegion);
        ITypedRegion[] partitions = this.computePartitioning(dirtyRegion);
        DirtyRegion dirty = null;
        int i = 0;
        while (i < partitions.length) {
            dirty = this.createDirtyRegion(partitions[i], "__insert");
            if (this.getValidatorStrategy() != null) {
                this.getValidatorStrategy().reconcile(partitions[i], dirty);
            }
            ++i;
        }
        if (this.getFoldingStrategy() != null) {
            this.getFoldingStrategy().reconcile(dirtyRegion, null);
        }
    }

    public void removeReconcilingListener(ISourceReconcilingListener listener) {
        HashSet<ISourceReconcilingListener> listeners = new HashSet<ISourceReconcilingListener>(Arrays.asList(this.fReconcileListeners));
        listeners.remove(listener);
        this.fReconcileListeners = listeners.toArray(new ISourceReconcilingListener[listeners.size()]);
    }

    public void setDocument(IDocument doc) {
        super.setDocument(doc);
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (validatorStrategy != null) {
            validatorStrategy.setDocument(doc);
        }
        if (this.fSemanticHighlightingStrategy != null) {
            this.fSemanticHighlightingStrategy.setDocument(doc);
        }
        this.fSpellcheckStrategy = null;
        if (this.fFoldingStrategy != null) {
            this.fFoldingStrategy.uninstall();
        }
        this.fFoldingStrategy = null;
    }

    protected void setEntireDocumentDirty(IDocument document) {
        super.setEntireDocumentDirty(document);
        if (document != null && this.isInstalled() && this.fLastPartitions != null && document.getLength() == 0) {
            int i = 0;
            while (i < this.fLastPartitions.length) {
                ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
                if (validatorStrategy != null) {
                    validatorStrategy.reconcile(this.fLastPartitions[i], this.createDirtyRegion(this.fLastPartitions[i], "__remove"));
                }
                ++i;
            }
            IReconcilingStrategy spellingStrategy = this.getSpellcheckStrategy();
            if (spellingStrategy != null) {
                spellingStrategy.reconcile((IRegion)new Region(0, document.getLength()));
            }
            if (this.getFoldingStrategy() != null) {
                this.getFoldingStrategy().reconcile((IRegion)new Region(0, document.getLength()));
            }
        }
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fValidationEnabled = SSEUIPlugin.getInstance().getPreferenceStore().getBoolean(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
    }

    public void uninstall() {
        if (this.isInstalled()) {
            ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
            if (validatorStrategy != null && validatorStrategy instanceof IReleasable) {
                ((IReleasable)validatorStrategy).release();
            }
            if (this.fSpellcheckStrategy != null) {
                this.fSpellcheckStrategy.setDocument(null);
                this.fSpellcheckStrategy = null;
            }
            this.fReconcileListeners = new ISourceReconcilingListener[0];
        }
        super.uninstall();
    }
}

