/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.persistence;

import java.util.Properties;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorPersistor {
    public static final String STYLE_PERSISTENCE_PREFIX = "color";
    public static final Color DEFAULT_COLOR = Display.getDefault().getSystemColor(1);

    public static void saveColor(String prefix, Properties properties, Color color) {
        prefix = String.valueOf(prefix) + "." + STYLE_PERSISTENCE_PREFIX;
        if (color == null) {
            return;
        }
        properties.setProperty(prefix, ColorPersistor.asString(color));
    }

    public static Color loadColor(String prefix, Properties properties) {
        String colorAsString = properties.getProperty(prefix = String.valueOf(prefix) + "." + STYLE_PERSISTENCE_PREFIX);
        if (colorAsString == null) {
            return DEFAULT_COLOR;
        }
        return ColorPersistor.asColor(colorAsString);
    }

    public static String asString(Color color) {
        return StringConverter.asString((RGB)color.getRGB());
    }

    public static Color asColor(String colorAsString) {
        try {
            return GUIHelper.getColor(StringConverter.asRGB((String)colorAsString));
        }
        catch (DataFormatException dataFormatException) {
            return DEFAULT_COLOR;
        }
    }
}

