/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.group.ColumnGroupHeaderLayer;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupUtils;
import net.sourceforge.nattable.group.command.CreateColumnGroupCommand;
import net.sourceforge.nattable.group.command.IColumnGroupCommand;
import net.sourceforge.nattable.group.command.OpenCreateColumnGroupDialog;
import net.sourceforge.nattable.group.command.ReorderColumnGroupCommand;
import net.sourceforge.nattable.group.command.UngroupColumnCommand;
import net.sourceforge.nattable.group.event.GroupColumnsEvent;
import net.sourceforge.nattable.group.event.UngroupColumnsEvent;
import net.sourceforge.nattable.reorder.command.MultiColumnReorderCommand;
import net.sourceforge.nattable.selection.SelectionLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroupsCommandHandler
extends AbstractLayerCommandHandler<IColumnGroupCommand> {
    private final ColumnGroupModel model;
    private final SelectionLayer selectionLayer;
    private final ColumnGroupHeaderLayer contextLayer;
    private Map<Integer, Integer> columnIndexesToPositionsMap;

    public ColumnGroupsCommandHandler(ColumnGroupModel model, SelectionLayer selectionLayer, ColumnGroupHeaderLayer contextLayer) {
        this.model = model;
        this.selectionLayer = selectionLayer;
        this.contextLayer = contextLayer;
    }

    @Override
    public boolean doCommand(IColumnGroupCommand command) {
        if (command instanceof CreateColumnGroupCommand) {
            if (this.columnIndexesToPositionsMap.size() > 0) {
                this.handleGroupColumnsCommand(((CreateColumnGroupCommand)command).getColumnGroupName());
                this.columnIndexesToPositionsMap.clear();
                return true;
            }
        } else {
            if (command instanceof OpenCreateColumnGroupDialog) {
                OpenCreateColumnGroupDialog openDialogCommand = (OpenCreateColumnGroupDialog)command;
                this.loadSelectedColumnsIndexesWithPositions();
                if (this.selectionLayer.getFullySelectedColumnPositions().length > 0 && this.columnIndexesToPositionsMap.size() > 0) {
                    openDialogCommand.openDialog(this.contextLayer);
                } else {
                    openDialogCommand.openErrorBox("Please select non-grouped columns prior to creating a group.");
                }
                return true;
            }
            if (command instanceof UngroupColumnCommand) {
                this.handleUngroupCommand();
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<IColumnGroupCommand> getCommandClass() {
        return IColumnGroupCommand.class;
    }

    protected void loadSelectedColumnsIndexesWithPositions() {
        this.columnIndexesToPositionsMap = new LinkedHashMap<Integer, Integer>();
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        if (fullySelectedColumns.length > 0) {
            int index = 0;
            while (index < fullySelectedColumns.length) {
                int columnPosition = fullySelectedColumns[index];
                int columnIndex = this.selectionLayer.getColumnIndexByPosition(columnPosition);
                if (this.model.isPartOfAGroup(columnIndex)) {
                    this.columnIndexesToPositionsMap.clear();
                    break;
                }
                this.columnIndexesToPositionsMap.put(columnIndex, columnPosition);
                ++index;
            }
        }
    }

    public void handleGroupColumnsCommand(String columnGroupName) {
        try {
            ArrayList<Integer> selectedPositions = new ArrayList<Integer>();
            int[] fullySelectedColumns = new int[this.columnIndexesToPositionsMap.size()];
            int count = 0;
            for (Integer columnIndex : this.columnIndexesToPositionsMap.keySet()) {
                fullySelectedColumns[count++] = columnIndex;
                selectedPositions.add(this.columnIndexesToPositionsMap.get(columnIndex));
            }
            this.model.addColumnsIndexesToGroup(columnGroupName, fullySelectedColumns);
            this.selectionLayer.doCommand(new MultiColumnReorderCommand(this.selectionLayer, selectedPositions, (Integer)selectedPositions.get(0)));
            this.selectionLayer.clear();
        }
        catch (Throwable throwable) {}
        this.contextLayer.fireLayerEvent(new GroupColumnsEvent(this.contextLayer));
    }

    public void handleUngroupCommand() {
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        HashMap<String, Integer> toColumnPositions = new HashMap<String, Integer>();
        if (fullySelectedColumns.length > 0) {
            int index = 0;
            while (index < fullySelectedColumns.length) {
                int columnPosition = fullySelectedColumns[index];
                int columnIndex = this.selectionLayer.getColumnIndexByPosition(columnPosition);
                if (this.model.isPartOfAGroup(columnIndex) && !this.model.isPartOfAnUnbreakableGroup(columnIndex)) {
                    this.handleRemovalFromGroup(toColumnPositions, columnIndex);
                }
                ++index;
            }
            Collection values = toColumnPositions.values();
            for (Integer toColumnPosition : values) {
                this.selectionLayer.doCommand(new ReorderColumnGroupCommand(this.selectionLayer, toColumnPosition, toColumnPosition));
            }
            this.selectionLayer.clear();
        }
        this.contextLayer.fireLayerEvent(new UngroupColumnsEvent(this.contextLayer));
    }

    private void handleRemovalFromGroup(Map<String, Integer> toColumnPositions, int columnIndex) {
        String columnGroupName = this.model.getColumnGroupNameForIndex(columnIndex);
        List<Integer> columnIndexesInGroup = this.model.getColumnIndexesInGroup(columnIndex);
        int columnGroupSize = columnIndexesInGroup.size();
        if (!toColumnPositions.containsKey(columnGroupName)) {
            for (int colGroupIndex : columnIndexesInGroup) {
                if (!ColumnGroupUtils.isFirstVisibleColumnIndexInGroup(colGroupIndex, this.contextLayer, this.selectionLayer, this.model)) continue;
                int toPosition = this.selectionLayer.getColumnPositionByIndex(colGroupIndex);
                if (colGroupIndex == columnIndex) {
                    if (columnGroupSize == 1) break;
                    ++toPosition;
                }
                toColumnPositions.put(columnGroupName, toPosition);
                break;
            }
        } else if (columnGroupSize - 1 <= 0) {
            toColumnPositions.remove(columnGroupName);
        }
        this.model.removeColumnFromGroup(columnIndex);
    }
}

