/*
 * Decompiled with CFR 0.152.
 */
package org.edna.workbench.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;

public class ConvertWizardPage1
extends WizardPage {
    private static final Logger logger = LoggerFactory.getLogger(ConvertWizardPage1.class);
    private CheckboxTableViewer checkboxTableViewer;
    private String[] dataSetNames;
    private ISelection selection;

    public ConvertWizardPage1() {
        super("wizardPage");
        this.setTitle("Convert Data");
        this.setDescription("Convert data from synchrotron formats and compressed files to common simple data formats.");
        this.dataSetNames = new String[]{"Loading..."};
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label label = new Label(composite3, 0);
        label.setBounds(0, 0, 68, 17);
        label.setText("Convert to");
        Combo combo = new Combo(composite3, 8);
        combo.setItems(new String[]{"Comma Separated Values (*.csv)"});
        combo.setToolTipText("Convert to file type by file extension");
        combo.setBounds(0, 0, 189, 29);
        combo.select(0);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(1, false));
        composite4.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite4, (int)67584);
        Table table = this.checkboxTableViewer.getTable();
        table.setToolTipText("Select data to export to the csv.");
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selection = EclipseUtils.getActivePage().getSelection();
        this.checkboxTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return ConvertWizardPage1.this.dataSetNames;
            }
        });
        this.checkboxTableViewer.setInput(new Object());
        this.checkboxTableViewer.setAllGrayed(true);
        composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ConvertWizardPage1.this.getDataSetNames();
                }
                catch (Exception exception) {
                    logger.error("Cannot extract data sets!", (Throwable)exception);
                }
            }
        });
    }

    protected void getDataSetNames() throws Exception {
        this.getContainer().run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                StructuredSelection structuredSelection;
                Object object;
                if (ConvertWizardPage1.this.selection instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)ConvertWizardPage1.this.selection).getFirstElement()) instanceof IFile) {
                    try {
                        Collection collection;
                        IFile iFile = (IFile)object;
                        IMetaData iMetaData = LoaderFactory.getMetaData((String)iFile.getLocation().toOSString(), (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                        if (iMetaData != null && (collection = iMetaData.getDataNames()) != null) {
                            ConvertWizardPage1.this.setDataNames(collection.toArray(new String[collection.size()]));
                            return;
                        }
                        collection = LoaderFactory.getData((String)iFile.getLocation().toOSString(), (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                        ArrayList arrayList = new ArrayList(collection.getMap().keySet());
                        Collections.sort(arrayList);
                        ConvertWizardPage1.this.setDataNames(arrayList.toArray(new String[arrayList.size()]));
                        return;
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
            }
        });
    }

    protected void setDataNames(String[] stringArray) {
        this.dataSetNames = stringArray;
        this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConvertWizardPage1.this.checkboxTableViewer.getTable().setEnabled(true);
                ConvertWizardPage1.this.checkboxTableViewer.refresh();
                ConvertWizardPage1.this.checkboxTableViewer.setAllChecked(true);
                ConvertWizardPage1.this.checkboxTableViewer.setAllGrayed(false);
            }
        });
    }

    protected Object[] getSelected() {
        return this.checkboxTableViewer.getCheckedElements();
    }

    public IFile getFile() {
        StructuredSelection structuredSelection;
        Object object;
        if (this.selection instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)this.selection).getFirstElement()) instanceof IFile) {
            return (IFile)object;
        }
        return null;
    }
}

