/*
 * Decompiled with CFR 0.152.
 */
package extendedMetadata;

import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import uk.ac.diamond.scisoft.analysis.io.IExtendedMetadata;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.sda.meta.page.IMetadataPage;
import uk.ac.diamond.sda.meta.views.MetadataTableView;

public class ExtendedMetaDataComposite
implements IMetadataPage {
    private Composite comp;
    private Text scanCommand;
    private Text fullPath;
    private Text lastMod;
    private Text size;
    private Text owner;
    private Text creator;
    private Text fileName;
    private Text creation;
    private MetadataTableView view;
    private static SimpleDateFormat dateformat = new SimpleDateFormat("dd-MMM-yyyy 'at' HH:mm:ss");

    public void setMetaData(IMetaData iMetaData) {
        if (iMetaData instanceof IExtendedMetadata) {
            this.updateComposite((IExtendedMetadata)iMetaData);
        }
    }

    private void updateComposite(final IExtendedMetadata iExtendedMetadata) {
        UIJob uIJob = new UIJob("Update with new metadata"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (iExtendedMetadata.getScanCommand() != null) {
                    ExtendedMetaDataComposite.this.scanCommand.setText(iExtendedMetadata.getScanCommand());
                }
                if (iExtendedMetadata.getFullPath() != null) {
                    ExtendedMetaDataComposite.this.fullPath.setText(iExtendedMetadata.getFullPath());
                }
                if (iExtendedMetadata.getFileName() != null) {
                    ExtendedMetaDataComposite.this.fileName.setText(iExtendedMetadata.getFileName());
                }
                if (iExtendedMetadata.getLastModified() != null) {
                    ExtendedMetaDataComposite.this.lastMod.setText(dateformat.format(iExtendedMetadata.getLastModified()));
                }
                if (iExtendedMetadata.getCreation() != null) {
                    ExtendedMetaDataComposite.this.creation.setText(dateformat.format(iExtendedMetadata.getCreation()));
                }
                if (iExtendedMetadata.getFileSize() != 0L) {
                    ExtendedMetaDataComposite.this.size.setText(FileUtils.byteCountToDisplaySize((long)iExtendedMetadata.getFileSize()));
                }
                if (iExtendedMetadata.getFileOwner() != null) {
                    ExtendedMetaDataComposite.this.owner.setText(iExtendedMetadata.getFileOwner());
                }
                if (iExtendedMetadata.getCreator() != null) {
                    ExtendedMetaDataComposite.this.creator.setText(iExtendedMetadata.getCreator());
                }
                ExtendedMetaDataComposite.this.view.setMeta((IMetaData)iExtendedMetadata);
                return Status.OK_STATUS;
            }
        };
        uIJob.schedule();
    }

    public Composite createComposite(Composite composite) {
        this.comp = new Composite(composite, 0);
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.comp.setLayoutData((Object)new GridData(4, 4, true, false));
        Group group = new Group(this.comp, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText("Extended Metadata");
        new Label((Composite)group, 0).setText("Scan Command");
        this.scanCommand = new Text((Composite)group, 8);
        this.scanCommand.setBackground(group.getBackground());
        this.scanCommand.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label((Composite)group, 0).setText("Full Path");
        this.fullPath = new Text((Composite)group, 8);
        this.fullPath.setBackground(group.getBackground());
        this.fullPath.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label((Composite)group, 0).setText("File name");
        this.fileName = new Text((Composite)group, 8);
        this.fileName.setBackground(group.getBackground());
        this.fileName.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label((Composite)group, 0).setText("Last Modified");
        this.lastMod = new Text((Composite)group, 8);
        this.lastMod.setBackground(group.getBackground());
        this.lastMod.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label((Composite)group, 0).setText("Cretion");
        this.creation = new Text((Composite)group, 8);
        this.creation.setBackground(group.getBackground());
        this.creation.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label((Composite)group, 0).setText("File Size");
        this.size = new Text((Composite)group, 8);
        this.size.setBackground(group.getBackground());
        this.size.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label((Composite)group, 0).setText("Owner");
        this.owner = new Text((Composite)group, 8);
        this.owner.setBackground(group.getBackground());
        this.owner.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label((Composite)group, 0).setText("Creator");
        this.creator = new Text((Composite)group, 8);
        this.creator.setBackground(group.getBackground());
        this.creator.setLayoutData((Object)new GridData(4, 4, true, false));
        this.view = new MetadataTableView();
        this.view.createPartControl(this.comp);
        return this.comp;
    }
}

