/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.views;

import fable.framework.imageprint.JLChartActions;
import fable.framework.ui.object.ColumnFileController;
import fable.framework.ui.rcp.Activator;
import fable.python.ColumnFile;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import jep.JepException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColFileXYPlot
implements IJLChartListener {
    private static final long serialVersionUID = 1L;
    private Vector<ColumnFile> columnFileVector = new Vector();
    private Vector<JLDataView> dataViewVector = new Vector();
    private Frame chartFrame;
    private JApplet chartContainer;
    private JLChart chart;
    private JLChartActions actions;
    Composite parent;
    SashForm sashForm;
    private Composite plotSwtAwtComposite;
    private ScrolledComposite optionsComposite;
    private boolean optionsShowing = true;
    private IJLChartActionListener chartActionListener;
    private PaintListener paintListener;
    private String chartName;
    private String syAxisLabel;
    private String sxAxisLabel;
    static int iDataColor = 0;
    Combo colFileCombo;
    Combo xKeysCombo;
    Combo yKeysCombo;
    public Button updateButton;
    private Button removeButton;
    private Button resetButton;
    private Button switchXYButton;
    private Group editGroup;
    private int currentXIndex = 0;
    private int currentYIndex = 1;
    double[] currentXData;
    double[] currentYData;
    private JLDataView currentDataView = null;
    ColumnFile currentColumnFile = null;
    private Text txtY1Min;
    private Text txtY1Max;
    private Text txtXMax;
    private Text txtXMin;
    private Button removeDataButton;
    private Button keepDataButton;
    ImageDescriptor widget_close = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/widget_close.gif");
    ImageDescriptor widget_open = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/widget_open.gif");
    private ImageDescriptor imgdescChartOpt = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/graphView.gif");
    private ImageDescriptor imgdescRefreshplot = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/refresh.gif");
    private ImageDescriptor imgdescdelete = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/delete.gif");
    private ImageDescriptor imgdescswitch = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/switch.gif");
    private ImageDescriptor imgdescSub = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/subtract.gif");
    private Color[] dataColors = new Color[]{new Color(51, 51, 255), new Color(255, 51, 0), new Color(51, 255, 255), new Color(255, 204, 51), new Color(153, 0, 153), new Color(0, 255, 60)};
    private ImageDescriptor keep_descriptor = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/check.gif");
    private ImageDescriptor remove_descriptor = Activator.imageDescriptorFromPlugin((String)"org.dawb.fable.framework.ui", (String)"images/delete.gif");
    private Image img_delete;
    private Image img_keep;
    private ColumnFileController colController;
    private JLDataView markedDataView;
    private int[] selectedRowsId;

    public ColFileXYPlot(Composite composite, String string, String string2, String string3) {
        this.parent = composite;
        this.chartName = string;
        this.syAxisLabel = string3;
        this.sxAxisLabel = string2;
        this.img_keep = this.keep_descriptor.createImage();
        int n = this.img_keep.getBounds().width;
        int n2 = this.img_keep.getBounds().height;
        Image image = this.remove_descriptor.createImage();
        this.img_delete = new Image((Device)Display.getDefault(), image.getImageData().scaledTo(n, n2));
        image.dispose();
        composite.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                ColFileXYPlot.this.repaint();
            }
        });
        this.sashForm = new SashForm(composite, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashForm);
        this.createChartFrame((Composite)this.sashForm);
        this.createChart();
        this.createOptionsGroup((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{2, 1});
        this.colController = ColumnFileController.getColumnFileController();
        this.colController.setcolumnFileVector(this.columnFileVector);
    }

    public void setSyAxisLabel(String string) {
        if (string != null) {
            this.syAxisLabel = string;
            this.selectLabelinYCombo(string);
        }
    }

    public void setSxAxisLabel(String string) {
        if (string != null) {
            this.sxAxisLabel = string;
            this.selectLabelinXCombo(string);
        }
    }

    public void populateListsKeys(final ColumnFile columnFile) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = columnFile.getTitles();
                ColFileXYPlot.this.xKeysCombo.removeAll();
                ColFileXYPlot.this.yKeysCombo.removeAll();
                int n = 0;
                while (stringArray != null && n < stringArray.length) {
                    String string = stringArray[n];
                    ColFileXYPlot.this.yKeysCombo.setData("help" + string, (Object)string);
                    ColFileXYPlot.this.xKeysCombo.setData("help" + string, (Object)string);
                    ColFileXYPlot.this.xKeysCombo.add(string);
                    ColFileXYPlot.this.yKeysCombo.add(string);
                    ++n;
                }
                ColFileXYPlot.this.yKeysCombo.setEnabled(ColFileXYPlot.this.yKeysCombo.getItemCount() > 0);
                ColFileXYPlot.this.xKeysCombo.setEnabled(ColFileXYPlot.this.yKeysCombo.getItemCount() > 0);
                if (ColFileXYPlot.this.currentXIndex > ColFileXYPlot.this.xKeysCombo.getItemCount()) {
                    ColFileXYPlot.this.resetPreferredCurrentXIndex();
                }
                if (ColFileXYPlot.this.currentYIndex > ColFileXYPlot.this.yKeysCombo.getItemCount()) {
                    ColFileXYPlot.this.resetPreferredCurrentY1Index();
                }
                ColFileXYPlot.this.xKeysCombo.select(ColFileXYPlot.this.currentXIndex);
                ColFileXYPlot.this.yKeysCombo.select(ColFileXYPlot.this.currentYIndex);
            }
        });
    }

    private void createListsKeys_X(Composite composite) {
        new Label(composite, 0).setText("X");
        this.xKeysCombo = new Combo(composite, 2560);
        GridData gridData = new GridData(16384, 2, true, false);
        this.xKeysCombo.setLayoutData((Object)gridData);
        this.xKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColFileXYPlot.this.plotSelectedXAxis();
            }
        });
    }

    private void plotSelectedXAxis() {
        String[] stringArray = this.xKeysCombo.getItems();
        this.currentXIndex = this.xKeysCombo.getSelectionIndex();
        if (this.currentXIndex < 0) {
            this.resetPreferredCurrentXIndex();
        }
        this.sxAxisLabel = stringArray[this.currentXIndex];
        this.chart.getXAxis().setName(this.sxAxisLabel);
        this.updateChart();
    }

    private void createListsKeys_Y(Composite composite) {
        new Label(composite, 0).setText("Y");
        this.yKeysCombo = new Combo(composite, 2560);
        GridData gridData = new GridData(16384, 2, true, false);
        this.yKeysCombo.setLayoutData((Object)gridData);
        this.yKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColFileXYPlot.this.plotSelectedY1Axis();
            }
        });
    }

    private void plotSelectedY1Axis() {
        String[] stringArray = this.yKeysCombo.getItems();
        this.currentYIndex = this.yKeysCombo.getSelectionIndex();
        if (this.currentYIndex < 0) {
            this.resetPreferredCurrentY1Index();
        }
        this.syAxisLabel = stringArray[this.currentYIndex];
        this.chart.getY1Axis().setName(this.syAxisLabel);
        this.updateChart();
    }

    private void createOptionsGroup(Composite composite) {
        this.optionsComposite = new ScrolledComposite(composite, 768);
        this.optionsComposite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite((Composite)this.optionsComposite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData());
        composite2.pack();
        this.optionsComposite.setContent((Control)composite2);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        ((GridLayout)group.getLayout()).numColumns = 2;
        GridData gridData = new GridData(0x1000004, 4, true, false);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        group.setText("Plot Options");
        this.createListsKeys_X((Composite)group);
        this.createListsKeys_Y((Composite)group);
        new Label((Composite)group, 0).setText("Data");
        this.colFileCombo = new Combo((Composite)group, 8);
        this.colFileCombo.setEnabled(this.dataViewVector.size() > 0);
        this.colFileCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.colFileCombo.getLayoutData()).horizontalSpan = 1;
        this.colFileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                Combo combo = (Combo)selectionEvent.widget;
                int n = combo.getSelectionIndex();
                if (n >= 0) {
                    ColFileXYPlot.this.currentColumnFile = (ColumnFile)ColFileXYPlot.this.columnFileVector.get(n);
                    ColFileXYPlot.this.colController.setCurrentColumnFile(ColFileXYPlot.this.currentColumnFile);
                    ColFileXYPlot.this.populateListsKeys(ColFileXYPlot.this.currentColumnFile);
                    if (ColFileXYPlot.this.currentDataView != null) {
                        ColFileXYPlot.this.chart.removeDataView(ColFileXYPlot.this.currentDataView);
                    }
                    ColFileXYPlot.this.currentDataView = (JLDataView)ColFileXYPlot.this.dataViewVector.get(n);
                    ColFileXYPlot.this.chart.getY1Axis().addDataView(ColFileXYPlot.this.currentDataView);
                }
                ColFileXYPlot.this.updateChart();
                ColFileXYPlot.this.repaint();
            }
        });
        this.createOptionsButtons(group);
        this.createEditPlotOptions(composite2);
        this.optionsComposite.setMinHeight(Display.getDefault().getPrimaryMonitor().getBounds().height);
        this.optionsComposite.setMinWidth(Display.getDefault().getPrimaryMonitor().getBounds().width);
        this.optionsComposite.setExpandVertical(true);
        this.optionsComposite.setExpandHorizontal(true);
        this.optionsComposite.setMinSize(composite2.computeSize(-1, -1));
    }

    private void createOptionsButtons(Group group) {
        this.createRemoveButton(group);
        this.createShowDataOptionsButton(group);
        this.createSwitchXYButton(group);
        this.createUpdateButton(group);
        this.createClearAllButton(group);
    }

    private void createSwitchXYButton(Group group) {
        this.switchXYButton = new Button((Composite)group, 8);
        this.switchXYButton.setText("Switch X Y");
        final Image image = this.imgdescswitch.createImage();
        this.switchXYButton.setImage(image);
        this.switchXYButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
        this.switchXYButton.setToolTipText("Switch the x and y axes");
        this.switchXYButton.setLayoutData((Object)new GridData(272));
        this.switchXYButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ColFileXYPlot.this.currentXIndex < 0 || ColFileXYPlot.this.currentYIndex < 0) {
                    return;
                }
                int n = ColFileXYPlot.this.currentYIndex;
                ColFileXYPlot.this.currentYIndex = ColFileXYPlot.this.currentXIndex;
                ColFileXYPlot.this.currentXIndex = n;
                String string = ColFileXYPlot.this.syAxisLabel;
                ColFileXYPlot.this.syAxisLabel = ColFileXYPlot.this.sxAxisLabel;
                ColFileXYPlot.this.sxAxisLabel = string;
                ColFileXYPlot.this.xKeysCombo.select(ColFileXYPlot.this.currentXIndex);
                ColFileXYPlot.this.yKeysCombo.select(ColFileXYPlot.this.currentYIndex);
                ColFileXYPlot.this.chart.getXAxis().setName(ColFileXYPlot.this.sxAxisLabel);
                ColFileXYPlot.this.chart.getY1Axis().setName(ColFileXYPlot.this.syAxisLabel);
                ColFileXYPlot.this.updateChart();
            }
        });
    }

    private void createClearAllButton(Group group) {
        this.resetButton = new Button((Composite)group, 8);
        this.resetButton.setText("Clear");
        final Image image = this.imgdescdelete.createImage();
        this.resetButton.setImage(image);
        this.resetButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
        this.resetButton.setToolTipText("Clear plot and remove all column files");
        this.resetButton.setLayoutData((Object)new GridData(272));
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColFileXYPlot.this.clearAllPlots();
            }
        });
    }

    private void createUpdateButton(Group group) {
        this.updateButton = new Button((Composite)group, 8);
        this.updateButton.setText("Update");
        final Image image = this.imgdescRefreshplot.createImage();
        this.updateButton.setImage(image);
        this.updateButton.setToolTipText("Update chart frame and plot");
        this.updateButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
        this.updateButton.setLayoutData((Object)new GridData(272));
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                double[] dArray;
                int n;
                double[] dArray2 = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.sxAxisLabel);
                int n2 = n = dArray2 != null ? dArray2.length : 0;
                if (n > 0) {
                    ColFileXYPlot.this.currentXData = new double[n];
                    ColFileXYPlot.this.currentXData = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.sxAxisLabel);
                }
                int n3 = n = (dArray = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.syAxisLabel)) != null ? dArray.length : 0;
                if (n > 0) {
                    ColFileXYPlot.this.currentYData = new double[n];
                    ColFileXYPlot.this.currentYData = (double[])ColFileXYPlot.this.currentColumnFile.getColumnstoPlot().get(ColFileXYPlot.this.syAxisLabel);
                }
                ColFileXYPlot.this.updateChart(ColFileXYPlot.this.currentXData, ColFileXYPlot.this.currentYData);
            }
        });
    }

    private void createShowDataOptionsButton(Group group) {
        Button button = new Button((Composite)group, 8);
        button.setText("Data");
        button.setLayoutData((Object)new GridData(272));
        final Image image = this.imgdescChartOpt.createImage();
        button.setImage(image);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ColFileXYPlot.this.currentDataView != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ColFileXYPlot.this.chart.showDataOptionDialog(ColFileXYPlot.this.currentDataView);
                        }
                    });
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Column file plot", (String)"No current dataview is available to display options.");
                }
            }
        });
        button.setToolTipText("Display current data options box.");
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
    }

    private void createRemoveButton(Group group) {
        this.removeButton = new Button((Composite)group, 8);
        final Image image = this.imgdescSub.createImage();
        this.removeButton.setImage(image);
        this.removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
        this.removeButton.setLayoutData((Object)new GridData(272));
        this.removeButton.setText("Remove Data");
        this.removeButton.setToolTipText("Remove selected ColumnFile of the list from the plot");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ColFileXYPlot.this.colFileCombo.getSelectionIndex();
                ColFileXYPlot.this.columnFileVector.remove(n);
                JLDataView jLDataView = (JLDataView)ColFileXYPlot.this.dataViewVector.elementAt(n);
                ColFileXYPlot.this.chart.removeDataView(jLDataView);
                ColFileXYPlot.this.xKeysCombo.removeAll();
                ColFileXYPlot.this.yKeysCombo.removeAll();
                ColFileXYPlot.this.dataViewVector.remove(n);
                ColFileXYPlot.this.colFileCombo.remove(n);
                if (n > ColFileXYPlot.this.colFileCombo.getItemCount() - 1) {
                    n = ColFileXYPlot.this.colFileCombo.getItemCount() - 1;
                }
                ColFileXYPlot.this.colFileCombo.select(n);
                ColFileXYPlot.this.colFileCombo.notifyListeners(13, new Event());
            }
        });
    }

    private void createEditPlotOptions(Composite composite) {
        this.editGroup = new Group(composite, 0);
        this.editGroup.setText("Plot Editor");
        this.editGroup.setLayout((Layout)new GridLayout());
        ((GridLayout)this.editGroup.getLayout()).numColumns = 2;
        GridData gridData = new GridData(0x1000004, 4, true, false);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 1;
        this.editGroup.setLayoutData((Object)gridData);
        new Label((Composite)this.editGroup, 0).setText("X Min");
        this.txtXMin = new Text((Composite)this.editGroup, 2048);
        this.txtXMin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.editGroup, 0).setText("X Max");
        this.txtXMax = new Text((Composite)this.editGroup, 2048);
        this.txtXMax.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.editGroup, 0).setText("Y Min");
        this.txtY1Min = new Text((Composite)this.editGroup, 2048);
        this.txtY1Min.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.editGroup, 0).setText("Y Max");
        this.txtY1Max = new Text((Composite)this.editGroup, 2048);
        this.txtY1Max.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.keepDataButton = new Button((Composite)this.editGroup, 8);
        this.keepDataButton.setText("Keep");
        this.keepDataButton.setToolTipText("Keep all dots between min X, Y and max X, Y and remove others");
        this.keepDataButton.setImage(this.img_keep);
        this.keepDataButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ColFileXYPlot.this.img_keep != null && !ColFileXYPlot.this.img_keep.isDisposed()) {
                    ColFileXYPlot.this.img_keep.dispose();
                }
            }
        });
        this.keepDataButton.setEnabled(this.columnFileVector.size() > 0);
        this.keepDataButton.setLayoutData((Object)new GridData(256, 2, true, false, 1, 1));
        this.keepDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d = Double.valueOf(ColFileXYPlot.this.txtXMin.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d2 = Double.valueOf(ColFileXYPlot.this.txtY1Min.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d3 = Double.valueOf(ColFileXYPlot.this.txtXMax.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d4 = Double.valueOf(ColFileXYPlot.this.txtY1Max.getText());
                }
                ColFileXYPlot.this.keepDots(d, d3, d2, d4);
                ColFileXYPlot.this.updateChart();
                ColFileXYPlot.this.repaint();
            }
        });
        this.removeDataButton = new Button((Composite)this.editGroup, 8);
        this.removeDataButton.setText("Remove");
        this.removeDataButton.setToolTipText("Remove all dots between min X, Y and max X, Y and keep others");
        this.removeDataButton.setImage(this.img_delete);
        this.removeDataButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ColFileXYPlot.this.img_delete != null && !ColFileXYPlot.this.img_delete.isDisposed()) {
                    ColFileXYPlot.this.img_delete.dispose();
                }
            }
        });
        this.removeDataButton.setEnabled(this.columnFileVector.size() > 0);
        this.removeDataButton.setLayoutData((Object)new GridData(256, 2, true, false, 1, 1));
        this.removeDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d = Double.valueOf(ColFileXYPlot.this.txtXMin.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d2 = Double.valueOf(ColFileXYPlot.this.txtY1Min.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d3 = Double.valueOf(ColFileXYPlot.this.txtXMax.getText());
                }
                if (!ColFileXYPlot.this.txtXMin.getText().trim().equals("")) {
                    d4 = Double.valueOf(ColFileXYPlot.this.txtY1Max.getText());
                }
                ColFileXYPlot.this.removeDots(d, d3, d2, d4);
                ColFileXYPlot.this.updateChart();
                ColFileXYPlot.this.repaint();
            }
        });
    }

    private void removeDots(double d, double d2, double d3, double d4) {
        try {
            this.currentColumnFile.removeDots(this.sxAxisLabel, d, d2, this.syAxisLabel, d3, d4);
        }
        catch (JepException jepException) {
            System.out.println(jepException.getMessage());
        }
    }

    private void keepDots(double d, double d2, double d3, double d4) {
        try {
            this.currentColumnFile.keepDots(this.sxAxisLabel, d, d2, this.syAxisLabel, d3, d4);
        }
        catch (JepException jepException) {
            System.out.println(jepException.getMessage());
        }
    }

    private void createChartFrame(Composite composite) {
        this.plotSwtAwtComposite = new Composite(composite, 0x1040000);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 2;
        gridData.horizontalSpan = 2;
        this.plotSwtAwtComposite.setLayout((Layout)new GridLayout());
        this.plotSwtAwtComposite.setLayoutData((Object)gridData);
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.plotSwtAwtComposite);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void clearAllPlots() {
        Iterator<JLDataView> iterator = this.dataViewVector.iterator();
        while (iterator.hasNext()) {
            this.chart.removeDataView(iterator.next());
        }
        this.columnFileVector.removeAllElements();
        this.dataViewVector.removeAllElements();
        this.colFileCombo.removeAll();
        this.xKeysCombo.removeAll();
        this.yKeysCombo.removeAll();
        this.repaint();
        iDataColor = 0;
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setToolTipText("Zoom: Ctrl + select zone with mouse ");
        this.chart.setHeader(this.chartName);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName(this.syAxisLabel);
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chart.getXAxis().setName(this.sxAxisLabel);
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getXAxis().setAutoScale(true);
        this.chartContainer.add((Component)this.chart);
        Dimension dimension = this.chartContainer.getSize();
        if (dimension.height < dimension.width) {
            this.chart.setSize(dimension.height, dimension.height);
        } else {
            this.chart.setSize(dimension.width, dimension.width);
        }
        this.actions = new JLChartActions(this.parent.getDisplay(), this.chart);
        this.chart.removeMenuItem(4);
        this.chart.addUserAction("Print Setup");
        this.chart.addUserAction("Print Preview");
        this.chart.addUserAction("Print");
        this.chart.addUserAction("Copy");
        this.chart.addUserAction("Toggle Plot Options");
        this.chartActionListener = new IJLChartActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(final JLChartActionEvent jLChartActionEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (jLChartActionEvent.getName().equals("Print Setup")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.printSetupAction.run();
                        } else if (jLChartActionEvent.getName().equals("Print Preview")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.printPreviewAction.run();
                        } else if (jLChartActionEvent.getName().equals("Print")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.printAction.run();
                        } else if (jLChartActionEvent.getName().equals("Copy")) {
                            ((ColFileXYPlot)(this).ColFileXYPlot.this).actions.copyAction.run();
                        } else if (jLChartActionEvent.getName().equals("Toggle Plot Options")) {
                            ColFileXYPlot.this.setOptionsShowing(!ColFileXYPlot.this.optionsShowing);
                        }
                    }
                });
            }

            public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
                return false;
            }
        };
        this.chart.addJLChartActionListener(this.chartActionListener);
        this.chart.setJLChartListener((IJLChartListener)this);
        this.chart.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        double d = ColFileXYPlot.this.chart.getXAxis().getMin();
                        double d2 = ColFileXYPlot.this.chart.getY1Axis().getMin();
                        double d3 = ColFileXYPlot.this.chart.getXAxis().getMax();
                        double d4 = ColFileXYPlot.this.chart.getY1Axis().getMax();
                        if (ColFileXYPlot.this.chart.getY1Axis().getScale() == 1) {
                            d2 = Math.pow(10.0, d2);
                            d4 = Math.pow(10.0, d4);
                        }
                        if (ColFileXYPlot.this.chart.getXAxis().getScale() == 1) {
                            d = Math.pow(10.0, d);
                            d3 = Math.pow(10.0, d3);
                        }
                        ColFileXYPlot.this.txtY1Min.setText(String.valueOf(d2));
                        ColFileXYPlot.this.txtY1Max.setText(String.valueOf(d4));
                        ColFileXYPlot.this.txtXMax.setText(String.valueOf(d3));
                        ColFileXYPlot.this.txtXMin.setText(String.valueOf(d));
                    }
                });
            }
        });
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray = new String[]{String.valueOf(this.sxAxisLabel) + "=" + jLChartEvent.getXValue(), String.valueOf(this.syAxisLabel) + "=" + jLChartEvent.getYValue()};
        return stringArray;
    }

    public int[] markSelectedRows(double[] dArray, String string) {
        this.selectedRowsId = new int[dArray.length];
        if (this.markedDataView == null) {
            this.markedDataView = new JLDataView();
            this.setDataViewOptions(this.markedDataView, 8, null, 7, 0);
        } else {
            this.markedDataView.reset();
        }
        double[] dArray2 = (double[])this.currentColumnFile.getColumnstoPlot().get(string);
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray2.length) {
                if (dArray2[n2] == dArray[n]) {
                    this.selectedRowsId[n] = n2;
                    if (this.currentDataView == null) break;
                    double d = this.currentDataView.getXValueByIndex(n2);
                    double d2 = this.currentDataView.getYValueByIndex(n2);
                    this.markedDataView.add(d, d2);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (this.markedDataView.getDataLength() > 0) {
            this.markedDataView.setLabelVisible(true);
            this.markedDataView.setName("# " + dArray.length + " selected dots in table : ");
            this.setDataViewOptions(this.markedDataView, this.markedDataView.getMarker(), this.markedDataView.getMarkerColor(), this.markedDataView.getMarkerSize(), this.markedDataView.getLineWidth());
            this.chart.getY1Axis().addDataView(this.markedDataView);
            this.repaint();
        }
        return this.selectedRowsId;
    }

    public void updateChart() {
        double[] dArray;
        if (this.currentDataView != null) {
            this.currentDataView.reset();
        }
        this.currentYData = null;
        this.currentXData = null;
        if (this.xKeysCombo.getItemCount() > this.currentXIndex && this.currentXIndex > -1) {
            this.sxAxisLabel = this.xKeysCombo.getItem(this.currentXIndex);
            this.chart.getXAxis().setName(this.sxAxisLabel);
        }
        int n = 0;
        if (this.sxAxisLabel != null && this.currentColumnFile != null) {
            dArray = (double[])this.currentColumnFile.getColumnstoPlot().get(this.sxAxisLabel);
            int n2 = n = dArray != null ? dArray.length : 0;
        }
        if (n > 0) {
            this.currentXData = new double[n];
            this.currentXData = (double[])this.currentColumnFile.getColumnstoPlot().get(this.sxAxisLabel);
        }
        if (this.yKeysCombo.getItemCount() > this.currentYIndex && this.currentYIndex > -1) {
            this.syAxisLabel = this.yKeysCombo.getItem(this.currentYIndex);
            this.chart.getY1Axis().setName(this.syAxisLabel);
        }
        if (this.syAxisLabel != null && this.currentColumnFile != null) {
            dArray = (double[])this.currentColumnFile.getColumnstoPlot().get(this.syAxisLabel);
            int n3 = n = dArray != null ? dArray.length : 0;
        }
        if (n > 0) {
            this.currentYData = new double[n];
            this.currentYData = (double[])this.currentColumnFile.getColumnstoPlot().get(this.syAxisLabel);
        }
        if (this.currentXData != null && this.currentYData != null) {
            if (!this.syAxisLabel.equals("") && !this.sxAxisLabel.equals("")) {
                if (this.currentDataView == null) {
                    this.currentDataView = new JLDataView();
                }
                this.currentDataView.setXDataSorted(false);
                this.currentDataView.setData(this.currentXData, this.currentYData);
            }
            this.chart.setHeader(this.currentColumnFile.getFileName());
        } else {
            this.chart.setNoValueString("No value to display");
        }
        this.updateRowsMarked();
        this.repaint();
    }

    private void updateRowsMarked() {
        if (this.selectedRowsId != null && this.selectedRowsId.length > 0) {
            this.markedDataView.reset();
            double[] dArray = (double[])this.currentColumnFile.getColumnstoPlot().get(this.currentColumnFile.getColumnfileId());
            int n = 0;
            while (n < this.selectedRowsId.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    if (dArray[n2] == (double)this.selectedRowsId[n]) {
                        if (this.currentDataView == null) break;
                        double d = this.currentDataView.getXValueByIndex(n2);
                        double d2 = this.currentDataView.getYValueByIndex(n2);
                        this.markedDataView.add(d, d2);
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.markedDataView != null) {
                this.chart.getY1Axis().addDataView(this.markedDataView);
            }
        }
    }

    public JLDataView updateChart(double[] dArray, double[] dArray2) {
        if (!Display.getCurrent().isDisposed()) {
            if (dArray != null && dArray2 != null) {
                if (!this.syAxisLabel.equals("") && !this.sxAxisLabel.equals("")) {
                    if (this.currentDataView == null) {
                        this.currentDataView = new JLDataView();
                    }
                    this.currentDataView.setXDataSorted(false);
                    this.currentDataView.setData(dArray, dArray2);
                }
            } else {
                this.chart.setNoValueString("No value to display");
            }
        }
        this.repaint();
        this.currentDataView = null;
        return null;
    }

    public void updateColumnFile(ColumnFile columnFile) {
        this.populateListsKeys(columnFile);
    }

    public void addColumnFile(ColumnFile columnFile) {
        this.currentColumnFile = columnFile;
        this.colController.setCurrentColumnFile(this.currentColumnFile);
        if (this.columnFileVector.lastIndexOf(columnFile) < 0) {
            this.columnFileVector.add(columnFile);
            JLDataView jLDataView = null;
            jLDataView = new JLDataView();
            jLDataView.setXDataSorted(false);
            jLDataView.setName(columnFile.getFullFileName());
            this.addDataView(jLDataView);
            this.populateListsKeys(columnFile);
            if (this.xKeysCombo.getItemCount() > 0) {
                this.setSxAxisLabel(this.xKeysCombo.getItems()[this.currentXIndex]);
            }
            if (this.yKeysCombo.getItemCount() > 0) {
                this.setSyAxisLabel(this.yKeysCombo.getItems()[this.currentYIndex]);
            }
            this.updateChart();
        } else {
            this.populateListsKeys(columnFile);
            this.repaint();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ColFileXYPlot.this.removeDataButton.setEnabled(ColFileXYPlot.this.columnFileVector.size() > 0);
                ColFileXYPlot.this.keepDataButton.setEnabled(ColFileXYPlot.this.columnFileVector.size() > 0);
            }
        });
    }

    public void addDataView(JLDataView jLDataView) {
        if (!Display.getCurrent().isDisposed()) {
            if (jLDataView != null) {
                this.chart.getY1Axis().setName(this.syAxisLabel);
                this.chart.getXAxis().setName(this.sxAxisLabel);
                if (this.dataViewVector.indexOf(jLDataView) < 0) {
                    this.dataViewVector.add(jLDataView);
                    this.colFileCombo.add(jLDataView.getName());
                    this.colFileCombo.setData(jLDataView.getName(), (Object)this.columnFileVector.lastElement());
                }
                if (this.currentDataView != null) {
                    this.chart.removeDataView(this.currentDataView);
                }
                this.currentDataView = jLDataView;
                this.currentColumnFile = this.columnFileVector.lastElement();
                this.colController.setCurrentColumnFile(this.currentColumnFile);
                this.colFileCombo.select(this.colFileCombo.getItemCount() - 1);
                this.colFileCombo.setEnabled(this.dataViewVector.size() > 0);
                this.setDataViewOptions(jLDataView, 1, null, 7, 0);
                this.chart.getY1Axis().addDataView(jLDataView);
            } else {
                this.chart.setNoValueString("No value to display");
            }
            this.repaint();
        }
    }

    private void setDataViewOptions(JLDataView jLDataView, int n, Color color, int n2, int n3) {
        jLDataView.setMarker(n);
        jLDataView.setMarkerSize(n2);
        jLDataView.setLineWidth(n3);
        if (color == null) {
            jLDataView.setMarkerColor(this.dataColors[iDataColor]);
            iDataColor = iDataColor < this.dataColors.length - 1 ? ++iDataColor : 0;
        }
    }

    public void removeDataView(JLDataView jLDataView) {
        this.chart.removeDataView(jLDataView);
        this.dataViewVector.remove(jLDataView);
        if (this.colFileCombo.getItemCount() > 0) {
            this.colFileCombo.remove(jLDataView.getName());
            this.colFileCombo.select(this.colFileCombo.getItemCount() - 1);
        } else {
            this.colFileCombo.setEnabled(false);
        }
        this.repaint();
    }

    public void repaint() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColFileXYPlot.this.chartContainer.repaint();
            }
        });
    }

    private void selectLabelinXCombo(String string) {
        boolean bl = false;
        int n = 0;
        n = 0;
        while (this.xKeysCombo != null && !bl && n < this.xKeysCombo.getItemCount()) {
            if (this.xKeysCombo.getItems()[n].equals(string)) {
                bl = true;
                this.xKeysCombo.select(n);
                this.currentXIndex = n;
            }
            ++n;
        }
    }

    private void selectLabelinYCombo(String string) {
        boolean bl = false;
        int n = 0;
        n = 0;
        while (this.yKeysCombo != null && !bl && n < this.yKeysCombo.getItemCount()) {
            if (this.yKeysCombo.getItems()[n].equals(string)) {
                bl = true;
                this.yKeysCombo.select(n);
                this.currentYIndex = n;
            }
            ++n;
        }
    }

    public JLChart getChart() {
        return this.chart;
    }

    public JApplet getChartContainer() {
        return this.chartContainer;
    }

    public Vector<JLDataView> getVectordataview() {
        return this.dataViewVector;
    }

    public JLDataView getCurrentDataView() {
        return this.currentDataView;
    }

    public void plotData(String[] stringArray) {
        boolean bl = false;
        String string = "";
        String string2 = "";
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        int n = 0;
        while (!bl && n < this.xKeysCombo.getItemCount()) {
            if (this.xKeysCombo.getItem(n).equals(string)) {
                bl = true;
                this.xKeysCombo.select(n);
            }
            ++n;
        }
        bl = false;
        n = 0;
        while (!bl && n < this.yKeysCombo.getItemCount()) {
            if (this.yKeysCombo.getItem(n).equals(string2)) {
                bl = true;
                this.yKeysCombo.select(n);
            }
            ++n;
        }
        this.plotSelectedXAxis();
        this.plotSelectedY1Axis();
    }

    public void dispose() {
        if (this.chart != null && this.chartActionListener != null) {
            this.chart.removeJLChartActionListener(this.chartActionListener);
            this.chartActionListener = null;
        }
        if (this.parent != null && !this.parent.isDisposed() && this.paintListener != null) {
            this.parent.removePaintListener(this.paintListener);
            this.paintListener = null;
        }
        this.chart = null;
    }

    public boolean getOptionsShowing() {
        return this.optionsShowing;
    }

    public void setOptionsShowing(boolean bl) {
        this.optionsShowing = bl;
        if (this.sashForm == null) {
            return;
        }
        if (bl) {
            this.sashForm.setMaximizedControl(null);
        } else {
            this.sashForm.setMaximizedControl((Control)this.plotSwtAwtComposite);
        }
    }

    private void resetPreferredCurrentXIndex() {
        this.currentXIndex = 0;
    }

    private void resetPreferredCurrentY1Index() {
        this.currentYIndex = 1;
    }

    class comboDataView_ContentProvider
    implements IContentProvider {
        comboDataView_ContentProvider() {
        }

        public Object[] getElements(Vector<JLDataView> vector) {
            return vector.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class comboDataView_LabelProvider
    implements IBaseLabelProvider {
        comboDataView_LabelProvider() {
        }

        public Image getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            return ((JLDataView)object).getName();
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

