/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.internal;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.console.ConsolePlugin;
import org.slf4j.Logger;

public class TestMenu {
    private static final String[] actionMethods = new String[]{"createExceptionTestAction", "createLoggingTestAction", "createLoggingLevelTestAction"};

    static MenuManager createTestMenu() {
        MenuManager menuManager = new MenuManager("Test");
        int n = 0;
        while (n < actionMethods.length) {
            try {
                Method method = TestMenu.class.getDeclaredMethod(actionMethods[n], null);
                Action action = (Action)method.invoke(null, null);
                menuManager.add((IAction)action);
            }
            catch (Exception exception) {}
            ++n;
        }
        if (menuManager.getItems().length > 0) {
            return menuManager;
        }
        return null;
    }

    private static Action createConsoleTestAction() {
        System.out.println("getConsoles().length: " + ConsolePlugin.getDefault().getConsoleManager().getConsoles().length);
        System.out.println("Exist: FableMessageConsole.console: " + FableMessageConsole.console);
        final FableMessageConsole fableMessageConsole = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[0];
        System.out.println("getConsoles[0]: console1: " + fableMessageConsole);
        final FableMessageConsole fableMessageConsole2 = new FableMessageConsole("Console 2");
        System.out.println("Created: console2: " + fableMessageConsole2);
        System.out.println("getConsoles().length: " + ConsolePlugin.getDefault().getConsoleManager().getConsoles().length);
        System.out.println();
        Action action = new Action("Test Console"){

            public void run() {
                String string = "FableMessageConsole: " + FableMessageConsole.console;
                System.out.println(string);
                FableMessageConsole.console.displayInfo(string);
                string = "console1: " + fableMessageConsole;
                System.out.println(string);
                fableMessageConsole.displayInfo(string);
                string = "console2: " + fableMessageConsole2;
                System.out.println(string);
                fableMessageConsole2.displayInfo(string);
            }
        };
        return action;
    }

    private static Action createExceptionTestAction() {
        Action action = new Action("Test Exception Messages"){

            public void run() {
                try {
                    Double.parseDouble("garbage");
                }
                catch (NumberFormatException numberFormatException) {
                    FableUtils.excTraceMsg((Object)((Object)this), (String)"This operation has used FableUtils.excTraceMsg", (Throwable)numberFormatException);
                    FableUtils.excMsg((Object)((Object)this), (String)"This operation has used FableUtils.excMsg", (Throwable)numberFormatException);
                    FableUtils.errMsg(((Object)((Object)this)).getClass(), (String)"This operation has used FableUtils.errMsg");
                    FableUtils.warnMsg(TestMenu.class, (String)"This operation has used FableUtils.warnMsg");
                    FableUtils.infoMsg((Object)"XXX", (String)"This operation has used FableUtils.infoMsg");
                }
            }
        };
        return action;
    }

    private static Action createLoggingTestAction() {
        Action action = new Action("Test Logging"){

            public void run() {
                Object object;
                String[] stringArray;
                Logger logger = FableLogger.getLogger();
                System.out.println("\nFableLogger.getLogger()");
                URL uRL = logger.getClass().getResource("/log4j.properties");
                this.printLoggerInfo(logger);
                System.out.println("Properties URL=" + uRL);
                System.out.println("  path=" + uRL.getPath());
                System.out.println("  file=" + uRL.getFile());
                System.out.println("  protocol=" + uRL.getProtocol());
                System.out.println("  contents=");
                try {
                    stringArray = uRL.openStream();
                    object = new BufferedReader(new InputStreamReader((InputStream)stringArray));
                    String string = null;
                    System.out.println("-------------------------------------");
                    while ((string = ((BufferedReader)object).readLine()) != null) {
                        System.out.println(string);
                    }
                    System.out.println("-------------------------------------");
                }
                catch (IOException iOException) {
                    System.err.println("Cannot open input stream for " + uRL);
                }
                stringArray = new String[]{"log4j.rootLogger", "log4j.appender.default", "log4j.appender.default.layout", "log4j.appender.default.layout.ConversionPattern"};
                int n = 0;
                while (n < stringArray.length) {
                    object = System.getProperty(stringArray[n], "Not found");
                    System.out.println(String.valueOf(stringArray[n]) + "=" + (String)object);
                    ++n;
                }
                System.out.println("\nTests [5 total messages]");
                logger.trace("Trace Message");
                logger.debug("Debug Message");
                logger.info("Info Message");
                logger.warn("Warning Message");
                logger.error("Error Message");
                System.out.printf("\nClass Logger (%s)\n", ((Object)((Object)this)).getClass().toString());
                logger = FableLogger.getLogger(((Object)((Object)this)).getClass());
                this.printLoggerInfo(logger);
                System.out.println("\nTests [5 total messages]");
                logger.trace("Trace Message");
                logger.debug("Debug Message");
                logger.info("Info Message");
                logger.warn("Warning Message");
                logger.error("Error Message");
            }

            private void printLoggerInfo(Logger logger) {
            }
        };
        return action;
    }

    private static Action createLoggingLevelTestAction() {
        Action action = new Action("Test Logging Level"){

            public void run() {
                Logger logger = FableLogger.getLogger();
                System.out.println("\nFableLogger.getLogger()");
                System.out.println("logger=" + logger);
                System.out.println("name=" + logger.getName());
                System.out.println("\nException test");
                try {
                    Double.parseDouble("garbage");
                }
                catch (NumberFormatException numberFormatException) {
                    FableLogger.error((String)"Intentional exception generated", (Throwable)numberFormatException);
                }
                System.out.println("\nFable Logger Tests [6 total messages]");
                FableLogger.trace((String)"Fable Logger Trace Message");
                FableLogger.debug((String)"Fable Logger Debug Message");
                FableLogger.info((String)"Fable Logger Info Message");
                FableLogger.warn((String)"Fable Logger Warning Message");
                FableLogger.error((String)"Fable Logger Error Message");
                System.out.println("\nRoot Logger Tests [6 total messages]");
                logger.trace("Root Logger Trace Message");
                logger.debug("Root Logger Debug Message");
                logger.info("Root Logger Info Message");
                logger.warn("Root Logger Warning Message");
                logger.error("Root Logger Error Message");
            }
        };
        return action;
    }
}

