/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class MainStatusBar
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 40;
    public static final int DEFAULT_CHAR_HEIGHT = 40;
    private CLabel label;
    private Image image;
    private String text = "";
    private int widthHint = -1;
    private int heightHint = -1;
    private Listener listener;
    private int eventType;
    private String tooltip;

    public MainStatusBar(String string) {
        this(string, 40);
    }

    public MainStatusBar(String string, int n) {
        super(string);
        this.widthHint = n;
        this.setVisible(false);
    }

    public void dispose() {
        super.dispose();
    }

    public void fill(Composite composite) {
        Label label = new Label(composite, 2);
        this.label = new CLabel(composite, 32);
        GC gC = new GC((Drawable)composite);
        gC.setFont(composite.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        Point point = gC.textExtent(this.text);
        int n = this.widthHint > 0 ? fontMetrics.getAverageCharWidth() * this.widthHint : point.x;
        this.heightHint = fontMetrics.getHeight();
        gC.dispose();
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = n;
        statusLineLayoutData.heightHint = this.heightHint;
        this.label.setLayoutData((Object)statusLineLayoutData);
        this.label.setText(this.text);
        this.label.setImage(this.image);
        if (this.listener != null) {
            this.label.addListener(this.eventType, this.listener);
        }
        if (this.tooltip != null) {
            this.label.setToolTipText(this.tooltip);
        }
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = this.heightHint * 2;
        label.setLayoutData((Object)statusLineLayoutData);
    }

    public void setText(String string) {
        if (string != null) {
            this.text = string;
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setText(this.text);
            }
            if (this.text.length() == 0) {
                if (this.isVisible()) {
                    this.setVisible(false);
                    IContributionManager iContributionManager = this.getParent();
                    if (iContributionManager != null) {
                        iContributionManager.update(true);
                    }
                }
            } else if (!this.isVisible()) {
                this.setVisible(true);
                IContributionManager iContributionManager = this.getParent();
                if (iContributionManager != null) {
                    iContributionManager.update(true);
                }
            }
        }
    }

    public void setTooltip(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.tooltip = string;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setToolTipText(this.tooltip);
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setImage(this.image);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager iContributionManager = this.getParent();
            if (iContributionManager != null) {
                iContributionManager.update(true);
            }
        }
    }
}

