/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.internal;

import fable.framework.ui.actions.UpdateAction;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class MainMenuBar
extends ActionBarAdvisor {
    private static final boolean DO_TESTS = false;
    public MenuManager fileMenu;
    public MenuManager editMenu;
    public MenuManager windowMenu;
    public MenuManager helpMenu;
    private ActionFactory.IWorkbenchAction newAction;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction newWorkbenchAction;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private ActionFactory.IWorkbenchAction perspectiveCustomizeAction;
    private ActionFactory.IWorkbenchAction perspectiveSaveAsAction;
    private ActionFactory.IWorkbenchAction perspectiveResetAction;
    private ActionFactory.IWorkbenchAction perspectiveCloseAction;
    private ActionFactory.IWorkbenchAction perspectiveCloseAllAction;
    private ActionFactory.IWorkbenchAction helpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private IContributionItem viewsShortList;
    private IContributionItem perspectivesShortList;
    private UpdateAction updateAction;
    private ActionFactory.IWorkbenchAction exportProject;
    private ActionFactory.IWorkbenchAction importProject;

    public MainMenuBar(IActionBarConfigurer iActionBarConfigurer) {
        super(iActionBarConfigurer);
    }

    public void makeActions(IWorkbenchWindow iWorkbenchWindow) {
        this.newAction = ActionFactory.NEW.create(iWorkbenchWindow);
        this.register((IAction)this.newAction);
        this.exitAction = ActionFactory.QUIT.create(iWorkbenchWindow);
        this.register((IAction)this.exitAction);
        this.newWorkbenchAction = ActionFactory.OPEN_NEW_WINDOW.create(iWorkbenchWindow);
        this.register((IAction)this.newWorkbenchAction);
        this.perspectivesShortList = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(iWorkbenchWindow);
        this.viewsShortList = ContributionItemFactory.VIEWS_SHORTLIST.create(iWorkbenchWindow);
        this.perspectiveCustomizeAction = ActionFactory.EDIT_ACTION_SETS.create(iWorkbenchWindow);
        this.register((IAction)this.perspectiveCustomizeAction);
        this.perspectiveSaveAsAction = ActionFactory.SAVE_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.perspectiveSaveAsAction);
        this.perspectiveResetAction = ActionFactory.RESET_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.perspectiveResetAction);
        this.perspectiveCloseAction = ActionFactory.CLOSE_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.perspectiveCloseAction);
        this.perspectiveCloseAllAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(iWorkbenchWindow);
        this.register((IAction)this.perspectiveCloseAllAction);
        this.preferencesAction = ActionFactory.PREFERENCES.create(iWorkbenchWindow);
        this.register((IAction)this.preferencesAction);
        this.helpAction = ActionFactory.HELP_CONTENTS.create(iWorkbenchWindow);
        this.register((IAction)this.helpAction);
        this.aboutAction = ActionFactory.ABOUT.create(iWorkbenchWindow);
        this.register((IAction)this.aboutAction);
        this.updateAction = new UpdateAction(iWorkbenchWindow);
        this.register(this.updateAction);
        this.registerAsGlobal((IAction)ActionFactory.SAVE.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.SAVE_AS.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.ABOUT.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.SAVE_ALL.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.UNDO.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.REDO.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.CUT.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.COPY.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.PASTE.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.SELECT_ALL.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.FIND.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL_SAVED.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.REVERT.create(iWorkbenchWindow));
        this.registerAsGlobal((IAction)ActionFactory.QUIT.create(iWorkbenchWindow));
        this.exportProject = ActionFactory.EXPORT.create(iWorkbenchWindow);
        this.register((IAction)this.exportProject);
        this.importProject = ActionFactory.IMPORT.create(iWorkbenchWindow);
        this.register((IAction)this.importProject);
    }

    public void fillMenuBar(IMenuManager iMenuManager) {
        this.createMenuFile();
        iMenuManager.add((IContributionItem)this.fileMenu);
        this.createMenuEdit();
        iMenuManager.add((IContributionItem)this.editMenu);
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
        this.createMenuWindows();
        iMenuManager.add((IContributionItem)this.windowMenu);
        iMenuManager.add((IContributionItem)new GroupMarker("help"));
        this.createMenuHelp();
        iMenuManager.add((IContributionItem)this.helpMenu);
    }

    public void fillCoolBar(ICoolBarManager iCoolBarManager) {
        iCoolBarManager.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager toolBarManager = new ToolBarManager(iCoolBarManager.getStyle());
        toolBarManager.add((IContributionItem)new Separator("new.group"));
        toolBarManager.add((IContributionItem)new GroupMarker("open.ext"));
        toolBarManager.add((IContributionItem)new GroupMarker("save.group"));
        toolBarManager.add(this.getAction(ActionFactory.SAVE.getId()));
        toolBarManager.add(this.getAction(ActionFactory.SAVE_AS.getId()));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        iCoolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarManager, "org.eclipse.ui.workbench.file"));
        iCoolBarManager.add((IContributionItem)new GroupMarker("additions"));
        iCoolBarManager.add((IContributionItem)new GroupMarker("group.editor"));
    }

    private void registerAsGlobal(IAction iAction) {
        this.getActionBarConfigurer().registerGlobalAction(iAction);
        this.register(iAction);
    }

    private void createMenuFile() {
        this.fileMenu = new MenuManager("&File", "file");
        MenuManager menuManager = new MenuManager("New", "project");
        this.fileMenu.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.newAction);
        this.fileMenu.add((IContributionItem)new GroupMarker("fileStart"));
        this.fileMenu.add((IContributionItem)new GroupMarker("new.ext"));
        this.fileMenu.add(this.getAction(ActionFactory.CLOSE.getId()));
        this.fileMenu.add(this.getAction(ActionFactory.CLOSE_ALL.getId()));
        this.fileMenu.add((IContributionItem)new GroupMarker("close.ext"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add(this.getAction(ActionFactory.SAVE.getId()));
        this.fileMenu.add(this.getAction(ActionFactory.SAVE_AS.getId()));
        this.fileMenu.add(this.getAction(ActionFactory.SAVE_ALL.getId()));
        this.fileMenu.add((IContributionItem)new GroupMarker("import.ext"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add((IAction)this.exportProject);
        this.fileMenu.add((IAction)this.importProject);
        this.fileMenu.add(this.getAction(ActionFactory.REVERT.getId()));
        this.fileMenu.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getActionBarConfigurer().getWindowConfigurer().getWindow()));
        this.fileMenu.add((IContributionItem)new GroupMarker("mru"));
        this.fileMenu.add((IContributionItem)new Separator());
        this.fileMenu.add(this.getAction(ActionFactory.QUIT.getId()));
        this.fileMenu.add((IContributionItem)new GroupMarker("fileEnd"));
    }

    private void createMenuEdit() {
        this.editMenu = new MenuManager("&Edit", "edit");
        this.editMenu.add((IContributionItem)new GroupMarker("editStart"));
        this.editMenu.add(this.getAction(ActionFactory.UNDO.getId()));
        this.editMenu.add(this.getAction(ActionFactory.REDO.getId()));
        this.editMenu.add((IContributionItem)new GroupMarker("undo.ext"));
        this.editMenu.add(this.getAction(ActionFactory.CUT.getId()));
        this.editMenu.add(this.getAction(ActionFactory.COPY.getId()));
        this.editMenu.add(this.getAction(ActionFactory.PASTE.getId()));
        this.editMenu.add((IContributionItem)new GroupMarker("cut.ext"));
        this.editMenu.add(this.getAction(ActionFactory.SELECT_ALL.getId()));
        this.editMenu.add((IContributionItem)new Separator());
        this.editMenu.add(this.getAction(ActionFactory.FIND.getId()));
        this.editMenu.add((IContributionItem)new GroupMarker("find.ext"));
        this.editMenu.add((IContributionItem)new GroupMarker("add.ext"));
        this.editMenu.add((IContributionItem)new GroupMarker("editEnd"));
        this.editMenu.add((IContributionItem)new Separator("additions"));
    }

    private void createMenuWindows() {
        this.windowMenu = new MenuManager("&Window", "window");
        this.windowMenu.add((IAction)this.newWorkbenchAction);
        this.windowMenu.add((IContributionItem)new Separator());
        MenuManager menuManager = new MenuManager("Open Perspective");
        this.windowMenu.add((IContributionItem)menuManager);
        menuManager.add(this.perspectivesShortList);
        MenuManager menuManager2 = new MenuManager("Show View");
        menuManager2.add(this.viewsShortList);
        this.windowMenu.add((IContributionItem)menuManager2);
        this.windowMenu.add((IContributionItem)new Separator());
        this.windowMenu.add((IAction)this.perspectiveCustomizeAction);
        this.windowMenu.add((IAction)this.perspectiveSaveAsAction);
        this.windowMenu.add((IAction)this.perspectiveResetAction);
        this.windowMenu.add((IAction)this.perspectiveCloseAction);
        this.windowMenu.add((IAction)this.perspectiveCloseAllAction);
        this.windowMenu.add((IContributionItem)new Separator());
        this.windowMenu.add((IAction)this.preferencesAction);
    }

    private void createMenuHelp() {
        this.helpMenu = new MenuManager("&Help", "help");
        this.helpMenu.add((IAction)this.helpAction);
        this.helpMenu.add((IAction)this.updateAction);
        this.helpMenu.add((IContributionItem)new GroupMarker("additions"));
        this.helpMenu.add((IContributionItem)new Separator());
        this.helpMenu.add((IAction)this.aboutAction);
    }

    public void dispose() {
        super.dispose();
        this.aboutAction.dispose();
        this.exitAction.dispose();
        this.helpAction.dispose();
        this.newAction.dispose();
        this.newWorkbenchAction.dispose();
        this.perspectiveCustomizeAction.dispose();
        this.perspectiveSaveAsAction.dispose();
        this.perspectiveResetAction.dispose();
        this.perspectiveCloseAction.dispose();
        this.perspectiveCloseAllAction.dispose();
        this.preferencesAction.dispose();
    }
}

