/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.handlers;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.editors.ColumnFileEditor;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.editors.ColumnFilePlotEditor;
import fable.framework.views.FableIOConsole;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenColumnFileEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        final IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)executionEvent);
        if (iWorkbenchWindow == null) {
            FableUtils.errMsg((Object)((Object)this), (String)"Cannot determine the workbench window");
            return null;
        }
        FileDialog fileDialog = new FileDialog(iWorkbenchWindow.getShell(), 2);
        fileDialog.setFilterNames(new String[]{"*.flt", "All Files (*.*)"});
        fileDialog.setFilterExtensions(new String[]{"*.flt", "*.*"});
        if (fileDialog.open() != null) {
            String string = fileDialog.getFilterPath();
            String[] stringArray = fileDialog.getFileNames();
            int n = 0;
            while (n < stringArray.length) {
                final String string2 = stringArray[n];
                final String string3 = String.valueOf(string) + File.separatorChar + stringArray[n];
                Job job = new Job("Load column file job " + string2){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask("Please wait while loading file in editor " + string2, -1);
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        iProgressMonitor.done();
                        ColumnFileEditorInput columnFileEditorInput = new ColumnFileEditorInput(string3);
                        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                        OpenColumnFileEditorHandler.openEditors(columnFileEditorInput, iWorkbenchPage);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        if (iJobChangeEvent.getResult().isOK()) {
                            if (FableIOConsole.console != null) {
                                FableIOConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " completed successfully");
                            }
                        } else if (FableIOConsole.console != null) {
                            FableIOConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " did not complete successfully");
                        }
                    }
                });
                ++n;
            }
        }
        return null;
    }

    public static void openEditors(final IEditorInput iEditorInput, final IWorkbenchPage iWorkbenchPage) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (iWorkbenchPage != null) {
                    String string = ColumnFileEditor.getId();
                    try {
                        iWorkbenchPage.openEditor(iEditorInput, string, true);
                    }
                    catch (PartInitException partInitException) {
                        FableUtils.errMsg((Object)this, (String)partInitException.getMessage());
                    }
                    String string2 = ColumnFilePlotEditor.getId();
                    try {
                        iWorkbenchPage.openEditor(iEditorInput, string2, true);
                    }
                    catch (PartInitException partInitException) {
                        FableUtils.errMsg((Object)this, (String)partInitException.getMessage());
                    }
                }
            }
        });
    }
}

