/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.editors;

import fable.framework.ui.actions.SaveAsColumnFileEditorAction;
import fable.framework.ui.actions.SaveColumnFileEditorAction;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.editors.IColumnFileEditor;
import fable.framework.ui.views.ColFileXYPlot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class ColumnFilePlotEditor
extends EditorPart
implements ISelectionListener,
IPropertyChangeListener,
IColumnFileEditor {
    private ColFileXYPlot xyplot;
    private static final String ID = "fable.framework.ui.ColumnFilePlotEditor";
    private ColumnFileEditorInput columnInput;
    private boolean dirty = false;
    private SaveColumnFileEditorAction saveAction;
    private SaveAsColumnFileEditorAction saveasAction;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        IPath iPath;
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        if (iEditorInput instanceof ColumnFileEditorInput) {
            this.columnInput = (ColumnFileEditorInput)iEditorInput;
        } else if (iEditorInput instanceof FileEditorInput && (iPath = ((FileEditorInput)iEditorInput).getPath()) != null) {
            this.columnInput = new ColumnFileEditorInput(iPath.toString());
        }
        if (this.columnInput != null) {
            this.setPartName(this.columnInput.getColumn().getFileName());
            this.columnInput.getColumn().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        this.xyplot = new ColFileXYPlot(composite, "", "X", "Y");
        this.xyplot.addColumnFile(this.columnInput.getColumn());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.makeActions();
    }

    private void makeActions() {
        this.saveAction = new SaveColumnFileEditorAction(){

            @Override
            public void run(IColumnFileEditor iColumnFileEditor) {
                ((ColumnFilePlotEditor)iColumnFileEditor).doSave(null);
            }
        };
        this.saveAction.setProps("Save column file");
        this.saveasAction = new SaveAsColumnFileEditorAction(){

            @Override
            public void run(IColumnFileEditor iColumnFileEditor) {
                ((ColumnFilePlotEditor)iColumnFileEditor).doSaveAs();
            }
        };
        this.saveasAction.setProps("Save column file as...");
    }

    public void setFocus() {
    }

    public ColFileXYPlot getxyPlot() {
        return this.xyplot;
    }

    public void dispose() {
        try {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
            this.columnInput.getColumn().removePropertyrChangeListener((IPropertyChangeListener)this);
            if (this.xyplot != null) {
                this.xyplot.dispose();
            }
            this.xyplot = null;
        }
        finally {
            super.dispose();
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart != this && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object object = iStructuredSelection.getFirstElement();
            Object[] objectArray = iStructuredSelection.toArray();
            if (object instanceof float[]) {
                float[] fArray = (float[])object;
                double[] dArray = null;
                if (this.columnInput.getColumn() != null) {
                    int n = this.columnInput.getColumn().getColumnIDIndex();
                    if (objectArray.length > 1 && n >= 0) {
                        dArray = new double[objectArray.length];
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            dArray[n2] = ((float[])objectArray[n2])[n];
                            ++n2;
                        }
                    } else if (n >= 0) {
                        dArray = new double[]{fArray[n]};
                    }
                    if (dArray != null && dArray.length > 0) {
                        this.xyplot.markSelectedRows(dArray, this.columnInput.getColumn().getColumnfileId());
                    }
                }
            }
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.columnInput.save();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        if (this.columnInput.saveAs()) {
            this.dirty = false;
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return this.dirty;
    }

    public static String getId() {
        return ID;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("updateColumn")) {
            this.dirty = true;
            this.firePropertyChange(257);
            this.xyplot.updateChart();
        } else if (propertyChangeEvent.getProperty().equals("propdirty")) {
            this.dirty = (Boolean)propertyChangeEvent.getNewValue();
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        } else if (propertyChangeEvent.getProperty().equals("AddColumn")) {
            this.xyplot.addColumnFile(this.columnInput.getColumn());
        }
    }
}

